/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.mesos.chronos;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.mesos.chronos.ChronosTaskLauncherProperties;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import org.springframework.cloud.mesos.chronos.client.Chronos;
import org.springframework.cloud.mesos.chronos.client.ChronosException;
import org.springframework.cloud.mesos.chronos.client.model.DockerContainer;
import org.springframework.cloud.mesos.chronos.client.model.DockerJob;
import org.springframework.cloud.mesos.chronos.client.model.Job;
import org.springframework.util.StringUtils;

public class ChronosTaskLauncher
implements TaskLauncher {
    private static final Log logger = LogFactory.getLog(ChronosTaskLauncher.class);
    private ChronosTaskLauncherProperties properties = new ChronosTaskLauncherProperties();
    private Chronos chronos;

    public ChronosTaskLauncher(ChronosTaskLauncherProperties properties, Chronos chronos) {
        this.properties = properties;
        this.chronos = chronos;
    }

    public String launch(AppDeploymentRequest request) {
        String jobName = this.createDeploymentId(request);
        String image = null;
        try {
            image = request.getResource().getURI().getSchemeSpecificPart();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get URI for " + request.getResource(), e);
        }
        logger.info((Object)("Using Docker image: " + image));
        DockerJob job = new DockerJob();
        job.setName(jobName);
        ArrayList<Map<String, String>> envVars = new ArrayList<Map<String, String>>();
        Map<String, String> springApplicationJson = this.createSpringApplicationJson(request);
        if (springApplicationJson.size() > 0) {
            envVars.add(springApplicationJson);
        }
        logger.info((Object)("Using env: " + envVars));
        if (envVars.size() > 0) {
            job.setEnvironmentVariables(envVars);
        }
        job.setShell(false);
        job.setCommand("");
        List<String> args = this.createCommandArgs(request);
        if (args.size() > 0) {
            job.setArguments(args);
        }
        job.setSchedule("R1//P");
        job.setRetries(1);
        DockerContainer container = new DockerContainer();
        container.setImage(image);
        job.setContainer(container);
        Double cpus = this.deduceCpus(request);
        Double memory = this.deduceMemory(request);
        job.setCpus(cpus);
        job.setMem(memory);
        if (StringUtils.hasText((String)this.properties.getOwnerEmail())) {
            job.setOwner(this.properties.getOwnerEmail());
        }
        if (StringUtils.hasText((String)this.properties.getOwnerName())) {
            job.setOwnerName(this.properties.getOwnerName());
        }
        if (this.properties.getUris() != null && this.properties.getUris().length > 0) {
            job.setUris(Arrays.asList(this.properties.getUris()));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Launching Job with definition:\n" + job.toString()));
            }
            this.chronos.createDockerJob(job);
        }
        catch (ChronosException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException(String.format("Error while creating job '%s'", jobName), e);
        }
        return jobName;
    }

    public void cancel(String id) {
        try {
            this.chronos.deleteJobTasks(id);
        }
        catch (ChronosException e) {
            throw new IllegalStateException(String.format("Error while canceling job '%s'", id), e);
        }
    }

    public TaskStatus status(String id) {
        String csv = null;
        try {
            csv = this.chronos.getGraphCsv();
        }
        catch (ChronosException e) {
            throw new IllegalStateException(String.format("Error while retrieving graph", new Object[0]), e);
        }
        List<Job> list = null;
        try {
            list = this.chronos.getJobs();
        }
        catch (ChronosException e) {
            throw new IllegalStateException(String.format("Error while retrieving jobs", new Object[0]), e);
        }
        Job job = null;
        for (Job j : list) {
            if (!j.getName().equals(id)) continue;
            job = j;
        }
        TaskStatus status = this.buildTaskStatus(this.properties, id, job, csv);
        logger.debug((Object)String.format("Status for task: %s is %s", id, status));
        return status;
    }

    public void cleanup(String ... id) {
        HashSet<String> ids = new HashSet<String>(Arrays.asList(id));
        for (String jobName : ids) {
            try {
                this.chronos.deleteJob(jobName);
            }
            catch (ChronosException e) {
                throw new IllegalStateException(String.format("Error while deleting job '%s'", jobName), e);
            }
        }
    }

    protected String createDeploymentId(AppDeploymentRequest request) {
        return request.getDefinition().getName();
    }

    protected Map<String, String> createSpringApplicationJson(AppDeploymentRequest request) {
        String value = "{}";
        try {
            value = new ObjectMapper().writeValueAsString(Optional.ofNullable(request.getDefinition().getProperties()).orElse(Collections.emptyMap()));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        HashMap<String, String> springApp = new HashMap<String, String>();
        if (!"{}".equals(value)) {
            springApp.put("name", "SPRING_APPLICATION_JSON");
            springApp.put("value", value);
        }
        return springApp;
    }

    protected List<String> createCommandArgs(AppDeploymentRequest request) {
        LinkedList<String> cmdArgs = new LinkedList<String>();
        cmdArgs.addAll(request.getCommandlineArguments());
        logger.debug((Object)("Using command args: " + cmdArgs));
        return cmdArgs;
    }

    protected TaskStatus buildTaskStatus(ChronosTaskLauncherProperties properties, String id, Job job, String csv) {
        if (job == null) {
            return new TaskStatus(id, LaunchState.unknown, new HashMap());
        }
        String last = null;
        String state = null;
        if (StringUtils.hasText((String)csv)) {
            List<String> csvLines = Arrays.asList(csv.split("\\r?\\n"));
            for (String line : csvLines) {
                List<String> values;
                if (!line.startsWith("node") || (values = Arrays.asList(line.split("\\s*,\\s*"))).size() < 4 || !id.equals(values.get(1))) continue;
                last = values.get(2);
                state = values.get(3);
                break;
            }
        }
        if ("running".equals(state)) {
            return new TaskStatus(id, LaunchState.running, new HashMap());
        }
        if ("queued".equals(state)) {
            return new TaskStatus(id, LaunchState.launching, new HashMap());
        }
        if ("success".equals(last)) {
            return new TaskStatus(id, LaunchState.complete, new HashMap());
        }
        return new TaskStatus(id, LaunchState.failed, new HashMap());
    }

    private Double deduceMemory(AppDeploymentRequest request) {
        String override = (String)request.getDeploymentProperties().get("spring.cloud.deployer.chronos.memory");
        return override != null ? Double.valueOf(override).doubleValue() : this.properties.getMemory();
    }

    private Double deduceCpus(AppDeploymentRequest request) {
        String override = (String)request.getDeploymentProperties().get("spring.cloud.deployer.chronos.cpu");
        return override != null ? Double.valueOf(override).doubleValue() : this.properties.getCpu();
    }
}

