/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.util.StringUtils;

public class DebugAddress {
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$");
    private static final Pattern IP_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern PORT_PATTERN = Pattern.compile("^([0-9]{1,4}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$");
    public static final Logger logger = LoggerFactory.getLogger(DebugAddress.class);
    private final String host;
    private final String port;
    private final String address;
    private final String suspend;

    private DebugAddress(String host, int port, String suspend) {
        this.host = host;
        this.port = "" + port;
        this.suspend = StringUtils.hasText((String)suspend) ? suspend.trim() : "y";
        this.address = StringUtils.hasText((String)host) ? String.format("%s:%s", host, port) : this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getSuspend() {
        return this.suspend;
    }

    public String getAddress() {
        return this.address;
    }

    public static Optional<DebugAddress> from(LocalDeployerProperties deployerProperties, int instanceNumber) {
        if (!StringUtils.hasText((String)deployerProperties.getDebugAddress()) && deployerProperties.getDebugPort() == null) {
            return Optional.empty();
        }
        String debugHost = null;
        String debugPort = ("" + deployerProperties.getDebugPort()).trim();
        if (StringUtils.hasText((String)deployerProperties.getDebugAddress())) {
            String[] addressParts = deployerProperties.getDebugAddress().split(":");
            if (addressParts.length == 1) {
                debugPort = addressParts[0].trim();
            } else if (addressParts.length == 2) {
                debugHost = addressParts[0].trim();
                debugPort = addressParts[1].trim();
                if (!("*".equals(debugHost) || HOSTNAME_PATTERN.matcher(debugHost).matches() || IP_PATTERN.matcher(debugHost).matches())) {
                    logger.warn("Invalid debug Host: {}", (Object)deployerProperties.getDebugAddress());
                    return Optional.empty();
                }
            } else {
                logger.warn("Invalid debug address: {}", (Object)deployerProperties.getDebugAddress());
                return Optional.empty();
            }
        }
        if (!PORT_PATTERN.matcher(debugPort).matches()) {
            logger.warn("Invalid debug port: {}", (Object)debugPort);
            return Optional.empty();
        }
        int portToUse = Integer.parseInt(debugPort) + instanceNumber;
        return Optional.of(new DebugAddress(debugHost, portToUse, deployerProperties.getDebugSuspend().toString()));
    }
}

