/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.local.DockerCommandBuilder;
import org.springframework.cloud.deployer.spi.local.JavaCommandBuilder;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.cloud.deployer.spi.local.LocalDeployerUtils;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractLocalDeployerSupport {
    protected static Set<Integer> usedPorts = Collections.newSetFromMap(new LinkedHashMap<Integer, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Boolean> eldest) {
            return this.size() > 1000;
        }
    });
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SPRING_APPLICATION_JSON = "SPRING_APPLICATION_JSON";
    public static final int DEFAULT_SERVER_PORT = 8080;
    private static final String USE_SPRING_APPLICATION_JSON_KEY = "spring.cloud.deployer.local.use-spring-application-json";
    static final String SERVER_PORT_KEY = "server.port";
    static final String SERVER_PORT_KEY_COMMAND_LINE_ARG = "--server.port=";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final LocalDeployerProperties properties;
    private final RestTemplate restTemplate;
    private final JavaCommandBuilder javaCommandBuilder;
    private final DockerCommandBuilder dockerCommandBuilder;

    public AbstractLocalDeployerSupport(LocalDeployerProperties properties) {
        Assert.notNull((Object)properties, (String)"LocalDeployerProperties must not be null");
        this.properties = properties;
        this.javaCommandBuilder = new JavaCommandBuilder(properties);
        this.dockerCommandBuilder = new DockerCommandBuilder();
        this.restTemplate = this.buildRestTemplate(properties);
    }

    protected RestTemplate buildRestTemplate(LocalDeployerProperties properties) {
        if (properties != null && properties.getShutdownTimeout() > -1) {
            SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
            clientHttpRequestFactory.setConnectTimeout(properties.getShutdownTimeout() * 1000);
            clientHttpRequestFactory.setReadTimeout(properties.getShutdownTimeout() * 1000);
            return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        }
        return new RestTemplate();
    }

    protected String buildRemoteDebugInstruction(LocalDeployerProperties deployerProperties, String deploymentId, int instanceIndex, int port) {
        String ds = "y";
        if (StringUtils.hasText((String)deployerProperties.getDebugSuspend())) {
            ds = deployerProperties.getDebugSuspend();
        }
        StringBuilder debugCommandBuilder = new StringBuilder();
        this.logger.warn("Deploying app with deploymentId {}, instance {}. Remote debugging is enabled on port {}.", new Object[]{deploymentId, instanceIndex, port});
        debugCommandBuilder.append("-agentlib:jdwp=transport=dt_socket,server=y,suspend=");
        debugCommandBuilder.append(ds.trim());
        debugCommandBuilder.append(",address=");
        debugCommandBuilder.append(port);
        String debugCommand = debugCommandBuilder.toString();
        this.logger.debug("Deploying app with deploymentId {}, instance {}.  Debug Command = [{}]", (Object)debugCommand);
        if (ds.equals("y")) {
            this.logger.warn("Deploying app with deploymentId {}.  Application Startup will be suspended until remote debugging session is established.");
        }
        return debugCommand;
    }

    protected RuntimeEnvironmentInfo createRuntimeEnvironmentInfo(Class<?> spiClass, Class<?> implementationClass) {
        return new RuntimeEnvironmentInfo.Builder().spiClass(spiClass).implementationName(implementationClass.getSimpleName()).implementationVersion(RuntimeVersionUtils.getVersion(implementationClass)).platformType("Local").platformApiVersion(System.getProperty("os.name") + " " + System.getProperty("os.version")).platformClientVersion(System.getProperty("os.version")).platformHostVersion(System.getProperty("os.version")).build();
    }

    protected final LocalDeployerProperties getLocalDeployerProperties() {
        return this.properties;
    }

    protected ProcessBuilder buildProcessBuilder(AppDeploymentRequest request, Map<String, String> appInstanceEnv, Optional<Integer> appInstanceNumber, String deploymentId) {
        LocalDeployerProperties bindDeployerProperties;
        Assert.notNull((Object)request, (String)"AppDeploymentRequest must be set");
        Map<String, String> appPropertiesToUse = this.formatApplicationProperties(request, appInstanceEnv);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Preparing to run an application from {}. This may take some time if the artifact must be downloaded from a remote host.", (Object)request.getResource());
        }
        String[] commands = request.getResource() instanceof DockerResource ? this.dockerCommandBuilder.buildExecutionCommand(request, appPropertiesToUse, appInstanceNumber) : this.javaCommandBuilder.buildExecutionCommand(request, appPropertiesToUse, appInstanceNumber);
        if (LocalDeployerUtils.isWindows()) {
            for (int i = 0; i < commands.length; ++i) {
                commands[i] = commands[i].replace("\"", "\\\"");
            }
        }
        ProcessBuilder builder = new ProcessBuilder(commands);
        if (!(request.getResource() instanceof DockerResource)) {
            builder.environment().putAll(appPropertiesToUse);
        }
        if (this.containsValidDebugPort(bindDeployerProperties = this.bindDeploymentProperties(request.getDeploymentProperties()), deploymentId)) {
            int portToUse = this.calculateDebugPort(bindDeployerProperties, appInstanceNumber.orElse(0));
            String debugInstruction = this.buildRemoteDebugInstruction(bindDeployerProperties, deploymentId, appInstanceNumber.orElse(0), portToUse);
            if (request.getResource() instanceof DockerResource) {
                builder.command().add(2, "-e");
                builder.command().add(3, "JAVA_TOOL_OPTIONS=" + debugInstruction);
            } else {
                builder.command().add(1, debugInstruction);
            }
        }
        this.logger.info(String.format("Command to be executed: %s", String.join((CharSequence)" ", builder.command())));
        this.logger.debug(String.format("Environment Variables to be used : %s", builder.environment().entrySet().stream().map(entry -> (String)entry.getKey() + " : " + (String)entry.getValue()).collect(Collectors.joining(", "))));
        return builder;
    }

    private LocalDeployerProperties bindDeploymentProperties(Map<String, String> properties) {
        return (LocalDeployerProperties)new Binder(new ConfigurationPropertySource[]{new MapConfigurationPropertySource(properties)}).bind("spring.cloud.deployer.local", Bindable.of(LocalDeployerProperties.class)).orElseCreate(LocalDeployerProperties.class);
    }

    protected Map<String, String> formatApplicationProperties(AppDeploymentRequest request, Map<String, String> appInstanceEnvToUse) {
        HashMap<String, String> applicationPropertiesToUse = new HashMap<String, String>(appInstanceEnvToUse);
        if (this.useSpringApplicationJson(request)) {
            try {
                if (applicationPropertiesToUse.containsKey(SPRING_APPLICATION_JSON)) {
                    applicationPropertiesToUse.putAll((Map)OBJECT_MAPPER.readValue((String)applicationPropertiesToUse.get(SPRING_APPLICATION_JSON), (TypeReference)new TypeReference<HashMap<String, Object>>(){}));
                    applicationPropertiesToUse.remove(SPRING_APPLICATION_JSON);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read existing SPRING_APPLICATION_JSON to merge properties", e);
            }
            try {
                String saj = OBJECT_MAPPER.writeValueAsString(applicationPropertiesToUse);
                applicationPropertiesToUse = new HashMap(1);
                applicationPropertiesToUse.put(SPRING_APPLICATION_JSON, saj);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Unable to create SPRING_APPLICATION_JSON from application properties", e);
            }
        }
        return applicationPropertiesToUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownAndWait(Instance instance) {
        try {
            int timeout = this.getLocalDeployerProperties().getShutdownTimeout();
            if (timeout > 0) {
                this.logger.debug("About to call shutdown endpoint for the instance {}", (Object)instance);
                ResponseEntity response = this.restTemplate.postForEntity(instance.getBaseUrl() + "/shutdown", null, String.class, new Object[0]);
                this.logger.debug("Response for shutdown endpoint completed for the instance {} with response {}", (Object)instance, (Object)response);
                if (response.getStatusCode().is2xxSuccessful()) {
                    long timeoutTimestamp = System.currentTimeMillis() + (long)(timeout * 1000);
                    while (this.isAlive(instance.getProcess()) && System.currentTimeMillis() < timeoutTimestamp) {
                        Thread.sleep(1000L);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            if (this.isAlive(instance.getProcess())) {
                this.logger.debug("About to call destroy the process for the instance {}", (Object)instance);
                instance.getProcess().destroy();
                this.logger.debug("Call completed to destroy the process for the instance {}", (Object)instance);
            }
        }
    }

    protected boolean isAlive(Process process) {
        try {
            this.logger.debug("About to call exitValue of the process {}", (Object)process);
            process.exitValue();
            this.logger.debug("Call to exitValue of the process {} complete, return false", (Object)process);
            return false;
        }
        catch (IllegalThreadStateException e) {
            this.logger.debug("Call to exitValue of the process {} threw exception, return true", (Object)process);
            return true;
        }
    }

    protected boolean containsValidDebugPort(LocalDeployerProperties deployerProperties, String deploymentId) {
        boolean validDebugPort = false;
        if (deployerProperties.getDebugPort() != null) {
            if (deployerProperties.getDebugPort() <= 0) {
                this.logger.error("The debug port {} specified for deploymentId {} must be greater than zero");
                return false;
            }
            validDebugPort = true;
        }
        return validDebugPort;
    }

    protected int calculateDebugPort(LocalDeployerProperties deployerProperties, int instanceIndex) {
        return deployerProperties.getDebugPort() + instanceIndex;
    }

    protected boolean useSpringApplicationJson(AppDeploymentRequest request) {
        return request.getDefinition().getProperties().containsKey(USE_SPRING_APPLICATION_JSON_KEY) || this.properties.isUseSpringApplicationJson();
    }

    protected int calcServerPort(AppDeploymentRequest request, boolean useDynamicPort, Map<String, String> appInstanceEnvVars) {
        int port = 8080;
        Integer commandLineArgPort = this.isServerPortKeyPresentOnArgs(request);
        if (useDynamicPort) {
            port = this.getRandomPort();
        } else if (commandLineArgPort != null) {
            port = commandLineArgPort;
        } else if (request.getDefinition().getProperties().containsKey(SERVER_PORT_KEY)) {
            port = Integer.parseInt((String)request.getDefinition().getProperties().get(SERVER_PORT_KEY));
        }
        if (useDynamicPort) {
            appInstanceEnvVars.put(SERVER_PORT_KEY, String.valueOf(port));
        }
        return port;
    }

    protected boolean shouldInheritLogging(AppDeploymentRequest request) {
        LocalDeployerProperties bindDeployerProperties = this.bindDeploymentProperties(request.getDeploymentProperties());
        return bindDeployerProperties.isInheritLogging();
    }

    public synchronized int getRandomPort() {
        Set availPorts = new HashSet();
        for (int retryCount = 0; retryCount < 5; ++retryCount) {
            int randomInt = ThreadLocalRandom.current().nextInt(this.properties.getPortRange().getLow(), this.properties.getPortRange().getHigh());
            try {
                availPorts = SocketUtils.findAvailableTcpPorts((int)5, (int)randomInt, (int)(randomInt + 5));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.debug(e.getMessage() + "Retrying to find available ports.");
                }
                break;
            }
            catch (IllegalStateException e) {
                this.logger.debug(e.getMessage() + "  Retrying to find available ports.");
                continue;
            }
        }
        if (availPorts.isEmpty()) {
            throw new IllegalStateException("Could not find an available TCP port in the range" + this.properties.getPortRange());
        }
        int finalPort = -1;
        this.logger.debug("Available Ports: " + availPorts);
        for (Integer freePort : availPorts) {
            if (usedPorts.contains(freePort)) continue;
            finalPort = freePort;
            usedPorts.add(finalPort);
            break;
        }
        if (finalPort == -1) {
            throw new IllegalStateException("Could not find a free random port range " + this.properties.getPortRange());
        }
        this.logger.debug("Using Port: " + finalPort);
        return finalPort;
    }

    protected Integer isServerPortKeyPresentOnArgs(AppDeploymentRequest request) {
        Integer result = null;
        for (String argument : request.getCommandlineArguments()) {
            if (!argument.startsWith(SERVER_PORT_KEY_COMMAND_LINE_ARG)) continue;
            result = Integer.parseInt(argument.replace(SERVER_PORT_KEY_COMMAND_LINE_ARG, "").trim());
            break;
        }
        return result;
    }

    protected static interface Instance {
        public URL getBaseUrl();

        public Process getProcess();
    }
}

