/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.File;
import java.nio.file.Path;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.deployer.spi.local.LocalDeployerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="spring.cloud.deployer.local")
public class LocalDeployerProperties {
    public static final String PREFIX = "spring.cloud.deployer.local";
    public static final String INHERIT_LOGGING = "spring.cloud.deployer.local.inheritLogging";
    public static final String DEBUG_PORT = "spring.cloud.deployer.local.debugPort";
    public static final String DEBUG_SUSPEND = "spring.cloud.deployer.local.debugSuspend";
    private static final Logger logger = LoggerFactory.getLogger(LocalDeployerProperties.class);
    private static final String JAVA_COMMAND = LocalDeployerUtils.isWindows() ? "java.exe" : "java";
    private static final String[] ENV_VARS_TO_INHERIT_DEFAULTS_WIN = new String[]{"TMP", "TEMP", "PATH", "Path", "SPRING_APPLICATION_JSON"};
    private static final String[] ENV_VARS_TO_INHERIT_DEFAULTS_OTHER = new String[]{"TMP", "LANG", "LANGUAGE", "LC_.*", "PATH", "SPRING_APPLICATION_JSON"};
    private Path workingDirectoriesRoot = new File(System.getProperty("java.io.tmpdir")).toPath();
    private boolean deleteFilesOnExit = true;
    private String[] envVarsToInherit = LocalDeployerUtils.isWindows() ? ENV_VARS_TO_INHERIT_DEFAULTS_WIN : ENV_VARS_TO_INHERIT_DEFAULTS_OTHER;
    private String javaCmd = this.deduceJavaCommand();
    @Min(value=-1L)
    private int shutdownTimeout = 30;
    private String javaOpts;
    private boolean useSpringApplicationJson = true;
    private int freeDiskSpacePercentage = 5;

    @Min(value=0L)
    @Max(value=100L)
    public int getFreeDiskSpacePercentage() {
        return this.freeDiskSpacePercentage;
    }

    public void setFreeDiskSpacePercentage(int freeDiskSpacePercentage) {
        this.freeDiskSpacePercentage = freeDiskSpacePercentage;
    }

    public String getJavaCmd() {
        return this.javaCmd;
    }

    public void setJavaCmd(String javaCmd) {
        this.javaCmd = javaCmd;
    }

    public Path getWorkingDirectoriesRoot() {
        return this.workingDirectoriesRoot;
    }

    public void setWorkingDirectoriesRoot(String workingDirectoriesRoot) {
        this.workingDirectoriesRoot = new File(workingDirectoriesRoot).toPath();
    }

    public boolean isDeleteFilesOnExit() {
        return this.deleteFilesOnExit;
    }

    public void setDeleteFilesOnExit(boolean deleteFilesOnExit) {
        this.deleteFilesOnExit = deleteFilesOnExit;
    }

    public String[] getEnvVarsToInherit() {
        return this.envVarsToInherit;
    }

    public void setEnvVarsToInherit(String[] envVarsToInherit) {
        this.envVarsToInherit = envVarsToInherit;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public LocalDeployerProperties setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public void setJavaOpts(String javaOpts) {
        this.javaOpts = javaOpts;
    }

    public boolean isUseSpringApplicationJson() {
        return this.useSpringApplicationJson;
    }

    public void setUseSpringApplicationJson(boolean useSpringApplicationJson) {
        this.useSpringApplicationJson = useSpringApplicationJson;
    }

    private String deduceJavaCommand() {
        String javaExecutablePath = JAVA_COMMAND;
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            File javaExecutable = new File(javaHome, "bin" + File.separator + javaExecutablePath);
            Assert.isTrue((boolean)javaExecutable.canExecute(), (String)("Java executable'" + javaExecutable + "'discovered via 'java.home' system property '" + javaHome + "' is not executable or does not exist."));
            javaExecutablePath = javaExecutable.getAbsolutePath();
        } else {
            logger.warn("System property 'java.home' is not set. Defaulting to the java executable path as " + JAVA_COMMAND + " assuming it's in PATH.");
        }
        return javaExecutablePath;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("workingDirectoriesRoot", (Object)this.workingDirectoriesRoot).append("javaOpts", (Object)this.javaOpts).append("envVarsToInherit", (Object)this.envVarsToInherit).toString();
    }
}

