/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.CommandProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.util.CommandLineTokenizer;
import org.springframework.util.StringUtils;

class StartupCommandProbeCreator
extends CommandProbeCreator {
    StartupCommandProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Command", "ProbeDelay", this.getKubernetesDeployerProperties().getStartupCommandProbeDelay());
    }

    @Override
    int getPeriod() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Command", "ProbePeriod", this.getKubernetesDeployerProperties().getStartupCommandProbePeriod());
    }

    @Override
    int getFailure() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Command", "ProbeFailure", this.getKubernetesDeployerProperties().getLivenessCommandProbeFailure());
    }

    @Override
    int getSuccess() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Command", "ProbeSuccess", this.getKubernetesDeployerProperties().getLivenessCommandProbeSuccess());
    }

    @Override
    String[] getCommand() {
        String probeCommandValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.startupCommandProbeCommand");
        if (StringUtils.hasText((String)probeCommandValue)) {
            return new CommandLineTokenizer(probeCommandValue).getArgs().toArray(new String[0]);
        }
        if (this.getKubernetesDeployerProperties().getStartupCommandProbeCommand() != null) {
            return new CommandLineTokenizer(this.getKubernetesDeployerProperties().getStartupCommandProbeCommand()).getArgs().toArray(new String[0]);
        }
        throw new IllegalArgumentException("The startupCommandProbeCommand property must be set.");
    }
}

