/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.TcpProbeCreator;
import org.springframework.util.StringUtils;

class StartupTcpProbeCreator
extends TcpProbeCreator {
    StartupTcpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Tcp", "ProbeDelay", this.getKubernetesDeployerProperties().getStartupTcpProbeDelay());
    }

    @Override
    int getPeriod() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Tcp", "ProbePeriod", this.getKubernetesDeployerProperties().getStartupTcpProbePeriod());
    }

    @Override
    protected int getTimeout() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Tcp", "ProbeTimeout", this.getKubernetesDeployerProperties().getStartupTcpProbeTimeout());
    }

    @Override
    Integer getPort() {
        String probePortValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.startup", "Tcp", "ProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            if (!probePortValue.chars().allMatch(Character::isDigit)) {
                throw new IllegalArgumentException("StartupTcpProbePort must contain all digits");
            }
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getStartupTcpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getStartupTcpProbePort();
        }
        throw new IllegalArgumentException("A startupTcpProbePort property must be set.");
    }

    @Override
    int getFailure() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Tcp", "ProbeFailure", this.getKubernetesDeployerProperties().getStartupTcpProbeFailure());
    }

    @Override
    int getSuccess() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Tcp", "ProbeSuccess", this.getKubernetesDeployerProperties().getStartupTcpProbeSuccess());
    }
}

