/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.HttpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.util.StringUtils;

class StartupHttpProbeCreator
extends HttpProbeCreator {
    StartupHttpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    public Integer getPort() {
        String probePortValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.startup", "Http", "ProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            if (!probePortValue.chars().allMatch(Character::isDigit)) {
                throw new IllegalArgumentException("StartupHttpProbeCreator must contain all digits");
            }
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getStartupHttpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getStartupHttpProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.startup", "Http", "ProbePath");
        if (StringUtils.hasText((String)probePathValue)) {
            return probePathValue;
        }
        if (this.getKubernetesDeployerProperties().getStartupHttpProbePath() != null) {
            return this.getKubernetesDeployerProperties().getStartupHttpProbePath();
        }
        if (this.useBoot1ProbePath()) {
            return "/info";
        }
        return "/actuator/info";
    }

    @Override
    protected String getScheme() {
        String probeSchemeValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.startup", "Http", "ProbeScheme");
        if (StringUtils.hasText((String)probeSchemeValue)) {
            return probeSchemeValue;
        }
        if (this.getKubernetesDeployerProperties().getStartupProbeScheme() != null) {
            return this.getKubernetesDeployerProperties().getStartupProbeScheme();
        }
        return "HTTP";
    }

    @Override
    protected int getTimeout() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Http", "ProbeTimeout", this.getKubernetesDeployerProperties().getStartupHttpProbeTimeout());
    }

    @Override
    protected int getInitialDelay() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Http", "ProbeDelay", this.getKubernetesDeployerProperties().getStartupHttpProbeDelay());
    }

    @Override
    protected int getPeriod() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Http", "ProbePeriod", this.getKubernetesDeployerProperties().getStartupHttpProbePeriod());
    }

    @Override
    int getFailure() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Http", "ProbeFailure", this.getKubernetesDeployerProperties().getStartupHttpProbeFailure());
    }

    @Override
    int getSuccess() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.startup", "Http", "ProbeSuccess", this.getKubernetesDeployerProperties().getStartupHttpProbeSuccess());
    }
}

