/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.HttpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.util.StringUtils;

class LivenessHttpProbeCreator
extends HttpProbeCreator {
    LivenessHttpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    public Integer getPort() {
        String probePortValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.liveness", "Http", "ProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getLivenessHttpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getLivenessHttpProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.liveness", "Http", "ProbePath", this.getKubernetesDeployerProperties().getLivenessHttpProbePath());
        if (StringUtils.hasText((String)probePathValue)) {
            return probePathValue;
        }
        if (this.useBoot1ProbePath()) {
            return "/health";
        }
        return "/actuator/health";
    }

    @Override
    protected String getScheme() {
        String probeSchemeValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.liveness", "Http", "ProbeScheme", this.getKubernetesDeployerProperties().getLivenessHttpProbeScheme());
        if (StringUtils.hasText((String)probeSchemeValue)) {
            return probeSchemeValue;
        }
        return "HTTP";
    }

    @Override
    protected int getTimeout() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Http", "ProbeTimeout", this.getKubernetesDeployerProperties().getLivenessHttpProbeTimeout());
    }

    @Override
    protected int getInitialDelay() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Http", "ProbeDelay", this.getKubernetesDeployerProperties().getLivenessHttpProbeDelay());
    }

    @Override
    protected int getPeriod() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Http", "ProbePeriod", this.getKubernetesDeployerProperties().getLivenessHttpProbePeriod());
    }

    @Override
    int getFailure() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Http", "ProbeFailure", this.getKubernetesDeployerProperties().getLivenessHttpProbeFailure());
    }

    @Override
    int getSuccess() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Http", "ProbeSuccess", this.getKubernetesDeployerProperties().getLivenessHttpProbeSuccess());
    }
}

