/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Probe;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.LivenessCommandProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.LivenessHttpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.LivenessTcpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeType;
import org.springframework.cloud.deployer.spi.kubernetes.ReadinessCommandProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.ReadinessHttpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.ReadinessTcpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.StartupCommandProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.StartupHttpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.StartupTcpProbeCreator;

class ProbeCreatorFactory {
    ProbeCreatorFactory() {
    }

    static Probe createStartupProbe(ContainerConfiguration containerConfiguration, KubernetesDeployerProperties kubernetesDeployerProperties, ProbeType probeType) {
        switch (probeType) {
            case HTTP: {
                return new StartupHttpProbeCreator(kubernetesDeployerProperties, containerConfiguration).create();
            }
            case TCP: {
                return new StartupTcpProbeCreator(kubernetesDeployerProperties, containerConfiguration).create();
            }
            case COMMAND: {
                return new StartupCommandProbeCreator(kubernetesDeployerProperties, containerConfiguration).create();
            }
        }
        throw new IllegalArgumentException("Unknown startup probe type: " + (Object)((Object)probeType));
    }

    static Probe createReadinessProbe(ContainerConfiguration containerConfiguration, KubernetesDeployerProperties kubernetesDeployerProperties, ProbeType probeType) {
        switch (probeType) {
            case HTTP: {
                return new ReadinessHttpProbeCreator(kubernetesDeployerProperties, containerConfiguration).create();
            }
            case TCP: {
                return new ReadinessTcpProbeCreator(kubernetesDeployerProperties, containerConfiguration).create();
            }
            case COMMAND: {
                return new ReadinessCommandProbeCreator(kubernetesDeployerProperties, containerConfiguration).create();
            }
        }
        throw new IllegalArgumentException("Unknown readiness probe type: " + (Object)((Object)probeType));
    }

    static Probe createLivenessProbe(ContainerConfiguration containerConfiguration, KubernetesDeployerProperties kubernetesDeployerProperties, ProbeType probeType) {
        switch (probeType) {
            case HTTP: {
                return new LivenessHttpProbeCreator(kubernetesDeployerProperties, containerConfiguration).create();
            }
            case TCP: {
                return new LivenessTcpProbeCreator(kubernetesDeployerProperties, containerConfiguration).create();
            }
            case COMMAND: {
                return new LivenessCommandProbeCreator(kubernetesDeployerProperties, containerConfiguration).create();
            }
        }
        throw new IllegalArgumentException("Unknown liveness probe type: " + (Object)((Object)probeType));
    }
}

