/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Probe;
import java.util.Map;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.support.PropertyParserUtils;
import org.springframework.util.StringUtils;

abstract class ProbeCreator {
    static final String KUBERNETES_DEPLOYER_PREFIX = "spring.cloud.deployer.kubernetes";
    static final String LIVENESS_DEPLOYER_PROPERTY_PREFIX = "spring.cloud.deployer.kubernetes.liveness";
    static final String READINESS_DEPLOYER_PROPERTY_PREFIX = "spring.cloud.deployer.kubernetes.readiness";
    static final String STARTUP_DEPLOYER_PROPERTY_PREFIX = "spring.cloud.deployer.kubernetes.startup";
    private ContainerConfiguration containerConfiguration;
    private KubernetesDeployerProperties kubernetesDeployerProperties;

    ProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        this.kubernetesDeployerProperties = kubernetesDeployerProperties;
    }

    abstract Probe create();

    abstract int getInitialDelay();

    abstract int getPeriod();

    abstract int getFailure();

    abstract int getSuccess();

    KubernetesDeployerProperties getKubernetesDeployerProperties() {
        return this.kubernetesDeployerProperties;
    }

    private Map<String, String> getDeploymentProperties() {
        return this.containerConfiguration.getAppDeploymentRequest().getDeploymentProperties();
    }

    protected String getDeploymentPropertyValue(String propertyName) {
        return PropertyParserUtils.getDeploymentPropertyValue(this.getDeploymentProperties(), propertyName);
    }

    protected String getDeploymentPropertyValue(String propertyName, String defaultValue) {
        return PropertyParserUtils.getDeploymentPropertyValue(this.getDeploymentProperties(), propertyName, defaultValue);
    }

    ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    String getProbeProperty(String propertyPrefix, String probeName, String propertySuffix) {
        String defaultValue = this.getDeploymentPropertyValue(propertyPrefix + probeName + propertySuffix);
        return StringUtils.hasText((String)defaultValue) ? defaultValue : this.getDeploymentPropertyValue(propertyPrefix + propertySuffix);
    }

    String getProbeProperty(String propertyPrefix, String probeName, String propertySuffix, String defaultValue) {
        return this.getDeploymentPropertyValue(propertyPrefix + probeName + propertySuffix, this.getDeploymentPropertyValue(propertyPrefix + propertySuffix, defaultValue));
    }

    int getProbeIntProperty(String propertyPrefix, String probeName, String propertySuffix, int defaultValue) {
        String propertyValue = this.getDeploymentPropertyValue(propertyPrefix + probeName + propertySuffix, this.getDeploymentPropertyValue(propertyPrefix + propertySuffix));
        return StringUtils.hasText((String)propertyValue) ? Integer.parseInt(propertyValue) : defaultValue;
    }
}

