/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.NodeAffinity;
import io.fabric8.kubernetes.api.model.PodAffinity;
import io.fabric8.kubernetes.api.model.PodAntiAffinity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.client.Config;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.deployer.spi.app.AppAdmin;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeType;
import org.springframework.cloud.deployer.spi.kubernetes.RestartPolicy;

@ConfigurationProperties(prefix="spring.cloud.deployer.kubernetes")
public class KubernetesDeployerProperties {
    static final String KUBERNETES_DEPLOYER_PROPERTIES_PREFIX = "spring.cloud.deployer.kubernetes";
    static final String KUBERNETES_DEPLOYMENT_NODE_SELECTOR = "spring.cloud.deployer.kubernetes.deployment.nodeSelector";
    private int maximumConcurrentTasks = 20;
    @NestedConfigurationProperty
    private Config fabric8 = Config.autoConfigure(null);
    private RestartPolicy restartPolicy = RestartPolicy.Always;
    protected static final String DEFAULT_TASK_SERVICE_ACCOUNT_NAME = "default";
    private String taskServiceAccountName = "default";
    public static final String ENV_KEY_KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static String KUBERNETES_NAMESPACE = System.getenv("KUBERNETES_NAMESPACE");
    private String namespace = KUBERNETES_NAMESPACE;
    private String imagePullSecret;
    private List<String> imagePullSecrets;
    private int livenessHttpProbeDelay = 1;
    private int livenessHttpProbeFailure = 3;
    private int livenessHttpProbeSuccess = 1;
    private int livenessHttpProbePeriod = 60;
    private int livenessHttpProbeTimeout = 5;
    private int livenessTcpProbeTimeout = 5;
    private String livenessHttpProbePath;
    private Integer livenessHttpProbePort = null;
    private String livenessHttpProbeScheme = "HTTP";
    private String readinessHttpProbeScheme = "HTTP";
    private String startupProbeScheme = "HTTP";
    private Boolean shareProcessNamespace;
    private int readinessHttpProbeDelay = 1;
    private int readinessHttpProbeSuccess = 1;
    private int readinessHttpProbeFailure = 3;
    private int readinessTcpProbeTimeout = 3;
    private int readinessTcpProbeFailure = 3;
    private int readinessTcpProbeSuccess = 1;
    private int startupHttpProbeDelay = 30;
    private int startupHttpProbeFailure = 20;
    private int startupHttpProbeSuccess = 1;
    private int startupTcpProbeFailure = 20;
    private int startupTcpProbeSuccess = 1;
    private int startupCommandProbeFailure = 10;
    private int startupCommandProbeSuccess = 1;
    private int readinessHttpProbePeriod = 10;
    private int startupHttpProbePeriod = 3;
    private int startupHttpProbeTimeout = 5;
    private int readinessHttpProbeTimeout = 5;
    private int readinessCommandProbeFailure = 3;
    private int readinessCommandProbeSuccess = 1;
    private String readinessHttpProbePath;
    private String startupHttpProbePath;
    private Integer readinessHttpProbePort = null;
    private Integer startupHttpProbePort = null;
    private int livenessTcpProbeDelay = 10;
    private int livenessTcpProbeSuccess = 1;
    private int livenessTcpProbeFailure = 3;
    private int livenessTcpProbePeriod = 60;
    private Integer livenessTcpProbePort = null;
    private int readinessTcpProbeDelay = 1;
    private int readinessTcpProbePeriod = 10;
    private Integer readinessTcpProbePort = null;
    private int readinessCommandProbeDelay = 1;
    private int readinessCommandProbePeriod = 10;
    private String readinessCommandProbeCommand = null;
    private int startupTcpProbeDelay = 30;
    private int startupTcpProbeTimeout = 5;
    private int startupTcpProbePeriod = 3;
    private Integer startupTcpProbePort = null;
    private int startupCommandProbeDelay = 30;
    private int startupCommandProbePeriod = 10;
    private String startupCommandProbeCommand = null;
    private int livenessCommandProbeDelay = 10;
    private int livenessCommandProbeFailure = 3;
    private int livenessCommandProbeSuccess = 1;
    private int livenessCommandProbePeriod = 10;
    private String livenessCommandProbeCommand = null;
    private String probeCredentialsSecret;
    private ProbeType probeType = ProbeType.HTTP;
    private LimitsResources limits = new LimitsResources();
    private RequestsResources requests = new RequestsResources();
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private List<SecretKeyRef> secretKeyRefs = new ArrayList<SecretKeyRef>();
    private List<ConfigMapKeyRef> configMapKeyRefs = new ArrayList<ConfigMapKeyRef>();
    private List<String> configMapRefs = new ArrayList<String>();
    private List<String> secretRefs = new ArrayList<String>();
    private StatefulSet statefulSet = new StatefulSet();
    private String[] environmentVariables = new String[0];
    private EntryPointStyle entryPointStyle = EntryPointStyle.exec;
    private boolean createLoadBalancer = false;
    private String serviceAnnotations = null;
    private String podAnnotations;
    private String jobAnnotations;
    private int minutesToWaitForLoadBalancer = 5;
    private int maxTerminatedErrorRestarts = 2;
    private int maxCrashLoopBackOffRestarts = 4;
    private ImagePullPolicy imagePullPolicy = ImagePullPolicy.IfNotPresent;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private List<Volume> volumes = new ArrayList<Volume>();
    private boolean hostNetwork = false;
    private boolean createJob = false;
    private String nodeSelector;
    private String deploymentServiceAccountName;
    private PodSecurityContext podSecurityContext;
    private ContainerSecurityContext containerSecurityContext;
    private NodeAffinity nodeAffinity;
    private PodAffinity podAffinity;
    private PodAntiAffinity podAntiAffinity;
    private String statefulSetInitContainerImageName;
    private InitContainer initContainer;
    private Lifecycle lifecycle = new Lifecycle();
    private List<Container> additionalContainers;
    private String deploymentLabels;
    private String priorityClassName;
    private AppAdmin appAdmin = new AppAdmin();
    private CronConfig cron = new CronConfig();

    public Config getFabric8() {
        return this.fabric8;
    }

    public void setFabric8(Config fabric8) {
        this.fabric8 = fabric8;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(RestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public String getTaskServiceAccountName() {
        return this.taskServiceAccountName;
    }

    public void setTaskServiceAccountName(String taskServiceAccountName) {
        this.taskServiceAccountName = taskServiceAccountName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public void setImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
    }

    public List<String> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(List<String> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public Boolean getShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    public void setShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public void setPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
    }

    @Deprecated
    public int getLivenessProbeDelay() {
        return this.livenessHttpProbeDelay;
    }

    @Deprecated
    public void setLivenessProbeDelay(int livenessProbeDelay) {
        this.livenessHttpProbeDelay = livenessProbeDelay;
    }

    @Deprecated
    public int getLivenessProbePeriod() {
        return this.livenessHttpProbePeriod;
    }

    @Deprecated
    public void setLivenessProbePeriod(int livenessProbePeriod) {
        this.livenessHttpProbePeriod = livenessProbePeriod;
    }

    @Deprecated
    public int getLivenessProbeTimeout() {
        return this.livenessHttpProbeTimeout;
    }

    @Deprecated
    public void setLivenessProbeTimeout(int livenessProbeTimeout) {
        this.livenessHttpProbeTimeout = livenessProbeTimeout;
    }

    @Deprecated
    public String getLivenessProbePath() {
        return this.livenessHttpProbePath;
    }

    @Deprecated
    public void setLivenessProbePath(String livenessProbePath) {
        this.livenessHttpProbePath = livenessProbePath;
    }

    @Deprecated
    public Integer getLivenessProbePort() {
        return this.livenessHttpProbePort;
    }

    @Deprecated
    public void setLivenessProbePort(Integer livenessProbePort) {
        this.livenessHttpProbePort = livenessProbePort;
    }

    public int getLivenessTcpProbeSuccess() {
        return this.livenessTcpProbeSuccess;
    }

    public void setLivenessTcpProbeSuccess(int livenessTcpProbeSuccess) {
        this.livenessTcpProbeSuccess = livenessTcpProbeSuccess;
    }

    public int getLivenessTcpProbeFailure() {
        return this.livenessTcpProbeFailure;
    }

    public void setLivenessTcpProbeFailure(int livenessTcpProbeFailure) {
        this.livenessTcpProbeFailure = livenessTcpProbeFailure;
    }

    public int getLivenessHttpProbeDelay() {
        return this.livenessHttpProbeDelay;
    }

    public void setLivenessHttpProbeDelay(int livenessHttpProbeDelay) {
        this.livenessHttpProbeDelay = livenessHttpProbeDelay;
    }

    public int getLivenessTcpProbeTimeout() {
        return this.livenessTcpProbeTimeout;
    }

    public void setLivenessTcpProbeTimeout(int livenessTcpProbeTimeout) {
        this.livenessTcpProbeTimeout = livenessTcpProbeTimeout;
    }

    public int getLivenessHttpProbePeriod() {
        return this.livenessHttpProbePeriod;
    }

    public void setLivenessHttpProbePeriod(int livenessHttpProbePeriod) {
        this.livenessHttpProbePeriod = livenessHttpProbePeriod;
    }

    public int getLivenessHttpProbeTimeout() {
        return this.livenessHttpProbeTimeout;
    }

    public void setLivenessHttpProbeTimeout(int livenessHttpProbeTimeout) {
        this.livenessHttpProbeTimeout = livenessHttpProbeTimeout;
    }

    public String getLivenessHttpProbePath() {
        return this.livenessHttpProbePath;
    }

    public void setLivenessHttpProbePath(String livenessHttpProbePath) {
        this.livenessHttpProbePath = livenessHttpProbePath;
    }

    public Integer getLivenessHttpProbePort() {
        return this.livenessHttpProbePort;
    }

    public void setLivenessHttpProbePort(Integer livenessHttpProbePort) {
        this.livenessHttpProbePort = livenessHttpProbePort;
    }

    public int getStartupHttpProbeTimeout() {
        return this.startupHttpProbeTimeout;
    }

    public int getStartupHttpProbeFailure() {
        return this.startupHttpProbeFailure;
    }

    public void setStartupHttpProbeFailure(int startupHttpProbeFailure) {
        this.startupHttpProbeFailure = startupHttpProbeFailure;
    }

    public void setStartupProbeFailure(int startupHttpProbeFailure) {
        this.startupHttpProbeFailure = startupHttpProbeFailure;
    }

    public int getLivenessHttpProbeFailure() {
        return this.livenessHttpProbeFailure;
    }

    public void setLivenessHttpProbeFailure(int livenessHttpProbeFailure) {
        this.livenessHttpProbeFailure = livenessHttpProbeFailure;
    }

    public void setLivenessProbeFailure(int livenessHttpProbeFailure) {
        this.livenessHttpProbeFailure = livenessHttpProbeFailure;
    }

    public int getLivenessHttpProbeSuccess() {
        return this.livenessHttpProbeSuccess;
    }

    public void setLivenessHttpProbeSuccess(int livenessHttpProbeSuccess) {
        this.livenessHttpProbeSuccess = livenessHttpProbeSuccess;
    }

    public void setLivenessProbeSuccess(int livenessHttpProbeSuccess) {
        this.livenessHttpProbeSuccess = livenessHttpProbeSuccess;
    }

    public int getStartupHttpProbeSuccess() {
        return this.startupHttpProbeSuccess;
    }

    public void setStartupHttpProbeSuccess(int startupHttpProbeSuccess) {
        this.startupHttpProbeSuccess = startupHttpProbeSuccess;
    }

    public void setStartupProbeSuccess(int startupHttpProbeSuccess) {
        this.startupHttpProbeSuccess = startupHttpProbeSuccess;
    }

    public int getStartupTcpProbeFailure() {
        return this.startupTcpProbeFailure;
    }

    public void setStartupTcpProbeFailure(int startupTcpProbeFailure) {
        this.startupTcpProbeFailure = startupTcpProbeFailure;
    }

    public int getStartupTcpProbeSuccess() {
        return this.startupTcpProbeSuccess;
    }

    public void setStartupTcpProbeSuccess(int startupTcpProbeSuccess) {
        this.startupTcpProbeSuccess = startupTcpProbeSuccess;
    }

    public int getStartupCommandProbeFailure() {
        return this.startupCommandProbeFailure;
    }

    public void setStartupCommandProbeFailure(int startupCommandProbeFailure) {
        this.startupCommandProbeFailure = startupCommandProbeFailure;
    }

    public int getStartupCommandProbeSuccess() {
        return this.startupCommandProbeSuccess;
    }

    public void setStartupCommandProbeSuccess(int startupCommandProbeSuccess) {
        this.startupCommandProbeSuccess = startupCommandProbeSuccess;
    }

    public int getLivenessCommandProbeFailure() {
        return this.livenessCommandProbeFailure;
    }

    public void setLivenessCommandProbeFailure(int livenessCommandProbeFailure) {
        this.livenessCommandProbeFailure = livenessCommandProbeFailure;
    }

    public int getLivenessCommandProbeSuccess() {
        return this.livenessCommandProbeSuccess;
    }

    public void setLivenessCommandProbeSuccess(int livenessCommandProbeSuccess) {
        this.livenessCommandProbeSuccess = livenessCommandProbeSuccess;
    }

    public int getStartupHttpProbeDelay() {
        return this.startupHttpProbeDelay;
    }

    public void setStartupHttpProbeTimeout(int startupHttpProbeTimeout) {
        this.startupHttpProbeTimeout = startupHttpProbeTimeout;
    }

    public void setStartupProbeTimeout(int startupHttpProbeTimeout) {
        this.startupHttpProbeTimeout = startupHttpProbeTimeout;
    }

    public void setStartupHttpProbeDelay(int startupHttpProbeDelay) {
        this.startupHttpProbeDelay = startupHttpProbeDelay;
    }

    public void setStartupProbeDelay(int startupHttpProbeDelay) {
        this.startupHttpProbeDelay = startupHttpProbeDelay;
    }

    public String getStartupHttpProbePath() {
        return this.startupHttpProbePath;
    }

    public void setStartupHttpProbePath(String startupHttpProbePath) {
        this.startupHttpProbePath = startupHttpProbePath;
    }

    public Integer getStartupHttpProbePort() {
        return this.startupHttpProbePort;
    }

    public void setStartupHttpProbePort(Integer startupHttpProbePort) {
        this.startupHttpProbePort = startupHttpProbePort;
    }

    public void setStartupProbePort(Integer startupHttpProbePort) {
        this.startupHttpProbePort = startupHttpProbePort;
    }

    public String getStartupProbeScheme() {
        return this.startupProbeScheme;
    }

    public void setStartupProbeScheme(String startupProbeScheme) {
        this.startupProbeScheme = startupProbeScheme;
    }

    public int getStartupHttpProbePeriod() {
        return this.startupHttpProbePeriod;
    }

    public void setStartupHttpProbePeriod(int startupHttpProbePeriod) {
        this.startupHttpProbePeriod = startupHttpProbePeriod;
    }

    public int getStartupProbePeriod() {
        return this.startupHttpProbePeriod;
    }

    public void setStartupProbePeriod(int startupHttpProbePeriod) {
        this.startupHttpProbePeriod = startupHttpProbePeriod;
    }

    public int getStartupTcpProbeDelay() {
        return this.startupTcpProbeDelay;
    }

    public void setStartupTcpProbeDelay(int startupTcpProbeDelay) {
        this.startupTcpProbeDelay = startupTcpProbeDelay;
    }

    public int getStartupTcpProbeTimeout() {
        return this.startupTcpProbeTimeout;
    }

    public void setStartupTcpProbeTimeout(int startupTcpProbeTimeout) {
        this.startupTcpProbeTimeout = startupTcpProbeTimeout;
    }

    public int getStartupTcpProbePeriod() {
        return this.startupTcpProbePeriod;
    }

    public void setStartupTcpProbePeriod(int startupTcpProbePeriod) {
        this.startupTcpProbePeriod = startupTcpProbePeriod;
    }

    public Integer getStartupTcpProbePort() {
        return this.startupTcpProbePort;
    }

    public void setStartupTcpProbePort(Integer startupTcpProbePort) {
        this.startupTcpProbePort = startupTcpProbePort;
    }

    public int getStartupCommandProbeDelay() {
        return this.startupCommandProbeDelay;
    }

    public void setStartupCommandProbeDelay(int startupCommandProbeDelay) {
        this.startupCommandProbeDelay = startupCommandProbeDelay;
    }

    public int getStartupCommandProbePeriod() {
        return this.startupCommandProbePeriod;
    }

    public void setStartupCommandProbePeriod(int startupCommandProbePeriod) {
        this.startupCommandProbePeriod = startupCommandProbePeriod;
    }

    public String getStartupCommandProbeCommand() {
        return this.startupCommandProbeCommand;
    }

    public void setStartupCommandProbeCommand(String startupCommandProbeCommand) {
        this.startupCommandProbeCommand = startupCommandProbeCommand;
    }

    @Deprecated
    public int getReadinessProbeDelay() {
        return this.readinessHttpProbeDelay;
    }

    @Deprecated
    public void setReadinessProbeDelay(int readinessProbeDelay) {
        this.readinessHttpProbeDelay = readinessProbeDelay;
    }

    @Deprecated
    public int getReadinessProbePeriod() {
        return this.readinessHttpProbePeriod;
    }

    public int getReadinessTcpProbeFailure() {
        return this.readinessTcpProbeFailure;
    }

    public void setReadinessTcpProbeFailure(int readinessTcpProbeFailure) {
        this.readinessTcpProbeFailure = readinessTcpProbeFailure;
    }

    public int getReadinessTcpProbeSuccess() {
        return this.readinessTcpProbeSuccess;
    }

    public void setReadinessTcpProbeSuccess(int readinessTcpProbeSuccess) {
        this.readinessTcpProbeSuccess = readinessTcpProbeSuccess;
    }

    public int getReadinessHttpProbeSuccess() {
        return this.readinessHttpProbeSuccess;
    }

    public void setReadinessHttpProbeSuccess(int readinessHttpProbeSuccess) {
        this.readinessHttpProbeSuccess = readinessHttpProbeSuccess;
    }

    public int getReadinessHttpProbeFailure() {
        return this.readinessHttpProbeFailure;
    }

    public void setReadinessHttpProbeFailure(int readinessHttpProbeFailure) {
        this.readinessHttpProbeFailure = readinessHttpProbeFailure;
    }

    public void setReadinessProbeFailure(int readinessHttpProbeFailure) {
        this.readinessHttpProbeFailure = readinessHttpProbeFailure;
    }

    public int getReadinessCommandProbeFailure() {
        return this.readinessCommandProbeFailure;
    }

    public void setReadinessCommandProbeFailure(int readinessCommandProbeFailure) {
        this.readinessCommandProbeFailure = readinessCommandProbeFailure;
    }

    public int getReadinessCommandProbeSuccess() {
        return this.readinessCommandProbeSuccess;
    }

    public void setReadinessCommandProbeSuccess(int readinessCommandProbeSuccess) {
        this.readinessCommandProbeSuccess = readinessCommandProbeSuccess;
    }

    @Deprecated
    public void setReadinessProbePeriod(int readinessProbePeriod) {
        this.readinessHttpProbePeriod = readinessProbePeriod;
    }

    @Deprecated
    public int getReadinessProbeTimeout() {
        return this.readinessHttpProbeTimeout;
    }

    @Deprecated
    public void setReadinessProbeTimeout(int readinessProbeTimeout) {
        this.readinessHttpProbeTimeout = readinessProbeTimeout;
    }

    @Deprecated
    public String getReadinessProbePath() {
        return this.readinessHttpProbePath;
    }

    @Deprecated
    public void setReadinessProbePath(String readinessProbePath) {
        this.readinessHttpProbePath = readinessProbePath;
    }

    @Deprecated
    public Integer getReadinessProbePort() {
        return this.readinessHttpProbePort;
    }

    @Deprecated
    public void setReadinessProbePort(Integer readinessProbePort) {
        this.readinessHttpProbePort = readinessProbePort;
    }

    public int getReadinessHttpProbeDelay() {
        return this.readinessHttpProbeDelay;
    }

    public void setReadinessHttpProbeDelay(int readinessHttpProbeDelay) {
        this.readinessHttpProbeDelay = readinessHttpProbeDelay;
    }

    public int getReadinessHttpProbePeriod() {
        return this.readinessHttpProbePeriod;
    }

    public void setReadinessHttpProbePeriod(int readinessHttpProbePeriod) {
        this.readinessHttpProbePeriod = readinessHttpProbePeriod;
    }

    public int getReadinessTcpProbeTimeout() {
        return this.readinessTcpProbeTimeout;
    }

    public void setReadinessTcpProbeTimeout(int readinessTcpProbeTimeout) {
        this.readinessTcpProbeTimeout = readinessTcpProbeTimeout;
    }

    public int getReadinessHttpProbeTimeout() {
        return this.readinessHttpProbeTimeout;
    }

    public void setReadinessHttpProbeTimeout(int readinessHttpProbeTimeout) {
        this.readinessHttpProbeTimeout = readinessHttpProbeTimeout;
    }

    public String getReadinessHttpProbePath() {
        return this.readinessHttpProbePath;
    }

    public void setReadinessHttpProbePath(String readinessHttpProbePath) {
        this.readinessHttpProbePath = readinessHttpProbePath;
    }

    public Integer getReadinessHttpProbePort() {
        return this.readinessHttpProbePort;
    }

    public void setReadinessHttpProbePort(Integer readinessHttpProbePort) {
        this.readinessHttpProbePort = readinessHttpProbePort;
    }

    public int getLivenessTcpProbeDelay() {
        return this.livenessTcpProbeDelay;
    }

    public void setLivenessTcpProbeDelay(int livenessTcpProbeDelay) {
        this.livenessTcpProbeDelay = livenessTcpProbeDelay;
    }

    public int getLivenessTcpProbePeriod() {
        return this.livenessTcpProbePeriod;
    }

    public void setLivenessTcpProbePeriod(int livenessTcpProbePeriod) {
        this.livenessTcpProbePeriod = livenessTcpProbePeriod;
    }

    public Integer getLivenessTcpProbePort() {
        return this.livenessTcpProbePort;
    }

    public void setLivenessTcpProbePort(Integer livenessTcpProbePort) {
        this.livenessTcpProbePort = livenessTcpProbePort;
    }

    public int getReadinessTcpProbeDelay() {
        return this.readinessTcpProbeDelay;
    }

    public void setReadinessTcpProbeDelay(int readinessTcpProbeDelay) {
        this.readinessTcpProbeDelay = readinessTcpProbeDelay;
    }

    public int getReadinessTcpProbePeriod() {
        return this.readinessTcpProbePeriod;
    }

    public void setReadinessTcpProbePeriod(int readinessTcpProbePeriod) {
        this.readinessTcpProbePeriod = readinessTcpProbePeriod;
    }

    public Integer getReadinessTcpProbePort() {
        return this.readinessTcpProbePort;
    }

    public void setReadinessTcpProbePort(Integer readinessTcpProbePort) {
        this.readinessTcpProbePort = readinessTcpProbePort;
    }

    public int getReadinessCommandProbeDelay() {
        return this.readinessCommandProbeDelay;
    }

    public void setReadinessCommandProbeDelay(int readinessCommandProbeDelay) {
        this.readinessCommandProbeDelay = readinessCommandProbeDelay;
    }

    public int getReadinessCommandProbePeriod() {
        return this.readinessCommandProbePeriod;
    }

    public void setReadinessCommandProbePeriod(int readinessCommandProbePeriod) {
        this.readinessCommandProbePeriod = readinessCommandProbePeriod;
    }

    public String getReadinessCommandProbeCommand() {
        return this.readinessCommandProbeCommand;
    }

    public void setReadinessCommandProbeCommand(String readinessCommandProbeCommand) {
        this.readinessCommandProbeCommand = readinessCommandProbeCommand;
    }

    public int getLivenessCommandProbeDelay() {
        return this.livenessCommandProbeDelay;
    }

    public void setLivenessCommandProbeDelay(int livenessCommandProbeDelay) {
        this.livenessCommandProbeDelay = livenessCommandProbeDelay;
    }

    public int getLivenessCommandProbePeriod() {
        return this.livenessCommandProbePeriod;
    }

    public void setLivenessCommandProbePeriod(int livenessCommandProbePeriod) {
        this.livenessCommandProbePeriod = livenessCommandProbePeriod;
    }

    public String getLivenessCommandProbeCommand() {
        return this.livenessCommandProbeCommand;
    }

    public void setLivenessCommandProbeCommand(String livenessCommandProbeCommand) {
        this.livenessCommandProbeCommand = livenessCommandProbeCommand;
    }

    public String getProbeCredentialsSecret() {
        return this.probeCredentialsSecret;
    }

    public void setProbeCredentialsSecret(String probeCredentialsSecret) {
        this.probeCredentialsSecret = probeCredentialsSecret;
    }

    public ProbeType getProbeType() {
        return this.probeType;
    }

    public void setProbeType(ProbeType probeType) {
        this.probeType = probeType;
    }

    public StatefulSet getStatefulSet() {
        return this.statefulSet;
    }

    public void setStatefulSet(StatefulSet statefulSet) {
        this.statefulSet = statefulSet;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    public List<SecretKeyRef> getSecretKeyRefs() {
        return this.secretKeyRefs;
    }

    public void setSecretKeyRefs(List<SecretKeyRef> secretKeyRefs) {
        this.secretKeyRefs = secretKeyRefs;
    }

    public List<ConfigMapKeyRef> getConfigMapKeyRefs() {
        return this.configMapKeyRefs;
    }

    public void setConfigMapKeyRefs(List<ConfigMapKeyRef> configMapKeyRefs) {
        this.configMapKeyRefs = configMapKeyRefs;
    }

    public List<String> getConfigMapRefs() {
        return this.configMapRefs;
    }

    public void setConfigMapRefs(List<String> configMapRefs) {
        this.configMapRefs = configMapRefs;
    }

    public List<String> getSecretRefs() {
        return this.secretRefs;
    }

    public void setSecretRefs(List<String> secretRefs) {
        this.secretRefs = secretRefs;
    }

    public String[] getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(String[] environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public EntryPointStyle getEntryPointStyle() {
        return this.entryPointStyle;
    }

    public void setEntryPointStyle(EntryPointStyle entryPointStyle) {
        this.entryPointStyle = entryPointStyle;
    }

    public boolean isCreateLoadBalancer() {
        return this.createLoadBalancer;
    }

    public void setCreateLoadBalancer(boolean createLoadBalancer) {
        this.createLoadBalancer = createLoadBalancer;
    }

    public String getServiceAnnotations() {
        return this.serviceAnnotations;
    }

    public void setServiceAnnotations(String serviceAnnotations) {
        this.serviceAnnotations = serviceAnnotations;
    }

    public String getPodAnnotations() {
        return this.podAnnotations;
    }

    public void setPodAnnotations(String podAnnotations) {
        this.podAnnotations = podAnnotations;
    }

    public String getJobAnnotations() {
        return this.jobAnnotations;
    }

    public void setJobAnnotations(String jobAnnotations) {
        this.jobAnnotations = jobAnnotations;
    }

    public int getMinutesToWaitForLoadBalancer() {
        return this.minutesToWaitForLoadBalancer;
    }

    public void setMinutesToWaitForLoadBalancer(int minutesToWaitForLoadBalancer) {
        this.minutesToWaitForLoadBalancer = minutesToWaitForLoadBalancer;
    }

    public int getMaxTerminatedErrorRestarts() {
        return this.maxTerminatedErrorRestarts;
    }

    public void setMaxTerminatedErrorRestarts(int maxTerminatedErrorRestarts) {
        this.maxTerminatedErrorRestarts = maxTerminatedErrorRestarts;
    }

    public int getMaxCrashLoopBackOffRestarts() {
        return this.maxCrashLoopBackOffRestarts;
    }

    public void setMaxCrashLoopBackOffRestarts(int maxCrashLoopBackOffRestarts) {
        this.maxCrashLoopBackOffRestarts = maxCrashLoopBackOffRestarts;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public LimitsResources getLimits() {
        return this.limits;
    }

    public void setLimits(LimitsResources limits) {
        this.limits = limits;
    }

    public RequestsResources getRequests() {
        return this.requests;
    }

    public void setRequests(RequestsResources requests) {
        this.requests = requests;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<Volume> volumes) {
        this.volumes = volumes;
    }

    public boolean isHostNetwork() {
        return this.hostNetwork;
    }

    public void setHostNetwork(boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    public boolean isCreateJob() {
        return this.createJob;
    }

    public void setCreateJob(boolean createJob) {
        this.createJob = createJob;
    }

    public String getDeploymentServiceAccountName() {
        return this.deploymentServiceAccountName;
    }

    public void setDeploymentServiceAccountName(String deploymentServiceAccountName) {
        this.deploymentServiceAccountName = deploymentServiceAccountName;
    }

    public int getMaximumConcurrentTasks() {
        return this.maximumConcurrentTasks;
    }

    public void setMaximumConcurrentTasks(int maximumConcurrentTasks) {
        this.maximumConcurrentTasks = maximumConcurrentTasks;
    }

    public void setNodeSelector(String nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public String getNodeSelector() {
        return this.nodeSelector;
    }

    public void setPodSecurityContext(PodSecurityContext podSecurityContext) {
        this.podSecurityContext = podSecurityContext;
    }

    public PodSecurityContext getPodSecurityContext() {
        return this.podSecurityContext;
    }

    public void setContainerSecurityContext(ContainerSecurityContext containerSecurityContext) {
        this.containerSecurityContext = containerSecurityContext;
    }

    public ContainerSecurityContext getContainerSecurityContext() {
        return this.containerSecurityContext;
    }

    public NodeAffinity getNodeAffinity() {
        return this.nodeAffinity;
    }

    public void setNodeAffinity(NodeAffinity nodeAffinity) {
        this.nodeAffinity = nodeAffinity;
    }

    public PodAffinity getPodAffinity() {
        return this.podAffinity;
    }

    public void setPodAffinity(PodAffinity podAffinity) {
        this.podAffinity = podAffinity;
    }

    public PodAntiAffinity getPodAntiAffinity() {
        return this.podAntiAffinity;
    }

    public void setPodAntiAffinity(PodAntiAffinity podAntiAffinity) {
        this.podAntiAffinity = podAntiAffinity;
    }

    public String getStatefulSetInitContainerImageName() {
        return this.statefulSetInitContainerImageName;
    }

    public void setStatefulSetInitContainerImageName(String statefulSetInitContainerImageName) {
        this.statefulSetInitContainerImageName = statefulSetInitContainerImageName;
    }

    public InitContainer getInitContainer() {
        return this.initContainer;
    }

    public void setInitContainer(InitContainer initContainer) {
        this.initContainer = initContainer;
    }

    public List<Container> getAdditionalContainers() {
        return this.additionalContainers;
    }

    public void setAdditionalContainers(List<Container> additionalContainers) {
        this.additionalContainers = additionalContainers;
    }

    public String getLivenessHttpProbeScheme() {
        return this.livenessHttpProbeScheme;
    }

    public void setLivenessHttpProbeScheme(String livenessHttpProbeScheme) {
        this.livenessHttpProbeScheme = livenessHttpProbeScheme;
    }

    public String getReadinessHttpProbeScheme() {
        return this.readinessHttpProbeScheme;
    }

    public void setReadinessHttpProbeScheme(String readinessHttpProbeScheme) {
        this.readinessHttpProbeScheme = readinessHttpProbeScheme;
    }

    Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public String getDeploymentLabels() {
        return this.deploymentLabels;
    }

    public void setDeploymentLabels(String deploymentLabels) {
        this.deploymentLabels = deploymentLabels;
    }

    public AppAdmin getAppAdmin() {
        return this.appAdmin;
    }

    public void setAppAdmin(AppAdmin appAdmin) {
        this.appAdmin = appAdmin;
    }

    public CronConfig getCron() {
        return this.cron;
    }

    public void setCron(CronConfig cron) {
        this.cron = cron;
    }

    public static class CronConfig {
        private String concurrencyPolicy;

        public String getConcurrencyPolicy() {
            return this.concurrencyPolicy;
        }

        public void setConcurrencyPolicy(String concurrencyPolicy) {
            this.concurrencyPolicy = concurrencyPolicy;
        }
    }

    public static class ContainerProperties {
        private String imageName;
        private String containerName;
        private List<String> commands;
        private List<VolumeMount> volumeMounts;
        private String[] environmentVariables = new String[0];

        public String getImageName() {
            return this.imageName;
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public void setCommands(List<String> commands) {
            this.commands = commands;
        }

        public List<VolumeMount> getVolumeMounts() {
            return this.volumeMounts;
        }

        public void setVolumeMounts(List<VolumeMount> volumeMounts) {
            this.volumeMounts = volumeMounts;
        }

        public String[] getEnvironmentVariables() {
            return this.environmentVariables;
        }

        public void setEnvironmentVariables(String[] environmentVariables) {
            this.environmentVariables = environmentVariables;
        }
    }

    static class Container
    extends io.fabric8.kubernetes.api.model.Container {
        Container() {
        }
    }

    public static class InitContainer
    extends ContainerProperties {
    }

    public static class Lifecycle {
        private Hook postStart;
        private Hook preStop;

        Hook getPreStop() {
            return this.preStop;
        }

        Hook getPostStart() {
            return this.postStart;
        }

        void setPostStart(Hook postStart) {
            this.postStart = postStart;
        }

        void setPreStop(Hook preStop) {
            this.preStop = preStop;
        }

        public static class Exec {
            private List<String> command;

            List<String> getCommand() {
                return this.command;
            }

            void setCommand(List<String> command) {
                this.command = command;
            }
        }

        public static class Hook {
            private Exec exec;

            Exec getExec() {
                return this.exec;
            }

            void setExec(Exec exec) {
                this.exec = exec;
            }
        }
    }

    public static class ContainerSecurityContext {
        private Boolean allowPrivilegeEscalation;
        private Boolean readOnlyRootFilesystem;

        public void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        }

        public Boolean getAllowPrivilegeEscalation() {
            return this.allowPrivilegeEscalation;
        }

        public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
            this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        }

        public Boolean getReadOnlyRootFilesystem() {
            return this.readOnlyRootFilesystem;
        }
    }

    public static class SeccompProfile {
        private String type;
        private String localhostProfile;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getLocalhostProfile() {
            return this.localhostProfile;
        }

        public void setLocalhostProfile(String localhostProfile) {
            this.localhostProfile = localhostProfile;
        }
    }

    public static class PodSecurityContext {
        private Long runAsUser;
        private Long fsGroup;
        private Long[] supplementalGroups;
        private SeccompProfile seccompProfile;

        public void setRunAsUser(Long runAsUser) {
            this.runAsUser = runAsUser;
        }

        public Long getRunAsUser() {
            return this.runAsUser;
        }

        public void setFsGroup(Long fsGroup) {
            this.fsGroup = fsGroup;
        }

        public Long getFsGroup() {
            return this.fsGroup;
        }

        public void setSupplementalGroups(Long[] supplementalGroups) {
            this.supplementalGroups = supplementalGroups;
        }

        public Long[] getSupplementalGroups() {
            return this.supplementalGroups;
        }

        public SeccompProfile getSeccompProfile() {
            return this.seccompProfile;
        }

        public void setSeccompProfile(SeccompProfile seccompProfile) {
            this.seccompProfile = seccompProfile;
        }
    }

    public static class ConfigMapKeyRef
    extends KeyRef {
        private String configMapName;

        public void setConfigMapName(String configMapName) {
            this.configMapName = configMapName;
        }

        public String getConfigMapName() {
            return this.configMapName;
        }
    }

    public static class SecretKeyRef
    extends KeyRef {
        private String secretName;

        public void setSecretName(String secretName) {
            this.secretName = secretName;
        }

        public String getSecretName() {
            return this.secretName;
        }
    }

    static class KeyRef {
        private String envVarName;
        private String dataKey;

        KeyRef() {
        }

        public void setEnvVarName(String envVarName) {
            this.envVarName = envVarName;
        }

        public String getEnvVarName() {
            return this.envVarName;
        }

        public void setDataKey(String dataKey) {
            this.dataKey = dataKey;
        }

        public String getDataKey() {
            return this.dataKey;
        }
    }

    public static class Toleration {
        private String effect;
        private String key;
        private String operator;
        private Long tolerationSeconds;
        private String value;

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public Long getTolerationSeconds() {
            return this.tolerationSeconds;
        }

        public void setTolerationSeconds(Long tolerationSeconds) {
            this.tolerationSeconds = tolerationSeconds;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class StatefulSet {
        private VolumeClaimTemplate volumeClaimTemplate = new VolumeClaimTemplate();

        public VolumeClaimTemplate getVolumeClaimTemplate() {
            return this.volumeClaimTemplate;
        }

        public void setVolumeClaimTemplate(VolumeClaimTemplate volumeClaimTemplate) {
            this.volumeClaimTemplate = volumeClaimTemplate;
        }

        public static class VolumeClaimTemplate {
            private String name;
            private String storage = "10m";
            private String storageClassName;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getStorage() {
                return this.storage;
            }

            public void setStorage(String storage) {
                this.storage = storage;
            }

            public String getStorageClassName() {
                return this.storageClassName;
            }

            public void setStorageClassName(String storageClassName) {
                this.storageClassName = storageClassName;
            }
        }
    }

    public static class RequestsResources {
        private String cpu;
        private String memory;

        public RequestsResources() {
        }

        public RequestsResources(String cpu, String memory) {
            this.cpu = cpu;
            this.memory = memory;
        }

        public String getCpu() {
            return this.cpu;
        }

        public void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public String getMemory() {
            return this.memory;
        }

        public void setMemory(String memory) {
            this.memory = memory;
        }
    }

    public static class LimitsResources {
        private String cpu;
        private String memory;
        private String gpuVendor;
        private String gpuCount;

        public LimitsResources() {
        }

        @Deprecated
        public LimitsResources(String cpu, String memory) {
            this.cpu = cpu;
            this.memory = memory;
        }

        public String getCpu() {
            return this.cpu;
        }

        public void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public String getMemory() {
            return this.memory;
        }

        public void setMemory(String memory) {
            this.memory = memory;
        }

        public String getGpuVendor() {
            return this.gpuVendor;
        }

        public void setGpuVendor(String gpuVendor) {
            this.gpuVendor = gpuVendor;
        }

        public String getGpuCount() {
            return this.gpuCount;
        }

        public void setGpuCount(String gpuCount) {
            this.gpuCount = gpuCount;
        }
    }
}

