/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.TcpProbeCreator;
import org.springframework.util.StringUtils;

class ReadinessTcpProbeCreator
extends TcpProbeCreator {
    ReadinessTcpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        String probeDelayValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.readinessTcpProbeDelay");
        if (StringUtils.hasText((String)probeDelayValue)) {
            return Integer.valueOf(probeDelayValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessTcpProbeDelay();
    }

    @Override
    int getPeriod() {
        String probePeriodValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.readinessTcpProbePeriod");
        if (StringUtils.hasText((String)probePeriodValue)) {
            return Integer.valueOf(probePeriodValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessTcpProbePeriod();
    }

    @Override
    Integer getPort() {
        String probePortValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.readinessTcpProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            if (!probePortValue.chars().allMatch(Character::isDigit)) {
                throw new IllegalArgumentException("ReadinessTcpProbePort must contain all digits");
            }
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getReadinessTcpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getReadinessTcpProbePort();
        }
        throw new IllegalArgumentException("A readinessTcpProbePort property must be set.");
    }
}

