/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.CommandProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.util.CommandLineTokenizer;
import org.springframework.util.StringUtils;

class LivenessCommandProbeCreator
extends CommandProbeCreator {
    LivenessCommandProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        String probeDelayValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.livenessCommandProbeDelay");
        if (StringUtils.hasText((String)probeDelayValue)) {
            return Integer.valueOf(probeDelayValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessCommandProbeDelay();
    }

    @Override
    int getPeriod() {
        String probePeriodValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.livenessCommandProbePeriod");
        if (StringUtils.hasText((String)probePeriodValue)) {
            return Integer.valueOf(probePeriodValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessCommandProbePeriod();
    }

    @Override
    String[] getCommand() {
        String probeCommandValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.livenessCommandProbeCommand");
        if (StringUtils.hasText((String)probeCommandValue)) {
            return new CommandLineTokenizer(probeCommandValue).getArgs().toArray(new String[0]);
        }
        if (this.getKubernetesDeployerProperties().getLivenessCommandProbeCommand() != null) {
            return new CommandLineTokenizer(this.getKubernetesDeployerProperties().getLivenessCommandProbeCommand()).getArgs().toArray(new String[0]);
        }
        throw new IllegalArgumentException("The livenessCommandProbeCommand property must be set.");
    }
}

