/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeCreator;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.util.StringUtils;

class ReadinessProbeCreator
extends ProbeCreator {
    private final String probPropertyPrefix;

    public ReadinessProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
        this.probPropertyPrefix = containerConfiguration.getAppDeploymentRequest() instanceof ScheduleRequest ? "spring.cloud.scheduler.kubernetes.readiness" : "spring.cloud.deployer.kubernetes.readiness";
    }

    @Override
    public Integer getPort() {
        String probePortKey = this.probPropertyPrefix + "ProbePort";
        String probePortValue = this.getDeploymentPropertyValue(probePortKey);
        if (StringUtils.hasText((String)probePortValue)) {
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getReadinessProbePort() != null) {
            return this.getKubernetesDeployerProperties().getReadinessProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathKey = this.probPropertyPrefix + "ProbePath";
        String probePathValue = this.getDeploymentPropertyValue(probePathKey);
        if (StringUtils.hasText((String)probePathValue)) {
            return probePathValue;
        }
        if (this.getKubernetesDeployerProperties().getReadinessProbePath() != null) {
            return this.getKubernetesDeployerProperties().getReadinessProbePath();
        }
        if (this.useBoot1ProbePath()) {
            return "/info";
        }
        return "/actuator/info";
    }

    @Override
    protected int getTimeout() {
        String probeTimeoutKey = this.probPropertyPrefix + "ProbeTimeout";
        String probeTimeoutValue = this.getDeploymentPropertyValue(probeTimeoutKey);
        if (StringUtils.hasText((String)probeTimeoutValue)) {
            return Integer.valueOf(probeTimeoutValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessProbeTimeout();
    }

    @Override
    protected int getInitialDelay() {
        String probeDelayKey = this.probPropertyPrefix + "ProbeDelay";
        String probeDelayValue = this.getDeploymentPropertyValue(probeDelayKey);
        if (StringUtils.hasText((String)probeDelayValue)) {
            return Integer.valueOf(probeDelayValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessProbeDelay();
    }

    @Override
    protected int getPeriod() {
        String probePeriodKey = this.probPropertyPrefix + "ProbePeriod";
        String probePeriodValue = this.getDeploymentPropertyValue(probePeriodKey);
        if (StringUtils.hasText((String)probePeriodValue)) {
            return Integer.valueOf(probePeriodValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessProbePeriod();
    }
}

