/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.AffinityBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapEnvSource;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.SecretEnvSource;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesSchedulerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.RestartPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.support.PropertyParserUtils;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.cloud.deployer.spi.util.CommandLineTokenizer;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DeploymentPropertiesResolver {
    static final String STATEFUL_SET_IMAGE_NAME = "busybox";
    private final Log logger = LogFactory.getLog((String)this.getClass().getName());
    private String propertyPrefix;
    private KubernetesDeployerProperties properties;

    DeploymentPropertiesResolver(String propertyPrefix, KubernetesDeployerProperties properties) {
        this.propertyPrefix = propertyPrefix;
        this.properties = properties;
    }

    String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    List<Toleration> getTolerations(Map<String, String> kubernetesDeployerProperties) {
        ArrayList<Toleration> tolerations = new ArrayList<Toleration>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".tolerations", "tolerations");
        deployerProperties.getTolerations().forEach(toleration -> tolerations.add(new Toleration(toleration.getEffect(), toleration.getKey(), toleration.getOperator(), toleration.getTolerationSeconds(), toleration.getValue())));
        this.properties.getTolerations().stream().filter(toleration -> tolerations.stream().noneMatch(existing -> existing.getKey().equals(toleration.getKey()))).collect(Collectors.toList()).forEach(toleration -> tolerations.add(new Toleration(toleration.getEffect(), toleration.getKey(), toleration.getOperator(), toleration.getTolerationSeconds(), toleration.getValue())));
        return tolerations;
    }

    List<Volume> getVolumes(Map<String, String> kubernetesDeployerProperties) {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".volumes", "volumes");
        volumes.addAll(deployerProperties.getVolumes());
        volumes.addAll(this.properties.getVolumes().stream().filter(volume -> volumes.stream().noneMatch(existingVolume -> existingVolume.getName().equals(volume.getName()))).collect(Collectors.toList()));
        return volumes;
    }

    Map<String, Quantity> deduceResourceLimits(Map<String, String> kubernetesDeployerProperties) {
        String cpu;
        String memory = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".limits.memory");
        if (StringUtils.isEmpty((Object)memory)) {
            memory = this.properties.getLimits().getMemory();
        }
        if (StringUtils.isEmpty((Object)(cpu = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".limits.cpu")))) {
            cpu = this.properties.getLimits().getCpu();
        }
        HashMap<String, Quantity> limits = new HashMap<String, Quantity>();
        if (!StringUtils.isEmpty((Object)memory)) {
            limits.put("memory", new Quantity(memory));
        }
        if (!StringUtils.isEmpty((Object)cpu)) {
            limits.put("cpu", new Quantity(cpu));
        }
        return limits;
    }

    ImagePullPolicy deduceImagePullPolicy(Map<String, String> kubernetesDeployerProperties) {
        ImagePullPolicy pullPolicy;
        String pullPolicyOverride = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".imagePullPolicy");
        if (pullPolicyOverride == null) {
            pullPolicy = this.properties.getImagePullPolicy();
        } else {
            pullPolicy = ImagePullPolicy.relaxedValueOf(pullPolicyOverride);
            if (pullPolicy == null) {
                this.logger.warn((Object)("Parsing of pull policy " + pullPolicyOverride + " failed, using default \"IfNotPresent\"."));
                pullPolicy = ImagePullPolicy.IfNotPresent;
            }
        }
        this.logger.debug((Object)("Using imagePullPolicy " + (Object)((Object)pullPolicy)));
        return pullPolicy;
    }

    Map<String, Quantity> deduceResourceRequests(Map<String, String> kubernetesDeployerProperties) {
        String cpuOverride;
        String memOverride = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".requests.memory");
        if (memOverride == null) {
            memOverride = this.properties.getRequests().getMemory();
        }
        if ((cpuOverride = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".requests.cpu")) == null) {
            cpuOverride = this.properties.getRequests().getCpu();
        }
        this.logger.debug((Object)("Using requests - cpu: " + cpuOverride + " mem: " + memOverride));
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>();
        if (memOverride != null) {
            requests.put("memory", new Quantity(memOverride));
        }
        if (cpuOverride != null) {
            requests.put("cpu", new Quantity(cpuOverride));
        }
        return requests;
    }

    String getStatefulSetStorageClassName(Map<String, String> kubernetesDeployerProperties) {
        String storageClassName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".statefulSet.volumeClaimTemplate.storageClassName");
        if (storageClassName == null && this.properties.getStatefulSet() != null && this.properties.getStatefulSet().getVolumeClaimTemplate() != null) {
            storageClassName = this.properties.getStatefulSet().getVolumeClaimTemplate().getStorageClassName();
        }
        return storageClassName;
    }

    String getStatefulSetStorage(Map<String, String> kubernetesDeployerProperties) {
        String storage = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".statefulSet.volumeClaimTemplate.storage");
        if (storage == null && this.properties.getStatefulSet() != null && this.properties.getStatefulSet().getVolumeClaimTemplate() != null) {
            storage = this.properties.getStatefulSet().getVolumeClaimTemplate().getStorage();
        }
        return ByteSizeUtils.parseToMebibytes((String)storage) + "Mi";
    }

    boolean getHostNetwork(Map<String, String> kubernetesDeployerProperties) {
        String hostNetworkOverride = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".hostNetwork");
        boolean hostNetwork = StringUtils.isEmpty((Object)hostNetworkOverride) ? this.properties.isHostNetwork() : Boolean.valueOf(hostNetworkOverride).booleanValue();
        this.logger.debug((Object)("Using hostNetwork " + hostNetwork));
        return hostNetwork;
    }

    Map<String, String> getNodeSelectors(Map<String, String> deploymentProperties) {
        HashMap<String, String> nodeSelectors = new HashMap<String, String>();
        String nodeSelector = this.properties.getNodeSelector();
        String nodeSelectorDeploymentProperty = deploymentProperties.getOrDefault("spring.cloud.deployer.kubernetes.deployment.nodeSelector", "");
        boolean hasGlobalNodeSelector = StringUtils.hasText((String)this.properties.getNodeSelector());
        boolean hasDeployerPropertyNodeSelector = StringUtils.hasText((String)nodeSelectorDeploymentProperty);
        if (hasGlobalNodeSelector && hasDeployerPropertyNodeSelector || !hasGlobalNodeSelector && hasDeployerPropertyNodeSelector) {
            nodeSelector = nodeSelectorDeploymentProperty;
        }
        if (StringUtils.hasText((String)nodeSelector)) {
            String[] nodeSelectorPairs;
            for (String nodeSelectorPair : nodeSelectorPairs = nodeSelector.split(",")) {
                String[] selector = nodeSelectorPair.split(":");
                Assert.isTrue((selector.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid nodeSelector value: '%s'", nodeSelectorPair));
                nodeSelectors.put(selector[0].trim(), selector[1].trim());
            }
        }
        return nodeSelectors;
    }

    String getImagePullSecret(Map<String, String> kubernetesDeployerProperties) {
        String imagePullSecret = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".imagePullSecret", "");
        if (StringUtils.isEmpty((Object)imagePullSecret)) {
            imagePullSecret = this.properties.getImagePullSecret();
        }
        return imagePullSecret;
    }

    String getDeploymentServiceAccountName(Map<String, String> kubernetesDeployerProperties) {
        String deploymentServiceAccountName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".deploymentServiceAccountName");
        if (StringUtils.isEmpty((Object)deploymentServiceAccountName)) {
            deploymentServiceAccountName = this.properties.getDeploymentServiceAccountName();
        }
        return deploymentServiceAccountName;
    }

    PodSecurityContext getPodSecurityContext(Map<String, String> kubernetesDeployerProperties) {
        PodSecurityContext podSecurityContext = null;
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".podSecurityContext", "podSecurityContext");
        if (deployerProperties.getPodSecurityContext() != null) {
            podSecurityContext = ((PodSecurityContextBuilder)((PodSecurityContextBuilder)new PodSecurityContextBuilder().withRunAsUser(deployerProperties.getPodSecurityContext().getRunAsUser())).withFsGroup(deployerProperties.getPodSecurityContext().getFsGroup())).build();
        } else {
            String runAsUser = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".podSecurityContext.runAsUser");
            String fsGroup = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".podSecurityContext.fsGroup");
            if (!StringUtils.isEmpty((Object)runAsUser) && !StringUtils.isEmpty((Object)fsGroup)) {
                podSecurityContext = ((PodSecurityContextBuilder)((PodSecurityContextBuilder)new PodSecurityContextBuilder().withRunAsUser(Long.valueOf(runAsUser))).withFsGroup(Long.valueOf(fsGroup))).build();
            } else if (this.properties.getPodSecurityContext() != null) {
                podSecurityContext = ((PodSecurityContextBuilder)((PodSecurityContextBuilder)new PodSecurityContextBuilder().withRunAsUser(this.properties.getPodSecurityContext().getRunAsUser())).withFsGroup(this.properties.getPodSecurityContext().getFsGroup())).build();
            }
        }
        return podSecurityContext;
    }

    Affinity getAffinityRules(Map<String, String> kubernetesDeployerProperties) {
        Affinity affinity = new Affinity();
        String nodeAffinityPropertyKey = this.propertyPrefix + ".affinity.nodeAffinity";
        String podAffinityPropertyKey = this.propertyPrefix + ".affinity.podAffinity";
        String podAntiAffinityPropertyKey = this.propertyPrefix + ".affinity.podAntiAffinity";
        String nodeAffinityValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, nodeAffinityPropertyKey);
        String podAffinityValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, podAffinityPropertyKey);
        String podAntiAffinityValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, podAntiAffinityPropertyKey);
        if (this.properties.getNodeAffinity() != null && !StringUtils.hasText((String)nodeAffinityValue)) {
            affinity.setNodeAffinity(((AffinityBuilder)new AffinityBuilder().withNodeAffinity(this.properties.getNodeAffinity())).buildNodeAffinity());
        } else if (StringUtils.hasText((String)nodeAffinityValue)) {
            KubernetesDeployerProperties nodeAffinityProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, nodeAffinityPropertyKey, "nodeAffinity");
            affinity.setNodeAffinity(((AffinityBuilder)new AffinityBuilder().withNodeAffinity(nodeAffinityProperties.getNodeAffinity())).buildNodeAffinity());
        }
        if (this.properties.getPodAffinity() != null && !StringUtils.hasText((String)podAffinityValue)) {
            affinity.setPodAffinity(((AffinityBuilder)new AffinityBuilder().withPodAffinity(this.properties.getPodAffinity())).buildPodAffinity());
        } else if (StringUtils.hasText((String)podAffinityValue)) {
            KubernetesDeployerProperties podAffinityProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, podAffinityPropertyKey, "podAffinity");
            affinity.setPodAffinity(((AffinityBuilder)new AffinityBuilder().withPodAffinity(podAffinityProperties.getPodAffinity())).buildPodAffinity());
        }
        if (this.properties.getPodAntiAffinity() != null && !StringUtils.hasText((String)podAntiAffinityValue)) {
            affinity.setPodAntiAffinity(((AffinityBuilder)new AffinityBuilder().withPodAntiAffinity(this.properties.getPodAntiAffinity())).buildPodAntiAffinity());
        } else if (StringUtils.hasText((String)podAntiAffinityValue)) {
            KubernetesDeployerProperties podAntiAffinityProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, podAntiAffinityPropertyKey, "podAntiAffinity");
            affinity.setPodAntiAffinity(((AffinityBuilder)new AffinityBuilder().withPodAntiAffinity(podAntiAffinityProperties.getPodAntiAffinity())).buildPodAntiAffinity());
        }
        return affinity;
    }

    Container getInitContainer(Map<String, String> kubernetesDeployerProperties) {
        Container container = null;
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".initContainer", "initContainer");
        if (deployerProperties.getInitContainer() == null) {
            String containerName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".initContainer.containerName");
            String imageName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".initContainer.imageName");
            String commands = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".initContainer.commands");
            if (!StringUtils.isEmpty((Object)containerName) && !StringUtils.isEmpty((Object)imageName)) {
                container = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(containerName)).withImage(imageName)).withCommand(new String[]{commands})).build();
            }
        } else {
            KubernetesDeployerProperties.InitContainer initContainer = deployerProperties.getInitContainer();
            if (initContainer != null) {
                container = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(initContainer.getContainerName())).withImage(initContainer.getImageName())).withCommand(initContainer.getCommands())).build();
            }
        }
        return container;
    }

    Map<String, String> getPodAnnotations(Map<String, String> kubernetesDeployerProperties) {
        String annotationsValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".podAnnotations", "");
        if (StringUtils.isEmpty((Object)annotationsValue)) {
            annotationsValue = this.properties.getPodAnnotations();
        }
        return PropertyParserUtils.getStringPairsToMap(annotationsValue);
    }

    Map<String, String> getServiceAnnotations(Map<String, String> kubernetesDeployerProperties) {
        String annotationsProperty = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".serviceAnnotations", "");
        if (StringUtils.isEmpty((Object)annotationsProperty)) {
            annotationsProperty = this.properties.getServiceAnnotations();
        }
        return PropertyParserUtils.getStringPairsToMap(annotationsProperty);
    }

    Map<String, String> getDeploymentLabels(Map<String, String> kubernetesDeployerProperties) {
        HashMap<String, String> labels = new HashMap<String, String>();
        String deploymentLabels = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".deploymentLabels", "");
        if (StringUtils.hasText((String)deploymentLabels)) {
            String[] deploymentLabel;
            for (String label : deploymentLabel = deploymentLabels.split(",")) {
                Object[] labelPair = label.split(":");
                Assert.isTrue((labelPair.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid label format, expected 'labelKey:labelValue', got: '%s'", labelPair));
                labels.put(((String)labelPair[0]).trim(), ((String)labelPair[1]).trim());
            }
        }
        return labels;
    }

    RestartPolicy getRestartPolicy(Map<String, String> kubernetesDeployerProperties) {
        String restartPolicy = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".restartPolicy", "");
        if (StringUtils.hasText((String)restartPolicy)) {
            return RestartPolicy.valueOf(restartPolicy);
        }
        return this.properties instanceof KubernetesSchedulerProperties ? ((KubernetesSchedulerProperties)this.properties).getRestartPolicy() : RestartPolicy.Always;
    }

    String getTaskServiceAccountName(Map<String, String> kubernetesDeployerProperties) {
        String taskServiceAccountName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".taskServiceAccountName", "");
        if (StringUtils.hasText((String)taskServiceAccountName)) {
            return taskServiceAccountName;
        }
        return this.properties instanceof KubernetesSchedulerProperties ? ((KubernetesSchedulerProperties)this.properties).getTaskServiceAccountName() : null;
    }

    private static KubernetesDeployerProperties bindProperties(Map<String, String> kubernetesDeployerProperties, String propertyKey, String yamlLabel) {
        String deploymentPropertyValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, propertyKey);
        KubernetesDeployerProperties deployerProperties = new KubernetesDeployerProperties();
        if (!StringUtils.isEmpty((Object)deploymentPropertyValue)) {
            try {
                YamlPropertiesFactoryBean properties = new YamlPropertiesFactoryBean();
                String tmpYaml = "{ " + yamlLabel + ": " + deploymentPropertyValue + " }";
                properties.setResources(new Resource[]{new ByteArrayResource(tmpYaml.getBytes())});
                Properties yaml = properties.getObject();
                MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)yaml);
                deployerProperties = (KubernetesDeployerProperties)new Binder(new ConfigurationPropertySource[]{source}).bind("", Bindable.of(KubernetesDeployerProperties.class)).get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid binding property '%s'", deploymentPropertyValue), e);
            }
        }
        return deployerProperties;
    }

    String getStatefulSetInitContainerImageName(Map<String, String> kubernetesDeployerProperties) {
        String statefulSetInitContainerImageName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".statefulSetInitContainerImageName", "");
        if (StringUtils.hasText((String)statefulSetInitContainerImageName)) {
            return statefulSetInitContainerImageName;
        }
        statefulSetInitContainerImageName = this.properties.getStatefulSetInitContainerImageName();
        if (StringUtils.hasText((String)statefulSetInitContainerImageName)) {
            return statefulSetInitContainerImageName;
        }
        return STATEFUL_SET_IMAGE_NAME;
    }

    Map<String, String> getJobAnnotations(Map<String, String> kubernetesDeployerProperties) {
        String annotationsProperty = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".jobAnnotations", "");
        if (StringUtils.isEmpty((Object)annotationsProperty)) {
            annotationsProperty = this.properties.getJobAnnotations();
        }
        return PropertyParserUtils.getStringPairsToMap(annotationsProperty);
    }

    List<VolumeMount> getVolumeMounts(Map<String, String> deploymentProperties) {
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        String volumeMountDeploymentProperty = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".volumeMounts");
        if (!StringUtils.isEmpty((Object)volumeMountDeploymentProperty)) {
            try {
                YamlPropertiesFactoryBean properties = new YamlPropertiesFactoryBean();
                String tmpYaml = "{ volume-mounts: " + volumeMountDeploymentProperty + " }";
                properties.setResources(new Resource[]{new ByteArrayResource(tmpYaml.getBytes())});
                Properties yaml = properties.getObject();
                MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)yaml);
                KubernetesDeployerProperties deployerProperties = (KubernetesDeployerProperties)new Binder(new ConfigurationPropertySource[]{source}).bind("", Bindable.of(KubernetesDeployerProperties.class)).get();
                volumeMounts.addAll(deployerProperties.getVolumeMounts());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid volume mount '%s'", volumeMountDeploymentProperty), e);
            }
        }
        volumeMounts.addAll(this.properties.getVolumeMounts().stream().filter(volumeMount -> volumeMounts.stream().noneMatch(existingVolumeMount -> existingVolumeMount.getName().equals(volumeMount.getName()))).collect(Collectors.toList()));
        return volumeMounts;
    }

    List<String> getContainerCommand(Map<String, String> deploymentProperties) {
        String containerCommand = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".containerCommand", "");
        return new CommandLineTokenizer(containerCommand).getArgs();
    }

    List<Integer> getContainerPorts(Map<String, String> deploymentProperties) {
        ArrayList<Integer> containerPortList = new ArrayList<Integer>();
        String containerPorts = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".containerPorts", null);
        if (containerPorts != null) {
            String[] containerPortSplit;
            for (String containerPort : containerPortSplit = containerPorts.split(",")) {
                this.logger.trace((Object)("Adding container ports from AppDeploymentRequest: " + containerPort));
                Integer port = Integer.parseInt(containerPort.trim());
                containerPortList.add(port);
            }
        }
        return containerPortList;
    }

    Map<String, String> getAppEnvironmentVariables(Map<String, String> deploymentProperties) {
        HashMap<String, String> appEnvVarMap = new HashMap<String, String>();
        String appEnvVar = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".environmentVariables", null);
        if (appEnvVar != null) {
            String[] appEnvVars;
            for (String envVar : appEnvVars = new NestedCommaDelimitedVariableParser().parse(appEnvVar)) {
                this.logger.trace((Object)("Adding environment variable from AppDeploymentRequest: " + envVar));
                String[] strings = envVar.split("=", 2);
                Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
                appEnvVarMap.put(strings[0], strings[1]);
            }
        }
        return appEnvVarMap;
    }

    EntryPointStyle determineEntryPointStyle(Map<String, String> deploymentProperties) {
        EntryPointStyle entryPointStyle = null;
        String deployerPropertyValue = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".entryPointStyle", null);
        if (deployerPropertyValue != null) {
            try {
                entryPointStyle = EntryPointStyle.valueOf(deployerPropertyValue.toLowerCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (entryPointStyle == null) {
            entryPointStyle = this.properties.getEntryPointStyle();
        }
        return entryPointStyle;
    }

    List<EnvVar> getConfigMapKeyRefs(Map<String, String> deploymentProperties) {
        ArrayList<EnvVar> configMapKeyRefs = new ArrayList<EnvVar>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(deploymentProperties, this.propertyPrefix + ".configMapKeyRefs", "configMapKeyRefs");
        deployerProperties.getConfigMapKeyRefs().forEach(configMapKeyRef -> configMapKeyRefs.add(this.buildConfigMapKeyRefEnvVar((KubernetesDeployerProperties.ConfigMapKeyRef)configMapKeyRef)));
        this.properties.getConfigMapKeyRefs().stream().filter(configMapKeyRef -> configMapKeyRefs.stream().noneMatch(existing -> existing.getName().equals(configMapKeyRef.getEnvVarName()))).collect(Collectors.toList()).forEach(configMapKeyRef -> configMapKeyRefs.add(this.buildConfigMapKeyRefEnvVar((KubernetesDeployerProperties.ConfigMapKeyRef)configMapKeyRef)));
        return configMapKeyRefs;
    }

    private EnvVar buildConfigMapKeyRefEnvVar(KubernetesDeployerProperties.ConfigMapKeyRef configMapKeyRef) {
        ConfigMapKeySelector configMapKeySelector = new ConfigMapKeySelector();
        EnvVarSource envVarSource = new EnvVarSource();
        envVarSource.setConfigMapKeyRef(configMapKeySelector);
        EnvVar configMapKeyEnvRefVar = new EnvVar();
        configMapKeyEnvRefVar.setValueFrom(envVarSource);
        configMapKeySelector.setName(configMapKeyRef.getConfigMapName());
        configMapKeySelector.setKey(configMapKeyRef.getDataKey());
        configMapKeyEnvRefVar.setName(configMapKeyRef.getEnvVarName());
        return configMapKeyEnvRefVar;
    }

    List<EnvVar> getSecretKeyRefs(Map<String, String> deploymentProperties) {
        ArrayList<EnvVar> secretKeyRefs = new ArrayList<EnvVar>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(deploymentProperties, this.propertyPrefix + ".secretKeyRefs", "secretKeyRefs");
        deployerProperties.getSecretKeyRefs().forEach(secretKeyRef -> secretKeyRefs.add(this.buildSecretKeyRefEnvVar((KubernetesDeployerProperties.SecretKeyRef)secretKeyRef)));
        this.properties.getSecretKeyRefs().stream().filter(secretKeyRef -> secretKeyRefs.stream().noneMatch(existing -> existing.getName().equals(secretKeyRef.getEnvVarName()))).collect(Collectors.toList()).forEach(secretKeyRef -> secretKeyRefs.add(this.buildSecretKeyRefEnvVar((KubernetesDeployerProperties.SecretKeyRef)secretKeyRef)));
        return secretKeyRefs;
    }

    private EnvVar buildSecretKeyRefEnvVar(KubernetesDeployerProperties.SecretKeyRef secretKeyRef) {
        SecretKeySelector secretKeySelector = new SecretKeySelector();
        EnvVarSource envVarSource = new EnvVarSource();
        envVarSource.setSecretKeyRef(secretKeySelector);
        EnvVar secretKeyEnvRefVar = new EnvVar();
        secretKeyEnvRefVar.setValueFrom(envVarSource);
        secretKeySelector.setName(secretKeyRef.getSecretName());
        secretKeySelector.setKey(secretKeyRef.getDataKey());
        secretKeyEnvRefVar.setName(secretKeyRef.getEnvVarName());
        return secretKeyEnvRefVar;
    }

    List<EnvFromSource> getConfigMapRefs(Map<String, String> deploymentProperties) {
        ArrayList<EnvFromSource> configMapRefs = new ArrayList<EnvFromSource>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(deploymentProperties, this.propertyPrefix + ".configMapRefs", "configMapRefs");
        deployerProperties.getConfigMapRefs().forEach(configMapRef -> configMapRefs.add(this.buildConfigMapRefEnvVar((String)configMapRef)));
        if (deployerProperties.getConfigMapRefs().isEmpty()) {
            this.properties.getConfigMapRefs().stream().filter(configMapRef -> configMapRefs.stream().noneMatch(existing -> existing.getConfigMapRef().getName().equals(configMapRef))).collect(Collectors.toList()).forEach(configMapRef -> configMapRefs.add(this.buildConfigMapRefEnvVar((String)configMapRef)));
        }
        return configMapRefs;
    }

    private EnvFromSource buildConfigMapRefEnvVar(String configMapRefName) {
        ConfigMapEnvSource configMapEnvSource = new ConfigMapEnvSource();
        configMapEnvSource.setName(configMapRefName);
        EnvFromSource envFromSource = new EnvFromSource();
        envFromSource.setConfigMapRef(configMapEnvSource);
        return envFromSource;
    }

    List<EnvFromSource> getSecretRefs(Map<String, String> deploymentProperties) {
        ArrayList<EnvFromSource> secretRefs = new ArrayList<EnvFromSource>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(deploymentProperties, this.propertyPrefix + ".secretRefs", "secretRefs");
        deployerProperties.getSecretRefs().forEach(secretRef -> secretRefs.add(this.buildSecretRefEnvVar((String)secretRef)));
        if (deployerProperties.getSecretRefs().isEmpty()) {
            this.properties.getSecretRefs().stream().filter(secretRef -> secretRefs.stream().noneMatch(existing -> existing.getSecretRef().getName().equals(secretRef))).collect(Collectors.toList()).forEach(secretRef -> secretRefs.add(this.buildSecretRefEnvVar((String)secretRef)));
        }
        return secretRefs;
    }

    private EnvFromSource buildSecretRefEnvVar(String secretRefName) {
        SecretEnvSource secretEnvSource = new SecretEnvSource();
        secretEnvSource.setName(secretRefName);
        EnvFromSource envFromSource = new EnvFromSource();
        envFromSource.setSecretRef(secretEnvSource);
        return envFromSource;
    }

    static class NestedCommaDelimitedVariableParser {
        static final String REGEX = "(\\w+='.+?'),?";
        static final Pattern pattern = Pattern.compile("(\\w+='.+?'),?");

        NestedCommaDelimitedVariableParser() {
        }

        String[] parse(String value) {
            ArrayList<String> vars = new ArrayList<String>();
            Matcher m = pattern.matcher(value);
            while (m.find()) {
                String replacedVar = m.group(1).replaceAll("'", "");
                if (StringUtils.isEmpty((Object)replacedVar)) continue;
                vars.add(replacedVar);
            }
            String nonQuotedVars = value.replaceAll(pattern.pattern(), "");
            if (!StringUtils.isEmpty((Object)nonQuotedVars)) {
                vars.addAll(Arrays.asList(nonQuotedVars.split(",")));
            }
            return vars.toArray(new String[0]);
        }
    }
}

