/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.scheduler.kubernetes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.cloud.deployer.spi.scheduler.kubernetes.KubernetesSchedulerProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class KubernetesSchedulerPropertyResolver {
    private static final NestedCommaDelimitedVariableParser nestedCommaDelimitedVariableParser = new NestedCommaDelimitedVariableParser();

    KubernetesSchedulerPropertyResolver() {
    }

    public static String getImagePullPolicy(ScheduleRequest scheduleRequest, KubernetesSchedulerProperties kubernetesSchedulerProperties) {
        String imagePullPolicy = (String)scheduleRequest.getSchedulerProperties().get("spring.cloud.scheduler.kubernetes.imagePullPolicy");
        if (StringUtils.hasText((String)imagePullPolicy)) {
            return ImagePullPolicy.relaxedValueOf(imagePullPolicy).name();
        }
        return kubernetesSchedulerProperties.getImagePullPolicy().name();
    }

    public static EntryPointStyle getEntryPointStyle(ScheduleRequest scheduleRequest, KubernetesSchedulerProperties kubernetesSchedulerProperties) {
        String entryPointStyle = (String)scheduleRequest.getSchedulerProperties().get("spring.cloud.scheduler.kubernetes.entryPointStyle");
        if (StringUtils.hasText((String)entryPointStyle)) {
            return EntryPointStyle.relaxedValueOf(entryPointStyle);
        }
        return kubernetesSchedulerProperties.getEntryPointStyle();
    }

    public static Map<String, String> getTaskEnvironmentVariables(ScheduleRequest request, KubernetesSchedulerProperties kubernetesSchedulerProperties) {
        HashMap<String, String> environmentVariableMap = new HashMap<String, String>();
        for (String environmentVariable : kubernetesSchedulerProperties.getEnvironmentVariables()) {
            environmentVariableMap.putAll(KubernetesSchedulerPropertyResolver.parseEnvironmentVariables(environmentVariable));
        }
        String taskEnvironmentVariables = (String)request.getSchedulerProperties().get("spring.cloud.scheduler.kubernetes.environmentVariables");
        environmentVariableMap.putAll(KubernetesSchedulerPropertyResolver.parseEnvironmentVariables(taskEnvironmentVariables));
        return environmentVariableMap;
    }

    private static Map<String, String> parseEnvironmentVariables(String environmentVariables) {
        HashMap<String, String> environmentVariableMap = new HashMap<String, String>();
        if (environmentVariables != null) {
            String[] appEnvVars;
            for (String envVar : appEnvVars = nestedCommaDelimitedVariableParser.parse(environmentVariables)) {
                String[] strings = envVar.split("=", 2);
                Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
                environmentVariableMap.put(strings[0], strings[1]);
            }
        }
        return environmentVariableMap;
    }

    public static String getImagePullSecret(ScheduleRequest request, KubernetesSchedulerProperties kubernetesSchedulerProperties) {
        String imagePullSecret = (String)request.getSchedulerProperties().get("spring.cloud.scheduler.kubernetes.imagePullSecret");
        if (StringUtils.hasText((String)imagePullSecret)) {
            return imagePullSecret;
        }
        return kubernetesSchedulerProperties.getImagePullSecret();
    }

    public static String getTaskServiceAccountName(ScheduleRequest request, KubernetesSchedulerProperties kubernetesSchedulerProperties) {
        String taskServiceAccountName = (String)request.getSchedulerProperties().get("spring.cloud.scheduler.kubernetes.taskServiceAccountName");
        if (StringUtils.hasText((String)taskServiceAccountName)) {
            return taskServiceAccountName;
        }
        return kubernetesSchedulerProperties.getTaskServiceAccountName();
    }

    static class NestedCommaDelimitedVariableParser {
        static final String REGEX = "(\\w+='.+?'),?";
        static final Pattern pattern = Pattern.compile("(\\w+='.+?'),?");

        NestedCommaDelimitedVariableParser() {
        }

        String[] parse(String value) {
            String[] vars = value.replaceAll(pattern.pattern(), "").split(",");
            Matcher m = pattern.matcher(value);
            while (m.find()) {
                vars = Arrays.copyOf(vars, vars.length + 1);
                vars[vars.length - 1] = m.group(1).replaceAll("'", "");
            }
            return vars;
        }
    }
}

