/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.scheduler.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.StatusCause;
import io.fabric8.kubernetes.api.model.batch.CronJob;
import io.fabric8.kubernetes.api.model.batch.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.CronJobList;
import io.fabric8.kubernetes.api.model.batch.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.JobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.JobTemplateSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.cloud.deployer.spi.scheduler.CreateScheduleException;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleInfo;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.cloud.deployer.spi.scheduler.Scheduler;
import org.springframework.cloud.deployer.spi.scheduler.SchedulerException;
import org.springframework.cloud.deployer.spi.scheduler.kubernetes.ContainerCreator;
import org.springframework.cloud.deployer.spi.scheduler.kubernetes.KubernetesSchedulerProperties;
import org.springframework.cloud.deployer.spi.scheduler.kubernetes.KubernetesSchedulerPropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KubernetesScheduler
implements Scheduler {
    private static final String SPRING_CRONJOB_ID_KEY = "spring-cronjob-id";
    private static final String SCHEDULE_EXPRESSION_FIELD_NAME = "spec.schedule";
    private final KubernetesClient kubernetesClient;
    private final KubernetesSchedulerProperties kubernetesSchedulerProperties;

    public KubernetesScheduler(KubernetesClient kubernetesClient, KubernetesSchedulerProperties kubernetesSchedulerProperties) {
        Assert.notNull((Object)kubernetesClient, (String)"KubernetesClient must not be null");
        Assert.notNull((Object)kubernetesSchedulerProperties, (String)"KubernetesSchedulerProperties must not be null");
        this.kubernetesClient = kubernetesClient;
        this.kubernetesSchedulerProperties = kubernetesSchedulerProperties;
    }

    public void schedule(ScheduleRequest scheduleRequest) {
        if (scheduleRequest != null) {
            this.validateScheduleName(scheduleRequest);
        }
        try {
            this.createCronJob(scheduleRequest);
        }
        catch (KubernetesClientException e) {
            String invalidCronExceptionMessage = this.getExceptionMessageForField(e, SCHEDULE_EXPRESSION_FIELD_NAME);
            if (StringUtils.hasText((String)invalidCronExceptionMessage)) {
                throw new CreateScheduleException(invalidCronExceptionMessage, (Throwable)e);
            }
            throw new CreateScheduleException("Failed to create schedule " + scheduleRequest.getScheduleName(), (Throwable)e);
        }
    }

    public void validateScheduleName(ScheduleRequest request) {
        if (request.getScheduleName() == null) {
            throw new CreateScheduleException("The name for the schedule request is null", null);
        }
        if (!Pattern.matches("^[a-z0-9]([-a-z0-9]*[a-z0-9])?$", request.getScheduleName())) {
            throw new CreateScheduleException("Invalid Format for Schedule Name. Schedule name can only contain lowercase letters, numbers 0-9 and hyphens.", null);
        }
    }

    public void unschedule(String scheduleName) {
        boolean unscheduled = (Boolean)((Resource)this.kubernetesClient.batch().cronjobs().withName(scheduleName)).delete();
        if (!unscheduled) {
            throw new SchedulerException("Failed to unschedule schedule " + scheduleName + " does not exist.");
        }
    }

    public List<ScheduleInfo> list(String taskDefinitionName) {
        return this.list().stream().filter(scheduleInfo -> taskDefinitionName.equals(scheduleInfo.getTaskDefinitionName())).collect(Collectors.toList());
    }

    public List<ScheduleInfo> list() {
        CronJobList cronJobList = (CronJobList)this.kubernetesClient.batch().cronjobs().list();
        List cronJobs = cronJobList.getItems();
        ArrayList<ScheduleInfo> scheduleInfos = new ArrayList<ScheduleInfo>();
        for (CronJob cronJob : cronJobs) {
            if (cronJob.getMetadata() == null || cronJob.getMetadata().getLabels() == null || !StringUtils.hasText((String)((String)cronJob.getMetadata().getLabels().get(SPRING_CRONJOB_ID_KEY)))) continue;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("spring.cloud.scheduler.cron.expression", cronJob.getSpec().getSchedule());
            ScheduleInfo scheduleInfo = new ScheduleInfo();
            scheduleInfo.setScheduleName(cronJob.getMetadata().getName());
            scheduleInfo.setTaskDefinitionName((String)cronJob.getMetadata().getLabels().get(SPRING_CRONJOB_ID_KEY));
            scheduleInfo.setScheduleProperties(properties);
            scheduleInfos.add(scheduleInfo);
        }
        return scheduleInfos;
    }

    protected CronJob createCronJob(ScheduleRequest scheduleRequest) {
        Map<String, String> labels = Collections.singletonMap(SPRING_CRONJOB_ID_KEY, scheduleRequest.getDefinition().getName());
        String schedule = (String)scheduleRequest.getSchedulerProperties().get("spring.cloud.scheduler.cron.expression");
        Assert.hasText((String)schedule, (String)"The property: spring.cloud.scheduler.cron.expression must be defined");
        Container container = new ContainerCreator(this.kubernetesSchedulerProperties, scheduleRequest).build();
        String taskServiceAccountName = KubernetesSchedulerPropertyResolver.getTaskServiceAccountName(scheduleRequest, this.kubernetesSchedulerProperties);
        String restartPolicy = this.kubernetesSchedulerProperties.getRestartPolicy().name();
        CronJob cronJob = ((CronJobBuilder)((CronJobFluent.SpecNested)((CronJobSpecFluent.JobTemplateNested)((JobTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((CronJobFluent.SpecNested)((CronJobBuilder)((CronJobFluent.MetadataNested)((CronJobFluent.MetadataNested)new CronJobBuilder().withNewMetadata().withName(scheduleRequest.getScheduleName())).withLabels(labels)).endMetadata()).withNewSpec().withSchedule(schedule)).withNewJobTemplate().withNewSpec().withNewTemplate().withNewSpec().withServiceAccountName(taskServiceAccountName)).withContainers(new Container[]{container})).withRestartPolicy(restartPolicy)).endSpec()).endTemplate()).endSpec()).endJobTemplate()).endSpec()).build();
        this.setImagePullSecret(scheduleRequest, cronJob);
        return (CronJob)this.kubernetesClient.batch().cronjobs().create((Object[])new CronJob[]{cronJob});
    }

    protected String getExceptionMessageForField(KubernetesClientException kubernetesClientException, String fieldName) {
        List statusCauses = kubernetesClientException.getStatus().getDetails().getCauses();
        if (!CollectionUtils.isEmpty((Collection)statusCauses)) {
            for (StatusCause statusCause : statusCauses) {
                if (!fieldName.equals(statusCause.getField())) continue;
                return kubernetesClientException.getStatus().getMessage();
            }
        }
        return null;
    }

    private void setImagePullSecret(ScheduleRequest scheduleRequest, CronJob cronJob) {
        String imagePullSecret = KubernetesSchedulerPropertyResolver.getImagePullSecret(scheduleRequest, this.kubernetesSchedulerProperties);
        if (StringUtils.hasText((String)imagePullSecret)) {
            LocalObjectReference localObjectReference = new LocalObjectReference();
            localObjectReference.setName(imagePullSecret);
            cronJob.getSpec().getJobTemplate().getSpec().getTemplate().getSpec().getImagePullSecrets().add(localObjectReference);
        }
    }
}

