/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PropertyParserUtils {
    PropertyParserUtils() {
    }

    static Map<String, String> getAnnotations(String annotation) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        if (StringUtils.hasText((String)annotation)) {
            String[] annotationPairs;
            for (String annotationPair : annotationPairs = annotation.split(",")) {
                String[] splitAnnotation = annotationPair.split(":", 2);
                Assert.isTrue((splitAnnotation.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid annotation value: %s", annotationPair));
                annotations.put(splitAnnotation[0].trim(), splitAnnotation[1].trim());
            }
        }
        return annotations;
    }

    static KubernetesDeployerProperties bindProperties(AppDeploymentRequest request, String propertyKey, String yamlLabel) {
        String deploymentProperty = request.getDeploymentProperties().getOrDefault(propertyKey, "");
        KubernetesDeployerProperties deployerProperties = new KubernetesDeployerProperties();
        if (!StringUtils.isEmpty((Object)deploymentProperty)) {
            try {
                YamlPropertiesFactoryBean properties = new YamlPropertiesFactoryBean();
                String tmpYaml = "{ " + yamlLabel + ": " + deploymentProperty + " }";
                properties.setResources(new Resource[]{new ByteArrayResource(tmpYaml.getBytes())});
                Properties yaml = properties.getObject();
                MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)yaml);
                deployerProperties = (KubernetesDeployerProperties)new Binder(new ConfigurationPropertySource[]{source}).bind("", Bindable.of(KubernetesDeployerProperties.class)).get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid binding property '%s'", deploymentProperty), e);
            }
        }
        return deployerProperties;
    }
}

