/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.bind.YamlConfigurationFactory;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesAppInstanceStatus;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AbstractKubernetesDeployer {
    protected static final String SPRING_DEPLOYMENT_KEY = "spring-deployment-id";
    protected static final String SPRING_GROUP_KEY = "spring-group-id";
    protected static final String SPRING_APP_KEY = "spring-app-id";
    protected static final String SPRING_MARKER_KEY = "role";
    protected static final String SPRING_MARKER_VALUE = "spring-app";
    protected final Log logger = LogFactory.getLog((String)this.getClass().getName());
    protected ContainerFactory containerFactory;
    protected KubernetesClient client;
    protected KubernetesDeployerProperties properties = new KubernetesDeployerProperties();

    protected RuntimeEnvironmentInfo createRuntimeEnvironmentInfo(Class spiClass, Class implementationClass) {
        return new RuntimeEnvironmentInfo.Builder().spiClass(spiClass).implementationName(implementationClass.getSimpleName()).implementationVersion(RuntimeVersionUtils.getVersion((Class)implementationClass)).platformType("Kubernetes").platformApiVersion(this.client.getApiVersion()).platformClientVersion(RuntimeVersionUtils.getVersion(this.client.getClass())).platformHostVersion("unknown").addPlatformSpecificInfo("master-url", String.valueOf(this.client.getMasterUrl())).addPlatformSpecificInfo("namespace", this.client.getNamespace()).build();
    }

    protected Map<String, String> createIdMap(String appId, AppDeploymentRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SPRING_APP_KEY, appId);
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        if (groupId != null) {
            map.put(SPRING_GROUP_KEY, groupId);
        }
        map.put(SPRING_DEPLOYMENT_KEY, appId);
        return map;
    }

    protected AppStatus buildAppStatus(String id, PodList podList, ServiceList services) {
        AppStatus.Builder statusBuilder = AppStatus.of((String)id);
        Service service = null;
        if (podList != null && podList.getItems() != null) {
            for (Pod pod : podList.getItems()) {
                for (Service svc : services.getItems()) {
                    if (!svc.getMetadata().getName().equals(pod.getMetadata().getLabels().get(SPRING_DEPLOYMENT_KEY))) continue;
                    service = svc;
                    break;
                }
                statusBuilder.with((AppInstanceStatus)new KubernetesAppInstanceStatus(pod, service, this.properties));
            }
        }
        return statusBuilder.build();
    }

    protected PodSpec createPodSpec(String appId, AppDeploymentRequest request, Integer port, boolean neverRestart) {
        String deploymentServiceAcccountName;
        PodSpecBuilder podSpec = new PodSpecBuilder();
        String imagePullSecret = this.getImagePullSecret(request);
        if (imagePullSecret != null) {
            podSpec.addNewImagePullSecret(imagePullSecret);
        }
        boolean hostNetwork = this.getHostNetwork(request);
        ContainerConfiguration containerConfiguration = new ContainerConfiguration(appId, request).withProbeCredentialsSecret(this.getProbeCredentialsSecret(request)).withExternalPort(port).withHostNetwork(hostNetwork);
        Container container = this.containerFactory.create(containerConfiguration);
        ResourceRequirements req = new ResourceRequirements();
        req.setLimits(this.deduceResourceLimits(request));
        req.setRequests(this.deduceResourceRequests(request));
        container.setResources(req);
        ImagePullPolicy pullPolicy = this.deduceImagePullPolicy(request);
        container.setImagePullPolicy(pullPolicy.name());
        Map<String, String> nodeSelectors = this.getNodeSelectors(request.getDeploymentProperties());
        if (nodeSelectors.size() > 0) {
            podSpec.withNodeSelector(nodeSelectors);
        }
        podSpec.withVolumes(this.getVolumes(request).stream().filter(volume -> container.getVolumeMounts().stream().anyMatch(volumeMount -> volumeMount.getName().equals(volume.getName()))).collect(Collectors.toList()));
        if (hostNetwork) {
            podSpec.withHostNetwork(Boolean.valueOf(true));
        }
        podSpec.addToContainers(new Container[]{container});
        if (neverRestart) {
            podSpec.withRestartPolicy("Never");
        }
        if ((deploymentServiceAcccountName = this.getDeploymentServiceAccountName(request)) != null) {
            podSpec.withServiceAccountName(deploymentServiceAcccountName);
        }
        return podSpec.build();
    }

    protected List<Volume> getVolumes(AppDeploymentRequest request) {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        String volumeDeploymentProperty = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.volumes", "");
        if (!StringUtils.isEmpty((Object)volumeDeploymentProperty)) {
            YamlConfigurationFactory volumeYamlConfigurationFactory = new YamlConfigurationFactory(KubernetesDeployerProperties.class);
            volumeYamlConfigurationFactory.setYaml("{ volumes: " + volumeDeploymentProperty + " }");
            try {
                volumeYamlConfigurationFactory.afterPropertiesSet();
                volumes.addAll(((KubernetesDeployerProperties)volumeYamlConfigurationFactory.getObject()).getVolumes());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid volume '%s'", volumeDeploymentProperty), e);
            }
        }
        volumes.addAll(this.properties.getVolumes().stream().filter(volume -> volumes.stream().noneMatch(existingVolume -> existingVolume.getName().equals(volume.getName()))).collect(Collectors.toList()));
        return volumes;
    }

    protected Map<String, Quantity> deduceResourceLimits(AppDeploymentRequest request) {
        String cpuLimitsOverride;
        String memLimitsOverride;
        String memDeployer = this.getCommonDeployerMemory(request);
        String memOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.memory");
        if (memDeployer != null) {
            if (memOverride == null) {
                memOverride = memDeployer;
            } else {
                this.logger.warn((Object)String.format("Both spring.cloud.deployer.memory=%s and spring.cloud.deployer.kubernetes.memory=%s specified, the latter will take precedence.", memDeployer, memOverride));
            }
        }
        if ((memLimitsOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.limits.memory")) != null) {
            memOverride = memLimitsOverride;
        }
        if (memOverride == null && this.properties.getLimits().getMemory() != null) {
            memOverride = this.properties.getLimits().getMemory();
        }
        String cpuDeployer = (String)request.getDeploymentProperties().get("spring.cloud.deployer.cpu");
        String cpuOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.cpu");
        if (cpuDeployer != null) {
            if (cpuOverride == null) {
                cpuOverride = cpuDeployer;
            } else {
                this.logger.warn((Object)String.format("Both spring.cloud.deployer.cpu=%s and spring.cloud.deployer.kubernetes.cpu=%s specified, the latter will take precedence.", cpuDeployer, cpuOverride));
            }
        }
        if ((cpuLimitsOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.limits.cpu")) != null) {
            cpuOverride = cpuLimitsOverride;
        }
        if (cpuOverride == null && this.properties.getLimits().getCpu() != null) {
            cpuOverride = this.properties.getLimits().getCpu();
        }
        this.logger.debug((Object)("Using limits - cpu: " + cpuOverride + " mem: " + memOverride));
        HashMap<String, Quantity> limits = new HashMap<String, Quantity>();
        limits.put("memory", new Quantity(memOverride));
        limits.put("cpu", new Quantity(cpuOverride));
        return limits;
    }

    protected ImagePullPolicy deduceImagePullPolicy(AppDeploymentRequest request) {
        ImagePullPolicy pullPolicy;
        String pullPolicyOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.imagePullPolicy");
        if (pullPolicyOverride == null) {
            pullPolicy = this.properties.getImagePullPolicy();
        } else {
            pullPolicy = ImagePullPolicy.relaxedValueOf(pullPolicyOverride);
            if (pullPolicy == null) {
                this.logger.warn((Object)("Parsing of pull policy " + pullPolicyOverride + " failed, using default \"IfNotPresent\"."));
                pullPolicy = ImagePullPolicy.IfNotPresent;
            }
        }
        this.logger.debug((Object)("Using imagePullPolicy " + (Object)((Object)pullPolicy)));
        return pullPolicy;
    }

    protected Map<String, Quantity> deduceResourceRequests(AppDeploymentRequest request) {
        String cpuOverride;
        String memOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.requests.memory");
        if (memOverride == null) {
            memOverride = this.properties.getRequests().getMemory();
        }
        if ((cpuOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.requests.cpu")) == null) {
            cpuOverride = this.properties.getRequests().getCpu();
        }
        this.logger.debug((Object)("Using requests - cpu: " + cpuOverride + " mem: " + memOverride));
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>();
        if (memOverride != null) {
            requests.put("memory", new Quantity(memOverride));
        }
        if (cpuOverride != null) {
            requests.put("cpu", new Quantity(cpuOverride));
        }
        return requests;
    }

    protected String getStatefulSetStorageClassName(AppDeploymentRequest request) {
        String storageClassName = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.statefulSet.volumeClaimTemplate.storageClassName");
        if (storageClassName == null && this.properties.getStatefulSet() != null && this.properties.getStatefulSet().getVolumeClaimTemplate() != null) {
            storageClassName = this.properties.getStatefulSet().getVolumeClaimTemplate().getStorageClassName();
        }
        return storageClassName;
    }

    protected String getStatefulSetStorage(AppDeploymentRequest request) {
        String storage = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.statefulSet.volumeClaimTemplate.storage");
        if (storage == null && this.properties.getStatefulSet() != null && this.properties.getStatefulSet().getVolumeClaimTemplate() != null) {
            storage = this.properties.getStatefulSet().getVolumeClaimTemplate().getStorage();
        }
        long storageAmount = ByteSizeUtils.parseToMebibytes((String)storage);
        return storageAmount + "Mi";
    }

    protected boolean getHostNetwork(AppDeploymentRequest request) {
        String hostNetworkOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.hostNetwork");
        boolean hostNetwork = StringUtils.isEmpty((Object)hostNetworkOverride) ? this.properties.isHostNetwork() : Boolean.valueOf(hostNetworkOverride).booleanValue();
        this.logger.debug((Object)("Using hostNetwork " + hostNetwork));
        return hostNetwork;
    }

    protected Map<String, String> getNodeSelectors(Map<String, String> properties) {
        HashMap<String, String> nodeSelectors = new HashMap<String, String>();
        String nodeSelectorsProperty = properties.getOrDefault("spring.cloud.deployer.kubernetes.deployment.nodeSelector", "");
        if (StringUtils.hasText((String)nodeSelectorsProperty)) {
            String[] nodeSelectorPairs;
            for (String nodeSelectorPair : nodeSelectorPairs = nodeSelectorsProperty.split(",")) {
                String[] nodeSelector = nodeSelectorPair.split(":");
                Assert.isTrue((nodeSelector.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid nodeSelector value: '{}'", nodeSelectorPair));
                nodeSelectors.put(nodeSelector[0].trim(), nodeSelector[1].trim());
            }
        }
        return nodeSelectors;
    }

    private String getCommonDeployerMemory(AppDeploymentRequest request) {
        String mem = (String)request.getDeploymentProperties().get("spring.cloud.deployer.memory");
        if (mem == null) {
            return null;
        }
        long memAmount = ByteSizeUtils.parseToMebibytes((String)mem);
        return memAmount + "Mi";
    }

    private String getImagePullSecret(AppDeploymentRequest request) {
        String imagePullSecret = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.imagePullSecret", "");
        if (StringUtils.isEmpty((Object)imagePullSecret)) {
            imagePullSecret = this.properties.getImagePullSecret();
        }
        return imagePullSecret;
    }

    private String getDeploymentServiceAccountName(AppDeploymentRequest request) {
        String deploymentServiceAccountName = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.deploymentServiceAccountName");
        if (StringUtils.isEmpty((Object)deploymentServiceAccountName)) {
            deploymentServiceAccountName = this.properties.getDeploymentServiceAccountName();
        }
        return deploymentServiceAccountName;
    }

    private Secret getProbeCredentialsSecret(AppDeploymentRequest request) {
        Secret secret = null;
        String probeCredentialsSecret = "spring.cloud.deployer.kubernetes.probeCredentialsSecret";
        if (request.getDeploymentProperties().containsKey(probeCredentialsSecret)) {
            String secretName = (String)request.getDeploymentProperties().get(probeCredentialsSecret);
            secret = (Secret)((Resource)this.client.secrets().withName(secretName)).get();
        }
        return secret;
    }
}

