/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeAuthenticationType;
import org.springframework.util.Assert;

class ProbeCreator {
    private static final String KUBERNETES_DEPLOYER_PREFIX = "spring.cloud.deployer.kubernetes";
    protected static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    protected static final String PROBE_CREDENTIALS_SECRET_KEY_NAME = "credentials";
    private Integer externalPort;
    private String endpoint;
    private int timeout;
    private int initialDelay;
    private int period;
    private String prefix;
    private Map<String, String> deployProperties;
    private Secret probeCredentialsSecret;

    ProbeCreator(Integer externalPort, String endpoint, int timeout, int initialDelay, int period, String prefix, Map<String, String> deployProperties) {
        this.externalPort = externalPort;
        this.endpoint = endpoint;
        this.timeout = timeout;
        this.initialDelay = initialDelay;
        this.period = period;
        this.prefix = prefix;
        this.deployProperties = deployProperties;
    }

    Probe create() {
        this.setPropertyOverrides();
        HTTPGetActionBuilder httpGetActionBuilder = (HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath(this.endpoint)).withNewPort(this.externalPort);
        List<HTTPHeader> httpHeaders = this.getHttpHeaders();
        if (!httpHeaders.isEmpty()) {
            httpGetActionBuilder.withHttpHeaders(httpHeaders);
        }
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withHttpGet(httpGetActionBuilder.build())).withTimeoutSeconds(Integer.valueOf(this.timeout))).withInitialDelaySeconds(Integer.valueOf(this.initialDelay))).withPeriodSeconds(Integer.valueOf(this.period))).build();
    }

    ProbeCreator withProbeCredentialsSecret(Secret probeCredentialsSecret) {
        this.probeCredentialsSecret = probeCredentialsSecret;
        return this;
    }

    private void setPropertyOverrides() {
        String probePeriodKey;
        String probeDelayKey;
        String probeTimeoutKey;
        String probePropertyPrefix = "spring.cloud.deployer.kubernetes." + this.prefix;
        String probePathKey = probePropertyPrefix + "ProbePath";
        if (this.deployProperties.containsKey(probePathKey)) {
            this.endpoint = this.deployProperties.get(probePathKey);
        }
        if (this.deployProperties.containsKey(probeTimeoutKey = probePropertyPrefix + "ProbeTimeout")) {
            this.timeout = Integer.valueOf(this.deployProperties.get(probeTimeoutKey));
        }
        if (this.deployProperties.containsKey(probeDelayKey = probePropertyPrefix + "ProbeDelay")) {
            this.initialDelay = Integer.valueOf(this.deployProperties.get(probeDelayKey));
        }
        if (this.deployProperties.containsKey(probePeriodKey = probePropertyPrefix + "ProbePeriod")) {
            this.period = Integer.valueOf(this.deployProperties.get(probePeriodKey));
        }
    }

    private List<HTTPHeader> getHttpHeaders() {
        ArrayList<HTTPHeader> httpHeaders = new ArrayList<HTTPHeader>();
        HTTPHeader authenticationHeader = this.getAuthorizationHeader();
        if (authenticationHeader != null) {
            httpHeaders.add(authenticationHeader);
        }
        return httpHeaders;
    }

    private HTTPHeader getAuthorizationHeader() {
        HTTPHeader httpHeader = null;
        if (this.probeCredentialsSecret != null) {
            Assert.isTrue((boolean)this.probeCredentialsSecret.getData().containsKey(PROBE_CREDENTIALS_SECRET_KEY_NAME), (String)"Secret does not contain a key by the name of credentials");
            httpHeader = new HTTPHeader();
            httpHeader.setName(AUTHORIZATION_HEADER_NAME);
            httpHeader.setValue(ProbeAuthenticationType.Basic.name() + " " + (String)this.probeCredentialsSecret.getData().get(PROBE_CREDENTIALS_SECRET_KEY_NAME));
        }
        return httpHeader;
    }
}

