/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hashids.Hashids;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;

public class KubernetesTaskLauncher
extends AbstractKubernetesDeployer
implements TaskLauncher {
    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties properties, KubernetesClient client) {
        this(properties, client, new DefaultContainerFactory(properties));
    }

    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties properties, KubernetesClient client, ContainerFactory containerFactory) {
        this.properties = properties;
        this.client = client;
        this.containerFactory = containerFactory;
    }

    public String launch(AppDeploymentRequest request) {
        String appId = this.createDeploymentId(request);
        TaskStatus status = this.status(appId);
        if (!status.getState().equals((Object)LaunchState.unknown)) {
            throw new IllegalStateException("Task " + appId + " already exists with a state of " + status);
        }
        Map<String, String> idMap = this.createIdMap(appId, request);
        this.logger.debug((Object)String.format("Launching pod for task: %s", appId));
        try {
            this.createPod(appId, request, idMap);
            return appId;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void cancel(String id) {
        this.logger.debug((Object)String.format("Cancelling task: %s", id));
        this.cleanup(id);
    }

    public void cleanup(String id) {
        this.logger.debug((Object)String.format("Deleting pod for task: %s", id));
        this.deletePod(id);
    }

    public void destroy(String appName) {
        for (String id : this.getPodIdsForTaskName(appName)) {
            this.cleanup(id);
        }
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return super.createRuntimeEnvironmentInfo(TaskLauncher.class, this.getClass());
    }

    public TaskStatus status(String id) {
        TaskStatus status = this.buildTaskStatus(id);
        this.logger.debug((Object)String.format("Status for task: %s is %s", id, status));
        return status;
    }

    protected String createDeploymentId(AppDeploymentRequest request) {
        String name = request.getDefinition().getName();
        Hashids hashids = new Hashids(name, 0, "abcdefghijklmnopqrstuvwxyz1234567890");
        String hashid = hashids.encode(new long[]{System.currentTimeMillis()});
        String deploymentId = name + "-" + hashid;
        return deploymentId.replace('.', '-').toLowerCase();
    }

    private void createPod(String appId, AppDeploymentRequest request, Map<String, String> idMap) {
        HashMap<String, String> podLabelMap = new HashMap<String, String>();
        podLabelMap.put("task-name", request.getDefinition().getName());
        podLabelMap.put("role", "spring-app");
        PodSpec spec = this.createPodSpec(appId, request, null, true);
        ((DoneablePod)((DoneablePod)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((DoneablePod)((NonNamespaceOperation)this.client.pods().inNamespace(this.client.getNamespace())).createNew()).withNewMetadata().withName(appId)).withLabels(podLabelMap)).addToLabels(idMap)).endMetadata()).withSpec(spec)).done();
    }

    private List<String> getPodIdsForTaskName(String taskName) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            PodList pods = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.client.getNamespace())).withLabel("task-name", taskName)).list();
            for (Pod pod : pods.getItems()) {
                ids.add(pod.getMetadata().getName());
            }
        }
        catch (KubernetesClientException kce) {
            this.logger.warn((Object)String.format("Failed to retrieve pods for task: %s", taskName), (Throwable)kce);
        }
        return ids;
    }

    private void deletePod(String id) {
        try {
            Boolean podDeleted = (Boolean)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.client.getNamespace())).withName(id)).delete();
            if (podDeleted.booleanValue()) {
                this.logger.debug((Object)String.format("Deleted pod successfully: %s", id));
            } else {
                this.logger.debug((Object)String.format("Delete failed for pod: %s", id));
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    TaskStatus buildTaskStatus(String id) {
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.client.getNamespace())).withName(id)).get();
        if (pod == null) {
            return new TaskStatus(id, LaunchState.unknown, new HashMap());
        }
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return new TaskStatus(id, LaunchState.unknown, new HashMap());
        }
        if (podStatus.getPhase() != null) {
            if (podStatus.getPhase().equals("Pending")) {
                return new TaskStatus(id, LaunchState.launching, new HashMap());
            }
            if (podStatus.getPhase().equals("Failed")) {
                return new TaskStatus(id, LaunchState.failed, new HashMap());
            }
            if (podStatus.getPhase().equals("Succeeded")) {
                return new TaskStatus(id, LaunchState.complete, new HashMap());
            }
            return new TaskStatus(id, LaunchState.running, new HashMap());
        }
        return new TaskStatus(id, LaunchState.launching, new HashMap());
    }
}

