/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.bind.YamlConfigurationFactory;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.util.CommandLineTokenizer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultContainerFactory
implements ContainerFactory {
    private static Log logger = LogFactory.getLog(DefaultContainerFactory.class);
    private final KubernetesDeployerProperties properties;
    private final NestedCommaDelimitedVariableParser nestedCommaDelimitedVariableParser = new NestedCommaDelimitedVariableParser();

    public DefaultContainerFactory(KubernetesDeployerProperties properties) {
        this.properties = properties;
    }

    @Override
    public Container create(String appId, AppDeploymentRequest request, Integer port, Integer instanceIndex, boolean hostNetwork) {
        return this.create(appId, request, port, hostNetwork);
    }

    @Override
    public Container create(String appId, AppDeploymentRequest request, Integer port, boolean hostNetwork) {
        List<String> containerCommand;
        List<Integer> additionalPorts;
        String image;
        try {
            image = request.getResource().getURI().getSchemeSpecificPart();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get URI for " + request.getResource(), e);
        }
        logger.info((Object)("Using Docker image: " + image));
        EntryPointStyle entryPointStyle = this.determineEntryPointStyle(this.properties, request);
        logger.info((Object)("Using Docker entry point style: " + (Object)((Object)entryPointStyle)));
        HashMap<String, String> envVarsMap = new HashMap<String, String>();
        for (String envVar : this.properties.getEnvironmentVariables()) {
            String[] strings = envVar.split("=", 2);
            Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
            envVarsMap.put(strings[0], strings[1]);
        }
        envVarsMap.putAll(this.getAppEnvironmentVariables(request));
        List<Object> appArgs = new ArrayList();
        switch (entryPointStyle) {
            case exec: {
                appArgs = this.createCommandArgs(request);
                break;
            }
            case boot: {
                if (envVarsMap.containsKey("SPRING_APPLICATION_JSON")) {
                    throw new IllegalStateException("You can't use boot entry point style and also set SPRING_APPLICATION_JSON for the app");
                }
                try {
                    envVarsMap.put("SPRING_APPLICATION_JSON", new ObjectMapper().writeValueAsString((Object)request.getDefinition().getProperties()));
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException("Unable to create SPRING_APPLICATION_JSON", e);
                }
            }
            case shell: {
                for (String key : request.getDefinition().getProperties().keySet()) {
                    String envVar;
                    envVar = key.replace('.', '_').toUpperCase();
                    envVarsMap.put(envVar, (String)request.getDefinition().getProperties().get(key));
                }
                break;
            }
        }
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        for (Map.Entry e : envVarsMap.entrySet()) {
            envVars.add(new EnvVar((String)e.getKey(), (String)e.getValue(), null));
        }
        envVars.add(new EnvVar("SPRING_CLOUD_APPLICATION_GUID", "${HOSTNAME}", null));
        if (request.getDeploymentProperties().get("spring.cloud.deployer.group") != null) {
            envVars.add(new EnvVar("SPRING_CLOUD_APPLICATION_GROUP", (String)request.getDeploymentProperties().get("spring.cloud.deployer.group"), null));
        }
        ContainerBuilder container = new ContainerBuilder();
        ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)container.withName(appId)).withImage(image)).withEnv(envVars)).withArgs(appArgs)).withVolumeMounts(this.getVolumeMounts(request));
        if (port != null) {
            if (hostNetwork) {
                ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.addNewPort().withContainerPort(port)).withHostPort(port)).endPort();
            } else {
                ((ContainerFluent.PortsNested)container.addNewPort().withContainerPort(port)).endPort();
            }
            ((ContainerBuilder)container.withReadinessProbe(new ProbeCreator(port, this.properties.getReadinessProbePath(), this.properties.getReadinessProbeTimeout(), this.properties.getReadinessProbeDelay(), this.properties.getReadinessProbePeriod(), "readiness", request.getDeploymentProperties()).create())).withLivenessProbe(new ProbeCreator(port, this.properties.getLivenessProbePath(), this.properties.getLivenessProbeTimeout(), this.properties.getLivenessProbeDelay(), this.properties.getLivenessProbePeriod(), "liveness", request.getDeploymentProperties()).create());
        }
        if (!(additionalPorts = this.getContainerPorts(request)).isEmpty()) {
            for (Integer containerPort : additionalPorts) {
                if (hostNetwork) {
                    ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.addNewPort().withContainerPort(containerPort)).withHostPort(containerPort)).endPort();
                    continue;
                }
                ((ContainerFluent.PortsNested)container.addNewPort().withContainerPort(containerPort)).endPort();
            }
        }
        if (!(containerCommand = this.getContainerCommand(request)).isEmpty()) {
            container.withCommand(containerCommand);
        }
        return container.build();
    }

    protected List<String> createCommandArgs(AppDeploymentRequest request) {
        LinkedList<String> cmdArgs = new LinkedList<String>();
        Map args = request.getDefinition().getProperties();
        for (Map.Entry entry : args.entrySet()) {
            cmdArgs.add(String.format("--%s=%s", entry.getKey(), entry.getValue()));
        }
        cmdArgs.addAll(request.getCommandlineArguments());
        logger.debug((Object)("Using command args: " + cmdArgs));
        return cmdArgs;
    }

    protected List<VolumeMount> getVolumeMounts(AppDeploymentRequest request) {
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        String volumeMountDeploymentProperty = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.volumeMounts", "");
        if (!StringUtils.isEmpty((Object)volumeMountDeploymentProperty)) {
            YamlConfigurationFactory volumeMountYamlConfigurationFactory = new YamlConfigurationFactory(KubernetesDeployerProperties.class);
            volumeMountYamlConfigurationFactory.setYaml("{ volumeMounts: " + volumeMountDeploymentProperty + " }");
            try {
                volumeMountYamlConfigurationFactory.afterPropertiesSet();
                volumeMounts.addAll(((KubernetesDeployerProperties)volumeMountYamlConfigurationFactory.getObject()).getVolumeMounts());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid volume mount '%s'", volumeMountDeploymentProperty), e);
            }
        }
        volumeMounts.addAll(this.properties.getVolumeMounts().stream().filter(volumeMount -> volumeMounts.stream().noneMatch(existingVolumeMount -> existingVolumeMount.getName().equals(volumeMount.getName()))).collect(Collectors.toList()));
        return volumeMounts;
    }

    private List<String> getContainerCommand(AppDeploymentRequest request) {
        String containerCommand = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.containerCommand", "");
        return new CommandLineTokenizer(containerCommand).getArgs();
    }

    private List<Integer> getContainerPorts(AppDeploymentRequest request) {
        ArrayList<Integer> containerPortList = new ArrayList<Integer>();
        String containerPorts = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.containerPorts");
        if (containerPorts != null) {
            String[] containerPortSplit;
            for (String containerPort : containerPortSplit = containerPorts.split(",")) {
                logger.trace((Object)("Adding container ports from AppDeploymentRequest: " + containerPort));
                Integer port = Integer.parseInt(containerPort.trim());
                containerPortList.add(port);
            }
        }
        return containerPortList;
    }

    private Map<String, String> getAppEnvironmentVariables(AppDeploymentRequest request) {
        HashMap<String, String> appEnvVarMap = new HashMap<String, String>();
        String appEnvVar = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.environmentVariables");
        if (appEnvVar != null) {
            String[] appEnvVars;
            for (String envVar : appEnvVars = this.nestedCommaDelimitedVariableParser.parse(appEnvVar)) {
                logger.trace((Object)("Adding environment variable from AppDeploymentRequest: " + envVar));
                String[] strings = envVar.split("=", 2);
                Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
                appEnvVarMap.put(strings[0], strings[1]);
            }
        }
        return appEnvVarMap;
    }

    private EntryPointStyle determineEntryPointStyle(KubernetesDeployerProperties properties, AppDeploymentRequest request) {
        EntryPointStyle entryPointStyle = null;
        String deployProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.entryPointStyle");
        if (deployProperty != null) {
            try {
                entryPointStyle = EntryPointStyle.valueOf(deployProperty.toLowerCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (entryPointStyle == null) {
            entryPointStyle = properties.getEntryPointStyle();
        }
        return entryPointStyle;
    }

    private static class ProbeCreator {
        static final String KUBERNETES_DEPLOYER_PREFIX = "spring.cloud.deployer.kubernetes";
        Integer externalPort;
        String endpoint;
        int timeout;
        int initialDelay;
        int period;

        ProbeCreator(Integer externalPort, String endpoint, int timeout, int initialDelay, int period, String prefix, Map<String, String> deployProperties) {
            this.externalPort = externalPort;
            this.endpoint = deployProperties.containsKey("spring.cloud.deployer.kubernetes." + prefix + "ProbePath") ? String.valueOf(deployProperties.get("spring.cloud.deployer.kubernetes." + prefix + "ProbePath").trim()) : endpoint;
            this.timeout = deployProperties.containsKey("spring.cloud.deployer.kubernetes." + prefix + "ProbeTimeout") ? Integer.valueOf(deployProperties.get("spring.cloud.deployer.kubernetes." + prefix + "ProbeTimeout").trim()) : timeout;
            this.initialDelay = deployProperties.containsKey("spring.cloud.deployer.kubernetes." + prefix + "ProbeDelay") ? Integer.valueOf(deployProperties.get("spring.cloud.deployer.kubernetes." + prefix + "ProbeDelay").trim()) : initialDelay;
            this.period = deployProperties.containsKey("spring.cloud.deployer.kubernetes." + prefix + "ProbePeriod") ? Integer.valueOf(deployProperties.get("spring.cloud.deployer.kubernetes." + prefix + "ProbePeriod").trim()) : period;
        }

        Probe create() {
            return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withHttpGet(((HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath(this.endpoint)).withNewPort(this.externalPort)).build())).withTimeoutSeconds(Integer.valueOf(this.timeout))).withInitialDelaySeconds(Integer.valueOf(this.initialDelay))).withPeriodSeconds(Integer.valueOf(this.period))).build();
        }
    }

    static class NestedCommaDelimitedVariableParser {
        static final String REGEX = "(\\w+='.+?'),?";
        static final Pattern pattern = Pattern.compile("(\\w+='.+?'),?");

        NestedCommaDelimitedVariableParser() {
        }

        String[] parse(String value) {
            String[] vars = value.replaceAll(pattern.pattern(), "").split(",");
            Matcher m = pattern.matcher(value);
            while (m.find()) {
                vars = Arrays.copyOf(vars, vars.length + 1);
                vars[vars.length - 1] = m.group(1).replaceAll("'", "");
            }
            return vars;
        }
    }
}

