/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.bind.YamlConfigurationFactory;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesAppInstanceStatus;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.util.StringUtils;

public class AbstractKubernetesDeployer {
    protected static final String SPRING_DEPLOYMENT_KEY = "spring-deployment-id";
    protected static final String SPRING_GROUP_KEY = "spring-group-id";
    protected static final String SPRING_APP_KEY = "spring-app-id";
    protected static final String SPRING_MARKER_KEY = "role";
    protected static final String SPRING_MARKER_VALUE = "spring-app";
    protected static final Log logger = LogFactory.getLog(AbstractKubernetesDeployer.class);
    protected ContainerFactory containerFactory;
    protected KubernetesDeployerProperties properties = new KubernetesDeployerProperties();

    protected Map<String, String> createIdMap(String appId, AppDeploymentRequest request, Integer instanceIndex) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SPRING_APP_KEY, appId);
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        if (groupId != null) {
            map.put(SPRING_GROUP_KEY, groupId);
        }
        String appInstanceId = instanceIndex == null ? appId : appId + "-" + instanceIndex;
        map.put(SPRING_DEPLOYMENT_KEY, appInstanceId);
        return map;
    }

    protected AppStatus buildAppStatus(String id, PodList list) {
        AppStatus.Builder statusBuilder = AppStatus.of((String)id);
        if (list != null && list.getItems() != null) {
            for (Pod pod : list.getItems()) {
                statusBuilder.with((AppInstanceStatus)new KubernetesAppInstanceStatus(id, pod, this.properties));
            }
        }
        return statusBuilder.build();
    }

    protected PodSpec createPodSpec(String appId, AppDeploymentRequest request, Integer port, Integer instanceIndex, boolean neverRestart) {
        PodSpecBuilder podSpec = new PodSpecBuilder();
        if (this.properties.getImagePullSecret() != null) {
            podSpec.addNewImagePullSecret(this.properties.getImagePullSecret());
        }
        Container container = this.containerFactory.create(appId, request, port, instanceIndex);
        ResourceRequirements req = new ResourceRequirements();
        req.setLimits(this.deduceResourceLimits(request));
        req.setRequests(this.deduceResourceRequests(request));
        container.setResources(req);
        ImagePullPolicy pullPolicy = this.deduceImagePullPolicy(request);
        container.setImagePullPolicy(pullPolicy.name());
        podSpec.withVolumes(this.getVolumes(request).stream().filter(volume -> container.getVolumeMounts().stream().anyMatch(volumeMount -> volumeMount.getName().equals(volume.getName()))).collect(Collectors.toList()));
        podSpec.addToContainers(new Container[]{container});
        if (neverRestart) {
            podSpec.withRestartPolicy("Never");
        }
        return podSpec.build();
    }

    protected List<Volume> getVolumes(AppDeploymentRequest request) {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        String volumeDeploymentProperty = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.volumes", "");
        if (!StringUtils.isEmpty((Object)volumeDeploymentProperty)) {
            YamlConfigurationFactory volumeYamlConfigurationFactory = new YamlConfigurationFactory(KubernetesDeployerProperties.class);
            volumeYamlConfigurationFactory.setYaml("{ volumes: " + volumeDeploymentProperty + " }");
            try {
                volumeYamlConfigurationFactory.afterPropertiesSet();
                volumes.addAll(((KubernetesDeployerProperties)volumeYamlConfigurationFactory.getObject()).getVolumes());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid volume '%s'", volumeDeploymentProperty), e);
            }
        }
        volumes.addAll(this.properties.getVolumes().stream().filter(volume -> volumes.stream().noneMatch(existingVolume -> existingVolume.getName().equals(volume.getName()))).collect(Collectors.toList()));
        return volumes;
    }

    protected Map<String, Quantity> deduceResourceLimits(AppDeploymentRequest request) {
        String cpuLimitsOverride;
        String memLimitsOverride;
        String memDeployer = this.getCommonDeployerMemory(request);
        String memOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.memory");
        if (memDeployer != null) {
            if (memOverride == null) {
                memOverride = memDeployer;
            } else {
                logger.warn((Object)String.format("Both spring.cloud.deployer.memory=%s and spring.cloud.deployer.kubernetes.memory=%s specified, the latter will take precedence.", memDeployer, memOverride));
            }
        }
        if ((memLimitsOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.limits.memory")) != null) {
            memOverride = memLimitsOverride;
        }
        if (memOverride == null) {
            memOverride = this.properties.getLimits().getMemory() != null ? this.properties.getLimits().getMemory() : this.properties.getMemory();
        }
        String cpuDeployer = (String)request.getDeploymentProperties().get("spring.cloud.deployer.cpu");
        String cpuOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.cpu");
        if (cpuDeployer != null) {
            if (cpuOverride == null) {
                cpuOverride = cpuDeployer;
            } else {
                logger.warn((Object)String.format("Both spring.cloud.deployer.cpu=%s and spring.cloud.deployer.kubernetes.cpu=%s specified, the latter will take precedence.", cpuDeployer, cpuOverride));
            }
        }
        if ((cpuLimitsOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.limits.cpu")) != null) {
            cpuOverride = cpuLimitsOverride;
        }
        if (cpuOverride == null) {
            cpuOverride = this.properties.getLimits().getCpu() != null ? this.properties.getLimits().getCpu() : this.properties.getCpu();
        }
        logger.debug((Object)("Using limits - cpu: " + cpuOverride + " mem: " + memOverride));
        HashMap<String, Quantity> limits = new HashMap<String, Quantity>();
        limits.put("memory", new Quantity(memOverride));
        limits.put("cpu", new Quantity(cpuOverride));
        return limits;
    }

    protected ImagePullPolicy deduceImagePullPolicy(AppDeploymentRequest request) {
        ImagePullPolicy pullPolicy;
        String pullPolicyOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.imagePullPolicy");
        if (pullPolicyOverride == null) {
            pullPolicy = this.properties.getImagePullPolicy();
        } else {
            pullPolicy = ImagePullPolicy.relaxedValueOf(pullPolicyOverride);
            if (pullPolicy == null) {
                logger.warn((Object)("Parsing of pull policy " + pullPolicyOverride + " failed, using default \"Always\"."));
                pullPolicy = ImagePullPolicy.Always;
            }
        }
        logger.debug((Object)("Using imagePullPolicy " + (Object)((Object)pullPolicy)));
        return pullPolicy;
    }

    protected Map<String, Quantity> deduceResourceRequests(AppDeploymentRequest request) {
        String cpuOverride;
        String memOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.requests.memory");
        if (memOverride == null) {
            memOverride = this.properties.getRequests().getMemory();
        }
        if ((cpuOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.requests.cpu")) == null) {
            cpuOverride = this.properties.getRequests().getCpu();
        }
        logger.debug((Object)("Using requests - cpu: " + cpuOverride + " mem: " + memOverride));
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>();
        if (memOverride != null) {
            requests.put("memory", new Quantity(memOverride));
        }
        if (cpuOverride != null) {
            requests.put("cpu", new Quantity(cpuOverride));
        }
        return requests;
    }

    private String getCommonDeployerMemory(AppDeploymentRequest request) {
        String mem = (String)request.getDeploymentProperties().get("spring.cloud.deployer.memory");
        if (mem == null) {
            return null;
        }
        long memAmount = ByteSizeUtils.parseToMebibytes((String)mem);
        return memAmount + "Mi";
    }
}

