/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;

public class KubernetesAppInstanceStatus
implements AppInstanceStatus {
    private static Log logger = LogFactory.getLog(KubernetesAppInstanceStatus.class);
    private final Pod pod;
    private final String moduleId;
    private KubernetesDeployerProperties properties;
    private ContainerStatus containerStatus;

    public KubernetesAppInstanceStatus(String moduleId, Pod pod, KubernetesDeployerProperties properties) {
        this.moduleId = moduleId;
        this.pod = pod;
        this.properties = properties;
        this.containerStatus = pod != null && pod.getStatus().getContainerStatuses().size() == 1 ? (ContainerStatus)pod.getStatus().getContainerStatuses().get(0) : null;
    }

    public String getId() {
        return String.format("%s:%s", this.moduleId, this.pod.getMetadata().getName());
    }

    public DeploymentState getState() {
        return this.pod != null && this.containerStatus != null ? this.mapState() : DeploymentState.unknown;
    }

    private DeploymentState mapState() {
        logger.debug((Object)String.format("%s - Phase [ %s ]", this.pod.getMetadata().getName(), this.pod.getStatus().getPhase()));
        logger.debug((Object)String.format("%s - ContainerStatus [ %s ]", this.pod.getMetadata().getName(), this.containerStatus));
        switch (this.pod.getStatus().getPhase()) {
            case "Pending": {
                return DeploymentState.deploying;
            }
            case "Running": {
                if (this.containerStatus.getReady().booleanValue()) {
                    return DeploymentState.deployed;
                }
                if (this.containerStatus.getRestartCount() > this.properties.getMaxTerminatedErrorRestarts() && this.containerStatus.getLastState() != null && this.containerStatus.getLastState().getTerminated() != null && (this.containerStatus.getLastState().getTerminated().getExitCode() == 137 || this.containerStatus.getLastState().getTerminated().getExitCode() == 143)) {
                    return DeploymentState.failed;
                }
                if (this.containerStatus.getRestartCount() > this.properties.getMaxTerminatedErrorRestarts() && this.containerStatus.getLastState() != null && this.containerStatus.getState() != null && this.containerStatus.getLastState().getTerminated() != null && this.containerStatus.getState().getTerminated() != null && this.containerStatus.getLastState().getTerminated().getReason().contains("Error") && this.containerStatus.getState().getTerminated().getReason().contains("Error") && this.containerStatus.getLastState().getTerminated().getExitCode().equals(this.containerStatus.getState().getTerminated().getExitCode())) {
                    return DeploymentState.failed;
                }
                if (this.containerStatus.getRestartCount() > this.properties.getMaxCrashLoopBackOffRestarts() && this.containerStatus.getLastState() != null && this.containerStatus.getState() != null && this.containerStatus.getLastState().getTerminated() != null && this.containerStatus.getState().getWaiting() != null && this.containerStatus.getState().getWaiting().getReason() != null && this.containerStatus.getState().getWaiting().getReason().contains("CrashLoopBackOff")) {
                    return DeploymentState.failed;
                }
                if (this.containerStatus.getRestartCount() == 0 && this.containerStatus.getState() != null && this.containerStatus.getState().getTerminated() != null) {
                    return DeploymentState.undeployed;
                }
                return DeploymentState.deploying;
            }
            case "Failed": {
                return DeploymentState.failed;
            }
            case "Unknown": {
                return DeploymentState.unknown;
            }
        }
        return DeploymentState.unknown;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.pod != null) {
            result.put("pod_starttime", this.pod.getStatus().getStartTime());
            result.put("pod_ip", this.pod.getStatus().getPodIP());
            result.put("host_ip", this.pod.getStatus().getHostIP());
            result.put("phase", this.pod.getStatus().getPhase());
        }
        if (this.containerStatus != null) {
            result.put("container_restart_count", "" + this.containerStatus.getRestartCount());
            if (this.containerStatus.getLastState() != null && this.containerStatus.getLastState().getTerminated() != null) {
                result.put("container_last_termination_exit_code", "" + this.containerStatus.getLastState().getTerminated().getExitCode());
                result.put("container_last_termination_reason", this.containerStatus.getLastState().getTerminated().getReason());
            }
            if (this.containerStatus.getState() != null && this.containerStatus.getState().getTerminated() != null) {
                result.put("container_termination_exit_code", "" + this.containerStatus.getState().getTerminated().getExitCode());
                result.put("container_termination_reason", this.containerStatus.getState().getTerminated().getReason());
            }
        }
        return result;
    }
}

