/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

class CfEnvConfigurer {
    private static final Log log = LogFactory.getLog(CfEnvConfigurer.class);
    static final String SPRING_PROFILES_ACTIVE = "SPRING_PROFILES_ACTIVE";
    static final String SPRING_PROFILES_ACTIVE_FQN = "spring.profiles.active";
    static final String SPRING_PROFILES_ACTIVE_HYPHENATED = "spring-profiles-active";
    static final String CLOUD_PROFILE_NAME = "cloud";
    static final String JBP_CONFIG_SPRING_AUTO_RECONFIGURATION = "JBP_CONFIG_SPRING_AUTO_RECONFIGURATION";
    static final String ENABLED_FALSE = "{ enabled: false }";

    CfEnvConfigurer() {
    }

    static Map<String, String> disableJavaBuildPackAutoReconfiguration(Map<String, String> environment) {
        log.debug((Object)"Disabling 'JBP_CONFIG_SPRING_AUTO_RECONFIGURATION'");
        HashMap<String, String> updatedEnvironment = new HashMap<String, String>(environment);
        updatedEnvironment.putIfAbsent(JBP_CONFIG_SPRING_AUTO_RECONFIGURATION, ENABLED_FALSE);
        return updatedEnvironment;
    }

    static Map<String, String> activateCloudProfile(Map<String, String> environment, String keyToCreate) {
        log.debug((Object)"Activating cloud profile");
        HashMap<String, String> updatedEnvironment = new HashMap<String, String>(environment);
        if (CfEnvConfigurer.appendToExistingEntry(updatedEnvironment, SPRING_PROFILES_ACTIVE, CLOUD_PROFILE_NAME)) {
            return updatedEnvironment;
        }
        if (CfEnvConfigurer.appendToExistingEntry(updatedEnvironment, SPRING_PROFILES_ACTIVE_FQN, CLOUD_PROFILE_NAME)) {
            return updatedEnvironment;
        }
        if (CfEnvConfigurer.appendToExistingEntry(updatedEnvironment, SPRING_PROFILES_ACTIVE_HYPHENATED, CLOUD_PROFILE_NAME)) {
            return updatedEnvironment;
        }
        if (StringUtils.hasText((String)keyToCreate)) {
            updatedEnvironment.put(keyToCreate, CLOUD_PROFILE_NAME);
        }
        return updatedEnvironment;
    }

    static String appendCloudProfileToSpringProfilesActiveArg(String arg) {
        if ((arg.contains(SPRING_PROFILES_ACTIVE_FQN) || arg.contains(SPRING_PROFILES_ACTIVE_HYPHENATED) || arg.contains(SPRING_PROFILES_ACTIVE)) && arg.contains("=")) {
            String[] tokens = arg.split("=");
            arg = String.join((CharSequence)"=", tokens[0], CfEnvConfigurer.appendToValueIfPresent(tokens[1], CLOUD_PROFILE_NAME));
        }
        return arg;
    }

    private static boolean appendToExistingEntry(Map<String, String> environment, String key, String value) {
        if (environment.containsKey(key)) {
            String current = environment.get(key);
            environment.put(key, CfEnvConfigurer.appendToValueIfPresent(current, value));
            return true;
        }
        return false;
    }

    private static String appendToValueIfPresent(String current, String value) {
        if (StringUtils.hasText((String)current)) {
            if (!Stream.of(current.split(",")).filter(s -> s.trim().equals(value)).findFirst().isPresent()) {
                return String.join((CharSequence)",", current, value);
            }
            return current;
        }
        return value;
    }
}

