/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.time.Duration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.applications.SummaryApplicationRequest;
import org.cloudfoundry.client.v2.applications.SummaryApplicationResponse;
import org.cloudfoundry.client.v3.tasks.CreateTaskRequest;
import org.cloudfoundry.client.v3.tasks.CreateTaskResponse;
import org.cloudfoundry.doppler.LogMessage;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.AbstractApplicationSummary;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.ApplicationSummary;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.Docker;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.LogsRequest;
import org.cloudfoundry.operations.applications.PushApplicationManifestRequest;
import org.cloudfoundry.operations.applications.StopApplicationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.cloudfoundry.AbstractCloudFoundryTaskLauncher;
import org.springframework.cloud.deployer.spi.cloudfoundry.CfEnvAwareAppDeploymentRequest;
import org.springframework.cloud.deployer.spi.cloudfoundry.CfEnvConfigurer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CloudFoundryTaskLauncher
extends AbstractCloudFoundryTaskLauncher {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryTaskLauncher.class);
    private final CloudFoundryClient client;
    private final CloudFoundryDeploymentProperties deploymentProperties;
    private final CloudFoundryOperations operations;

    public CloudFoundryTaskLauncher(CloudFoundryClient client, CloudFoundryDeploymentProperties deploymentProperties, CloudFoundryOperations operations, RuntimeEnvironmentInfo runtimeEnvironmentInfo) {
        super(client, deploymentProperties, runtimeEnvironmentInfo);
        this.client = client;
        this.deploymentProperties = deploymentProperties;
        this.operations = operations;
    }

    public String launch(AppDeploymentRequest appDeploymentRequest) {
        CfEnvAwareAppDeploymentRequest request = CfEnvAwareAppDeploymentRequest.of(appDeploymentRequest);
        if (this.maxConcurrentExecutionsReached()) {
            throw new IllegalStateException(String.format("Cannot launch task %s. The maximum concurrent task executions is at its limit [%d].", request.getDefinition().getName(), this.getMaximumConcurrentTasks()));
        }
        return (String)this.getOrDeployApplication(request).flatMap(application -> this.launchTask((SummaryApplicationResponse)application, request)).doOnSuccess(r -> logger.info("Task {} launch successful", (Object)request.getDefinition().getName())).doOnError(this.logError(String.format("Task %s launch failed", request.getDefinition().getName()))).doOnTerminate(() -> {
            if (this.pushTaskAppsEnabled()) {
                this.deleteLocalApplicationResourceFile(request);
            }
        }).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
    }

    @Override
    public void destroy(String appName) {
        if (!this.pushTaskAppsEnabled()) {
            logger.warn("The application {} will not be deleted since 'pushTaskApps' is not enabled.", (Object)appName);
            return;
        }
        this.requestDeleteApplication(appName).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).doOnSuccess(v -> logger.info("Successfully destroyed app {}", (Object)appName)).doOnError(this.logError(String.format("Failed to destroy app %s", appName))).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
    }

    public String getLog(String taskAppName) {
        List logMessageList = (List)this.getLogMessage(taskAppName).collectList().block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
        StringBuilder stringBuilder = new StringBuilder();
        for (LogMessage logMessage : logMessageList) {
            stringBuilder.append(logMessage.getMessage() + System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    private Flux<LogMessage> getLogMessage(String taskAppName) {
        logger.info("Fetching log for {}", (Object)taskAppName);
        return this.operations.applications().logs(LogsRequest.builder().name(taskAppName).recent(Boolean.valueOf(true)).build());
    }

    public SummaryApplicationResponse stage(AppDeploymentRequest request) {
        return (SummaryApplicationResponse)this.getOrDeployApplication(request).doOnSuccess(r -> logger.info("Task {} staged successfully", (Object)request.getDefinition().getName())).doOnError(this.logError(String.format("Task %s stage failed", request.getDefinition().getName()))).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
    }

    public String getCommand(SummaryApplicationResponse application, AppDeploymentRequest request) {
        boolean appHasCfEnv = this.hasCfEnv(request.getResource());
        return Stream.concat(Stream.of(application.getDetectedStartCommand()), request.getCommandlineArguments().stream()).map(arg -> {
            int indexOfEquals = arg.indexOf("=");
            if (indexOfEquals > -1) {
                String key = arg.substring(0, indexOfEquals);
                String value = arg.substring(indexOfEquals);
                key = this.escapeChar(key, "(");
                key = this.escapeChar(key, ")");
                arg = key + value;
            }
            return appHasCfEnv ? CfEnvConfigurer.appendCloudProfileToSpringProfilesActiveArg(arg) : arg;
        }).collect(Collectors.joining(" "));
    }

    private String escapeChar(String value, String character) {
        if (value.contains(character)) {
            value = value.replace(character, "\\\\\\" + character);
        }
        return value;
    }

    private boolean pushTaskAppsEnabled() {
        return this.deploymentProperties.isPushTaskAppsEnabled();
    }

    private Mono<AbstractApplicationSummary> deployApplication(AppDeploymentRequest request) {
        String name = request.getDefinition().getName();
        return this.pushApplication(name, request).then(this.requestStopApplication(name)).then(this.requestGetApplication(name)).cast(AbstractApplicationSummary.class);
    }

    private Mono<AbstractApplicationSummary> getOptionalApplication(AppDeploymentRequest request) {
        String name = request.getDefinition().getName();
        Flux applications = this.requestListApplications().filter(application -> name.equals(application.getName()));
        if (!this.pushTaskAppsEnabled()) {
            return applications.single().onErrorMap(t -> t instanceof NoSuchElementException ? new IllegalStateException(String.format("Application %s does not exist", name)) : t).cast(AbstractApplicationSummary.class);
        }
        return applications.singleOrEmpty().cast(AbstractApplicationSummary.class);
    }

    private Mono<SummaryApplicationResponse> getOrDeployApplication(AppDeploymentRequest request) {
        return this.getOptionalApplication(request).switchIfEmpty(this.deployApplication(request)).flatMap(application -> this.requestGetApplicationSummary(application.getId()));
    }

    private Mono<String> launchTask(SummaryApplicationResponse application, AppDeploymentRequest request) {
        return this.requestCreateTask(application.getId(), this.getCommand(application, request), this.memory(request), request.getDefinition().getName()).map(CreateTaskResponse::getId);
    }

    private Mono<Void> pushApplication(String name, AppDeploymentRequest request) {
        if (!this.pushTaskAppsEnabled()) {
            return Mono.empty();
        }
        return this.requestPushApplication(PushApplicationManifestRequest.builder().manifest(ApplicationManifest.builder().path(this.getApplication(request)).docker(Docker.builder().image(this.getDockerImage(request)).build()).buildpacks(this.buildpacks(request)).command("echo '*** First run of container to allow droplet creation.***' && sleep 300").disk(Integer.valueOf(this.diskQuota(request))).environmentVariables(this.mergeEnvironmentVariables(name, request)).healthCheckType(ApplicationHealthCheck.NONE).memory(Integer.valueOf(this.memory(request))).name(name).noRoute(Boolean.valueOf(true)).services(this.servicesToBind(request)).build()).stagingTimeout(this.deploymentProperties.getStagingTimeout()).startupTimeout(this.deploymentProperties.getStartupTimeout()).build());
    }

    private Mono<CreateTaskResponse> requestCreateTask(String applicationId, String command, int memory, String name) {
        return this.client.tasks().create(CreateTaskRequest.builder().applicationId(applicationId).command(command).memoryInMb(Integer.valueOf(memory)).name(name).build());
    }

    private Mono<Void> requestDeleteApplication(String name) {
        return this.operations.applications().delete(DeleteApplicationRequest.builder().deleteRoutes(Boolean.valueOf(this.deploymentProperties.isDeleteRoutes())).name(name).build());
    }

    private Mono<ApplicationDetail> requestGetApplication(String name) {
        return this.operations.applications().get(GetApplicationRequest.builder().name(name).build());
    }

    private Mono<SummaryApplicationResponse> requestGetApplicationSummary(String applicationId) {
        return this.client.applicationsV2().summary(SummaryApplicationRequest.builder().applicationId(applicationId).build());
    }

    private Flux<ApplicationSummary> requestListApplications() {
        return this.operations.applications().list();
    }

    private Mono<Void> requestPushApplication(PushApplicationManifestRequest request) {
        return this.operations.applications().pushManifest(request);
    }

    private Mono<Void> requestStopApplication(String name) {
        return this.operations.applications().stop(StopApplicationRequest.builder().name(name).build());
    }
}

