/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.util.Assert;

public class CloudFoundryPlatformSpecificInfo {
    static final String API_ENDPOINT = "API Endpoint";
    static final String ORG = "Organization";
    static final String SPACE = "Space";
    private final RuntimeEnvironmentInfo.Builder runtimeEnvironmentInfo;
    private String apiEndpoint;
    private String org;
    private String space;

    public CloudFoundryPlatformSpecificInfo(RuntimeEnvironmentInfo.Builder runtimeEnvironmentInfo) {
        this.runtimeEnvironmentInfo = runtimeEnvironmentInfo;
    }

    public CloudFoundryPlatformSpecificInfo apiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
        return this;
    }

    public CloudFoundryPlatformSpecificInfo org(String org) {
        this.org = org;
        return this;
    }

    public CloudFoundryPlatformSpecificInfo space(String space) {
        this.space = space;
        return this;
    }

    public RuntimeEnvironmentInfo.Builder builder() {
        Assert.hasText((String)this.apiEndpoint, (String)"'apiEndpoint' must contain text");
        Assert.hasText((String)this.org, (String)"'org' must contain text");
        Assert.hasText((String)this.space, (String)"'space' must contain text");
        this.runtimeEnvironmentInfo.addPlatformSpecificInfo(API_ENDPOINT, this.apiEndpoint);
        this.runtimeEnvironmentInfo.addPlatformSpecificInfo(ORG, this.org);
        this.runtimeEnvironmentInfo.addPlatformSpecificInfo(SPACE, this.space);
        return this.runtimeEnvironmentInfo;
    }
}

