/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.cloudfoundry.doppler.LogMessage;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.ApplicationSummary;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.Docker;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.cloudfoundry.operations.applications.LogsRequest;
import org.cloudfoundry.operations.applications.PushApplicationManifestRequest;
import org.cloudfoundry.operations.applications.Route;
import org.cloudfoundry.operations.applications.ScaleApplicationRequest;
import org.cloudfoundry.operations.applications.StartApplicationRequest;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppScaleRequest;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.app.MultiStateAppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.AbstractCloudFoundryDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.AppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppInstanceStatus;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import reactor.cache.CacheMono;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;

public class CloudFoundryAppDeployer
extends AbstractCloudFoundryDeployer
implements MultiStateAppDeployer {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryAppDeployer.class);
    private final AppNameGenerator applicationNameGenerator;
    private final CloudFoundryOperations operations;
    private final Cache<String, ApplicationDetail> cache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();

    public CloudFoundryAppDeployer(AppNameGenerator applicationNameGenerator, CloudFoundryDeploymentProperties deploymentProperties, CloudFoundryOperations operations, RuntimeEnvironmentInfo runtimeEnvironmentInfo) {
        super(deploymentProperties, runtimeEnvironmentInfo);
        this.operations = operations;
        this.applicationNameGenerator = applicationNameGenerator;
    }

    public String deploy(AppDeploymentRequest request) {
        logger.trace("Entered deploy: Deploying AppDeploymentRequest: AppDefinition = {}, Resource = {}, Deployment Properties = {}", new Object[]{request.getDefinition(), request.getResource(), request.getDeploymentProperties()});
        String deploymentId = this.deploymentId(request);
        logger.trace("deploy: Getting Status for Deployment Id = {}", (Object)deploymentId);
        this.getStatus(deploymentId).doOnNext(status -> this.assertApplicationDoesNotExist(deploymentId, (AppStatus)status)).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
        logger.trace("deploy: Pushing application");
        this.pushApplication(deploymentId, request).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).doOnSuccess(item -> logger.info("Successfully deployed {}", (Object)deploymentId)).doOnError(error -> {
            if (this.isNotFoundError().test((Throwable)error)) {
                logger.warn("Unable to deploy application. It may have been destroyed before start completed: " + error.getMessage());
            } else {
                this.logError(String.format("Failed to deploy %s", deploymentId)).accept((Throwable)error);
            }
        }).doOnSuccessOrError((r, e) -> this.deleteLocalApplicationResourceFile(request)).subscribe();
        logger.trace("Exiting deploy().  Deployment Id = {}", (Object)deploymentId);
        return deploymentId;
    }

    public Map<String, DeploymentState> states(String ... ids) {
        return (Map)this.requestSummary().collect(Collectors.toMap(ApplicationSummary::getName, this::mapShallowAppState)).block();
    }

    public Mono<Map<String, DeploymentState>> statesReactive(String ... ids) {
        return this.requestSummary().collect(Collectors.toMap(ApplicationSummary::getName, this::mapShallowAppState));
    }

    private DeploymentState mapShallowAppState(ApplicationSummary applicationSummary) {
        if (applicationSummary.getRunningInstances().equals(applicationSummary.getInstances())) {
            return DeploymentState.deployed;
        }
        if (applicationSummary.getInstances() > 0) {
            return DeploymentState.partial;
        }
        return DeploymentState.undeployed;
    }

    @Override
    protected Map<String, String> getEnvironmentVariables(String deploymentId, AppDeploymentRequest request) {
        Map<String, String> envVariables = super.getEnvironmentVariables(deploymentId, request);
        envVariables.putAll(this.getCommandLineArguments(request));
        String group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        if (StringUtils.hasText((String)group)) {
            envVariables.put("SPRING_CLOUD_APPLICATION_GROUP", group);
        }
        envVariables.put("SPRING_CLOUD_APPLICATION_GUID", "${vcap.application.name}:${vcap.application.instance_index}");
        envVariables.put("SPRING_APPLICATION_INDEX", "${vcap.application.instance_index}");
        return envVariables;
    }

    private Map<String, String> getCommandLineArguments(AppDeploymentRequest request) {
        if (request.getCommandlineArguments().isEmpty()) {
            return Collections.emptyMap();
        }
        String argumentsAsString = request.getCommandlineArguments().stream().collect(Collectors.joining(" "));
        String yaml = new Yaml().dump(Collections.singletonMap("arguments", argumentsAsString));
        return Collections.singletonMap("JBP_CONFIG_JAVA_MAIN", yaml);
    }

    public AppStatus status(String id) {
        try {
            return (AppStatus)this.getStatus(id).doOnSuccess(v -> logger.info("Successfully computed status [{}] for {}", v, (Object)id)).doOnError(this.logError(String.format("Failed to compute status for %s", id))).block(Duration.ofMillis(this.deploymentProperties.getStatusTimeout()));
        }
        catch (Exception timeoutDueToBlock) {
            logger.error("Caught exception while querying for status of {}", (Object)id, (Object)timeoutDueToBlock);
            return this.createErrorAppStatus(id);
        }
    }

    public Mono<AppStatus> statusReactive(String id) {
        return this.getStatus(id);
    }

    public void undeploy(String id) {
        this.getStatus(id).doOnNext(status -> this.assertApplicationExists(id, (AppStatus)status)).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
        this.requestDeleteApplication(id).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).doOnSuccess(v -> logger.info("Successfully undeployed app {}", (Object)id)).doOnError(this.logError(String.format("Failed to undeploy app %s", id))).subscribe();
    }

    public String getLog(String id) {
        List logMessageList = (List)this.getLogMessage(id).collectList().block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
        StringBuilder stringBuilder = new StringBuilder();
        for (LogMessage logMessage : logMessageList) {
            stringBuilder.append(logMessage.getMessage() + System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    public void scale(AppScaleRequest appScaleRequest) {
        logger.info("Scaling the application instance using ", (Object)appScaleRequest.toString());
        ScaleApplicationRequest scaleApplicationRequest = ScaleApplicationRequest.builder().name(appScaleRequest.getDeploymentId()).instances(Integer.valueOf(appScaleRequest.getCount())).memoryLimit(Integer.valueOf(this.memory(appScaleRequest))).diskLimit(Integer.valueOf(this.diskQuota(appScaleRequest))).stagingTimeout(this.deploymentProperties.getStagingTimeout()).startupTimeout(this.deploymentProperties.getStartupTimeout()).build();
        this.operations.applications().scale(scaleApplicationRequest).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).doOnSuccess(v -> logger.info("Scaled the application with deploymentId = {}", (Object)appScaleRequest.getDeploymentId())).doOnError(e -> logger.error("Error: {} scaling the app instance {}", (Object)e.getMessage(), (Object)appScaleRequest.getDeploymentId())).subscribe();
    }

    private Flux<LogMessage> getLogMessage(String deploymentId) {
        logger.info("Fetching log for " + deploymentId);
        return this.operations.applications().logs(LogsRequest.builder().name(deploymentId).recent(Boolean.valueOf(true)).build());
    }

    private void assertApplicationDoesNotExist(String deploymentId, AppStatus status) {
        DeploymentState state = status.getState();
        if (state != DeploymentState.unknown && state != DeploymentState.error) {
            throw new IllegalStateException(String.format("App %s is already deployed with state %s", deploymentId, state));
        }
    }

    private void assertApplicationExists(String deploymentId, AppStatus status) {
        DeploymentState state = status.getState();
        if (state == DeploymentState.unknown) {
            throw new IllegalStateException(String.format("App %s is not in a deployed state", deploymentId));
        }
    }

    private AppStatus createAppStatus(ApplicationDetail applicationDetail, String deploymentId) {
        logger.trace("Gathering instances for " + applicationDetail);
        logger.trace("InstanceDetails: " + applicationDetail.getInstanceDetails());
        AppStatus.Builder builder = AppStatus.of((String)deploymentId);
        int i = 0;
        for (InstanceDetail instanceDetail : applicationDetail.getInstanceDetails()) {
            builder.with((AppInstanceStatus)new CloudFoundryAppInstanceStatus(applicationDetail, instanceDetail, i++));
        }
        while (i < applicationDetail.getInstances()) {
            builder.with((AppInstanceStatus)new CloudFoundryAppInstanceStatus(applicationDetail, null, i));
            ++i;
        }
        return builder.build();
    }

    private AppStatus createEmptyAppStatus(String deploymentId) {
        return AppStatus.of((String)deploymentId).build();
    }

    private AppStatus createErrorAppStatus(String deploymentId) {
        return AppStatus.of((String)deploymentId).generalState(DeploymentState.error).build();
    }

    private String deploymentId(AppDeploymentRequest request) {
        String prefix = Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.group")).map(group -> String.format("%s-", group)).orElse("");
        String appName = String.format("%s%s", prefix, request.getDefinition().getName());
        return this.applicationNameGenerator.generateAppName(appName);
    }

    private String domain(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.domain")).orElse(this.deploymentProperties.getDomain());
    }

    private Mono<AppStatus> getStatus(String deploymentId) {
        return this.requestGetApplication(deploymentId).map(applicationDetail -> this.createAppStatus((ApplicationDetail)applicationDetail, deploymentId)).onErrorResume(IllegalArgumentException.class, t -> {
            logger.debug("Application for {} does not exist.", (Object)deploymentId);
            return Mono.just((Object)this.createEmptyAppStatus(deploymentId));
        }).transform(this.statusRetry(deploymentId)).onErrorReturn((Object)this.createErrorAppStatus(deploymentId));
    }

    private ApplicationHealthCheck healthCheck(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.health-check")).map(this::toApplicationHealthCheck).orElse(this.deploymentProperties.getHealthCheck());
    }

    private String healthCheckEndpoint(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.health-check-http-endpoint")).orElse(this.deploymentProperties.getHealthCheckHttpEndpoint());
    }

    private Integer healthCheckTimeout(AppDeploymentRequest request) {
        String timeoutString = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.cloudfoundry.health-check-timeout", this.deploymentProperties.getHealthCheckTimeout());
        return Integer.parseInt(timeoutString);
    }

    private String host(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.host")).orElse(this.deploymentProperties.getHost());
    }

    private int instances(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.count")).map(Integer::parseInt).orElse(this.deploymentProperties.getInstances());
    }

    private Mono<Void> pushApplication(String deploymentId, AppDeploymentRequest request) {
        ApplicationManifest.Builder manifest = ApplicationManifest.builder().path(this.getApplication(request)).disk(Integer.valueOf(this.diskQuota(request))).environmentVariables(this.getEnvironmentVariables(deploymentId, request)).healthCheckType(this.healthCheck(request)).healthCheckHttpEndpoint(this.healthCheckEndpoint(request)).timeout(this.healthCheckTimeout(request)).instances(Integer.valueOf(this.instances(request))).memory(Integer.valueOf(this.memory(request))).name(deploymentId).noRoute(this.toggleNoRoute(request)).services(this.servicesToBind(request));
        Optional.ofNullable(this.host(request)).ifPresent(arg_0 -> ((ApplicationManifest.Builder)manifest).host(arg_0));
        Optional.ofNullable(this.domain(request)).ifPresent(arg_0 -> ((ApplicationManifest.Builder)manifest).domain(arg_0));
        Optional.ofNullable(this.routePath(request)).ifPresent(arg_0 -> ((ApplicationManifest.Builder)manifest).routePath(arg_0));
        if (this.route(request) != null) {
            manifest.route(Route.builder().route(this.route(request)).build());
        }
        if (!this.routes(request).isEmpty()) {
            Set routes = this.routes(request).stream().map(r -> Route.builder().route(r).build()).collect(Collectors.toSet());
            manifest.routes(routes);
        }
        if (this.getDockerImage(request) != null) {
            logger.info("Preparing to run a container from  " + request.getResource() + ". This may take some time if the image must be downloaded from a remote container registry.");
            manifest.docker(Docker.builder().image(this.getDockerImage(request)).build());
        } else {
            manifest.buildpack(this.buildpack(request));
        }
        if (!this.includesServiceParameters(request)) {
            return this.pushApplicationWithNoServiceParameters(manifest.build(), deploymentId);
        }
        return this.pushApplicationWithServiceParameters(manifest.build(), request, deploymentId);
    }

    private Mono<Void> pushApplicationWithNoServiceParameters(ApplicationManifest manifest, String deploymentId) {
        logger.debug("Pushing application manifest");
        return this.requestPushApplication(PushApplicationManifestRequest.builder().manifest(manifest).stagingTimeout(this.deploymentProperties.getStagingTimeout()).startupTimeout(this.deploymentProperties.getStartupTimeout()).build()).doOnSuccess(v -> logger.info("Done uploading bits for {}", (Object)deploymentId)).doOnError(e -> logger.error("Error: {} creating app {}", (Object)e.getMessage(), (Object)deploymentId));
    }

    private Mono<Void> pushApplicationWithServiceParameters(ApplicationManifest manifest, AppDeploymentRequest request, String deploymentId) {
        logger.debug("Pushing application manifest with no start");
        return this.requestPushApplication(PushApplicationManifestRequest.builder().manifest(manifest).noStart(Boolean.valueOf(true)).build()).doOnSuccess(v -> logger.info("Done uploading bits for {}", (Object)deploymentId)).doOnError(e -> logger.error(String.format("Error creating app %s.  Exception Message %s", deploymentId, e.getMessage()))).thenMany((Publisher)Flux.fromStream(this.bindParameterizedServiceInstanceRequests(request, deploymentId))).flatMap(bindRequest -> this.operations.services().bind(bindRequest).doOnSuccess(bv -> logger.info("Done binding service {} for {}", (Object)bindRequest.getServiceInstanceName(), (Object)deploymentId)).doOnError(e -> logger.error("Error: {} binding service {}", (Object)e.getMessage(), (Object)bindRequest.getServiceInstanceName()))).then(this.operations.applications().start(StartApplicationRequest.builder().name(deploymentId).stagingTimeout(this.deploymentProperties.getStagingTimeout()).startupTimeout(this.deploymentProperties.getStartupTimeout()).build()).doOnSuccess(sv -> logger.info("Started app for {} ", (Object)deploymentId)).doOnError(e -> logger.error("Error: {} starting app for {}.", (Object)e.getMessage(), (Object)deploymentId))).doOnError(e -> logger.error(String.format("Error: %s creating app %s", e.getMessage(), deploymentId), e));
    }

    private Mono<Void> requestDeleteApplication(String id) {
        return this.operations.applications().delete(DeleteApplicationRequest.builder().deleteRoutes(Boolean.valueOf(this.deploymentProperties.isDeleteRoutes())).name(id).build());
    }

    private Mono<ApplicationDetail> requestGetApplication(String id) {
        return CacheMono.lookup(k -> Mono.defer(() -> {
            ApplicationDetail ifPresent = (ApplicationDetail)this.cache.getIfPresent((Object)id);
            logger.debug("Cache get {}", (Object)ifPresent);
            return Mono.justOrEmpty((Object)ifPresent).map(Signal::next);
        }), (Object)id).onCacheMissResume(Mono.defer(() -> {
            logger.debug("Cache miss {}", (Object)id);
            return this.getApplicationDetail(id);
        })).andWriteWith((k, sig) -> Mono.fromRunnable(() -> {
            ApplicationDetail ap = (ApplicationDetail)sig.get();
            if (ap != null) {
                logger.debug("Cache put {} {}", k, (Object)ap);
                this.cache.put(k, (Object)ap);
            }
        }));
    }

    private Mono<ApplicationDetail> getApplicationDetail(String id) {
        return this.operations.applications().get(GetApplicationRequest.builder().name(id).build());
    }

    private Mono<Void> requestPushApplication(PushApplicationManifestRequest request) {
        return this.operations.applications().pushManifest(request);
    }

    private Flux<ApplicationSummary> requestSummary() {
        return this.operations.applications().list();
    }

    private String routePath(AppDeploymentRequest request) {
        String routePath = (String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.route-path");
        if (StringUtils.hasText((String)routePath) && !routePath.startsWith("/")) {
            throw new IllegalArgumentException("Cloud Foundry routes must start with \"/\". Route passed = [" + routePath + "].");
        }
        return routePath;
    }

    private String route(AppDeploymentRequest request) {
        return (String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.route");
    }

    private Set<String> routes(AppDeploymentRequest request) {
        HashSet<String> routes = new HashSet<String>();
        routes.addAll(this.deploymentProperties.getRoutes());
        routes.addAll(StringUtils.commaDelimitedListToSet((String)((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.routes"))));
        return routes;
    }

    private ApplicationHealthCheck toApplicationHealthCheck(String raw) {
        try {
            return ApplicationHealthCheck.from((String)raw);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unsupported health-check value '%s'. Available values are %s", raw, StringUtils.arrayToCommaDelimitedString((Object[])ApplicationHealthCheck.values())), e);
        }
    }

    private Boolean toggleNoRoute(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.no-route")).map(Boolean::valueOf).orElse(null);
    }
}

