/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

abstract class ServiceParser {
    private static Pattern serviceWithParameters = Pattern.compile("([^\\s]+)\\s*?(.*)?");
    private static Pattern singleQuotedLiteral = Pattern.compile("'([^']*?)'");

    ServiceParser() {
    }

    static Optional<Map<String, String>> getServiceParameters(String serviceSpec) {
        Matcher m = serviceWithParameters.matcher(serviceSpec);
        if (m.matches()) {
            return ServiceParser.parseParameters(m.group(2), serviceSpec);
        }
        return Optional.ofNullable(null);
    }

    static String getServiceInstanceName(String serviceSpec) {
        Matcher m = serviceWithParameters.matcher(serviceSpec);
        if (m.matches()) {
            return m.group(1);
        }
        throw new IllegalArgumentException("invalid service specification: " + serviceSpec);
    }

    static List<String> splitServiceProperties(String serviceProperties) {
        ArrayList<String> serviceInstances = new ArrayList<String>();
        if (StringUtils.hasText((String)serviceProperties)) {
            Matcher m = singleQuotedLiteral.matcher(serviceProperties);
            int index = 0;
            while (index >= 0 && m.find(index)) {
                String val = m.group().replaceAll("'", "");
                serviceInstances.add(val);
                serviceProperties = serviceProperties.replaceAll(m.group(), "");
                index = serviceProperties.indexOf("'");
                m = singleQuotedLiteral.matcher(serviceProperties);
            }
            Stream.of(serviceProperties.split(",")).filter(StringUtils::hasText).map(String::trim).forEach(s -> serviceInstances.add((String)s));
        }
        return serviceInstances;
    }

    private static Optional<Map<String, String>> parseParameters(String rawParametersString, String serviceSpec) {
        if (StringUtils.hasText((String)rawParametersString)) {
            LinkedHashMap parameters = new LinkedHashMap();
            String[] entries = rawParametersString.split(",");
            Stream.of(entries).forEach(s -> {
                String[] pair = s.split("[:|=]");
                if (pair.length != 2) {
                    throw new IllegalArgumentException("invalid service specification: " + serviceSpec);
                }
                parameters.put(pair[0].trim(), pair[1].trim());
            });
            return Optional.of(parameters);
        }
        return Optional.ofNullable(null);
    }
}

