/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.AbstractCloudFoundryException;
import org.cloudfoundry.UnknownCloudFoundryException;
import org.cloudfoundry.operations.services.BindServiceInstanceRequest;
import org.cloudfoundry.util.DelayUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.ServiceParser;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class AbstractCloudFoundryDeployer {
    protected final RuntimeEnvironmentInfo runtimeEnvironmentInfo;
    final CloudFoundryDeploymentProperties deploymentProperties;
    private final Logger logger = LoggerFactory.getLogger(AbstractCloudFoundryDeployer.class);

    AbstractCloudFoundryDeployer(CloudFoundryDeploymentProperties deploymentProperties, RuntimeEnvironmentInfo runtimeEnvironmentInfo) {
        this.deploymentProperties = deploymentProperties;
        this.runtimeEnvironmentInfo = runtimeEnvironmentInfo;
    }

    int memory(AppDeploymentRequest request) {
        String withUnit = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.memory", this.deploymentProperties.getMemory());
        return (int)ByteSizeUtils.parseToMebibytes((String)withUnit);
    }

    Set<String> servicesToBind(AppDeploymentRequest request) {
        Set<String> services = this.deploymentProperties.getServices().stream().filter(s -> !ServiceParser.getServiceParameters(s).isPresent()).collect(Collectors.toSet());
        Set requestServices = ServiceParser.splitServiceProperties((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services")).stream().filter(s -> !ServiceParser.getServiceParameters(s).isPresent()).collect(Collectors.toSet());
        services.addAll(requestServices);
        return services;
    }

    boolean includesServiceParameters(AppDeploymentRequest request) {
        return this.deploymentProperties.getServices().stream().anyMatch(s -> ServiceParser.getServiceParameters(s).isPresent()) || ServiceParser.splitServiceProperties((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services")).stream().anyMatch(s -> ServiceParser.getServiceParameters(s).isPresent());
    }

    Stream<BindServiceInstanceRequest> bindParameterizedServiceInstanceRequests(AppDeploymentRequest request, String deploymentId) {
        return ServiceParser.splitServiceProperties((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services")).stream().filter(s -> ServiceParser.getServiceParameters(s).isPresent()).map(s -> BindServiceInstanceRequest.builder().applicationName(deploymentId).serviceInstanceName(ServiceParser.getServiceInstanceName(s)).parameters(ServiceParser.getServiceParameters(s).get()).build());
    }

    int diskQuota(AppDeploymentRequest request) {
        String withUnit = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.disk", this.deploymentProperties.getDisk());
        return (int)ByteSizeUtils.parseToMebibytes((String)withUnit);
    }

    String buildpack(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.buildpack")).orElse(this.deploymentProperties.getBuildpack());
    }

    String javaOpts(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.javaOpts")).orElse(this.deploymentProperties.getJavaOpts());
    }

    Predicate<Throwable> isNotFoundError() {
        return t -> t instanceof AbstractCloudFoundryException && ((AbstractCloudFoundryException)t).getStatusCode() == HttpStatus.NOT_FOUND.value();
    }

    String getDockerImage(AppDeploymentRequest request) {
        try {
            String uri = request.getResource().getURI().toString();
            if (uri.startsWith("docker:")) {
                this.logger.info("Preparing to build an application from  {}. This may take some time if the image must be downloaded from a remote Docker registry.", (Object)request.getResource());
                return uri.substring("docker:".length());
            }
            return null;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    Path getApplication(AppDeploymentRequest request) {
        try {
            if (!request.getResource().getURI().toString().startsWith("docker:")) {
                if (request.getResource() instanceof UrlResource) {
                    this.logger.info("Preparing to build an application from {}. This may take some time if the artifact must be downloaded from a remote host.", (Object)request.getResource());
                }
                return request.getResource().getFile().toPath();
            }
            return null;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected Consumer<Throwable> logError(String msg) {
        return e -> {
            if (e instanceof UnknownCloudFoundryException) {
                this.logger.error(msg + "\nUnknownCloudFoundryException encountered, whose payload follows:\n" + ((UnknownCloudFoundryException)e).getPayload(), e);
            } else {
                this.logger.error(msg, e);
            }
        };
    }

    <T> Function<Mono<T>, Mono<T>> statusRetry(String id) {
        long statusTimeout = this.deploymentProperties.getStatusTimeout();
        long requestTimeout = Math.round((double)statusTimeout * 0.4);
        long initialRetryDelay = Math.round((double)statusTimeout * 0.1);
        if (requestTimeout < 500L) {
            this.logger.info("Computed statusRetry Request timeout = {} ms is below 500ms minimum value.  Setting to 500ms", (Object)requestTimeout);
            requestTimeout = 500L;
        }
        long requestTimeoutToUse = requestTimeout;
        return m -> m.timeout(Duration.ofMillis(requestTimeoutToUse)).doOnError(e -> this.logger.warn(String.format("Error getting status for %s within %sms, Retrying operation.", id, requestTimeoutToUse))).retryWhen(DelayUtils.exponentialBackOffError((Duration)Duration.ofMillis(initialRetryDelay), (Duration)Duration.ofMillis(statusTimeout / 2L), (Duration)Duration.ofMillis(statusTimeout)).andThen(retries -> Flux.from((Publisher)retries).doOnComplete(() -> this.logger.info("Successfully retried getStatus operation status [{}] for {}", (Object)id)))).doOnError(e -> this.logger.error(String.format("Retry operation on getStatus failed for %s.  Max retry time %sms", id, statusTimeout)));
    }

    protected void deleteLocalApplicationResourceFile(AppDeploymentRequest appDeploymentRequest) {
        try {
            File applicationFile = appDeploymentRequest.getResource().getFile();
            this.logger.info("Free Disk Space = {} bytes, Total Disk Space = {} bytes", (Object)applicationFile.getFreeSpace(), (Object)applicationFile.getTotalSpace());
            if (appDeploymentRequest.getResource().getURI().getScheme().toLowerCase().startsWith("http")) {
                boolean deleted = applicationFile.delete();
                this.logger.debug(deleted ? "Successfully deleted the application resource: " + applicationFile.getCanonicalPath() : "Could not delete the application resource: " + applicationFile.getCanonicalPath());
            }
        }
        catch (IOException e) {
            this.logger.warn("Exception deleting the application resource after successful CF push request. This could cause increase in disk space usage. Exception message: " + e.getMessage());
        }
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return this.runtimeEnvironmentInfo;
    }
}

