/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.github.zafarkhaja.semver.Version;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;

public class UnsupportedVersionTaskLauncher
implements TaskLauncher {
    public static final Version MINIMUM_SUPPORTED_VERSION = Version.forIntegers((int)2, (int)63, (int)0);
    private final Version actualVersion;
    private final RuntimeEnvironmentInfo info;

    public UnsupportedVersionTaskLauncher(Version actualVersion, RuntimeEnvironmentInfo info) {
        this.actualVersion = actualVersion;
        this.info = info;
    }

    public String launch(AppDeploymentRequest request) {
        throw this.failure();
    }

    public void cancel(String id) {
        throw this.failure();
    }

    public TaskStatus status(String id) {
        throw this.failure();
    }

    public void cleanup(String id) {
        throw this.failure();
    }

    public void destroy(String appName) {
        throw this.failure();
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return this.info;
    }

    private UnsupportedOperationException failure() {
        return new UnsupportedOperationException("Cloud Foundry API version " + this.actualVersion + " is earlier than " + MINIMUM_SUPPORTED_VERSION + " and is incompatible with cf-java-client " + RuntimeVersionUtils.getVersion(CloudFoundryOperations.class) + ". It is thus unsupported");
    }
}

