/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.applications.SummaryApplicationRequest;
import org.cloudfoundry.client.v2.applications.SummaryApplicationResponse;
import org.cloudfoundry.client.v2.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v2.applications.UpdateApplicationResponse;
import org.cloudfoundry.client.v3.tasks.CreateTaskRequest;
import org.cloudfoundry.client.v3.tasks.CreateTaskResponse;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.AbstractApplicationSummary;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.ApplicationSummary;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.PushApplicationRequest;
import org.cloudfoundry.operations.applications.StartApplicationRequest;
import org.cloudfoundry.operations.applications.StopApplicationRequest;
import org.cloudfoundry.operations.services.BindServiceInstanceRequest;
import org.cloudfoundry.operations.services.ServiceInstanceSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.cloudfoundry.AbstractCloudFoundryTaskLauncher;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CloudFoundry2630AndLaterTaskLauncher
extends AbstractCloudFoundryTaskLauncher {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundry2630AndLaterTaskLauncher.class);
    private final CloudFoundryClient client;
    private final CloudFoundryDeploymentProperties deploymentProperties;
    private final CloudFoundryOperations operations;

    public CloudFoundry2630AndLaterTaskLauncher(CloudFoundryClient client, CloudFoundryDeploymentProperties deploymentProperties, CloudFoundryOperations operations, RuntimeEnvironmentInfo runtimeEnvironmentInfo) {
        super(client, deploymentProperties, runtimeEnvironmentInfo);
        this.client = client;
        this.deploymentProperties = deploymentProperties;
        this.operations = operations;
    }

    public String launch(AppDeploymentRequest request) {
        return (String)this.getOrDeployApplication(request).then(application -> this.launchTask((SummaryApplicationResponse)application, request)).doOnSuccess(r -> logger.info("Task {} launch successful", (Object)request.getDefinition().getName())).doOnError(this.logError(String.format("Task %s launch failed", request.getDefinition().getName()))).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
    }

    @Override
    public void destroy(String appName) {
        this.requestDeleteApplication(appName).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).doOnSuccess(v -> logger.info("Successfully destroyed app {}", (Object)appName)).doOnError(this.logError(String.format("Failed to destroy app %s", appName))).subscribe();
    }

    private Mono<Void> bindServices(String name, AppDeploymentRequest request) {
        Set<String> servicesToBind = this.servicesToBind(request);
        return this.requestListServiceInstances().filter(serviceInstance -> servicesToBind.contains(serviceInstance.getName())).flatMap(serviceInstance -> this.requestBindService(name, serviceInstance.getName())).then();
    }

    private Mono<AbstractApplicationSummary> deployApplication(AppDeploymentRequest request) {
        String name = request.getDefinition().getName();
        return this.pushApplication(name, request).then(this.requestGetApplication(name)).then(application -> this.setEnvironmentVariables(application.getId(), this.getEnvironmentVariables(request.getDefinition().getProperties())).then(this.bindServices(name, request)).then(this.startApplication(name)).then(this.stopApplication(name)).then(Mono.just((Object)application)));
    }

    private String getCommand(SummaryApplicationResponse application, AppDeploymentRequest request) {
        return Stream.concat(Stream.of(application.getDetectedStartCommand()), request.getCommandlineArguments().stream()).collect(Collectors.joining(" "));
    }

    private Map<String, String> getEnvironmentVariables(Map<String, String> properties) {
        try {
            return Collections.singletonMap("SPRING_APPLICATION_JSON", OBJECT_MAPPER.writeValueAsString(properties));
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private Mono<AbstractApplicationSummary> getOptionalApplication(AppDeploymentRequest request) {
        String name = request.getDefinition().getName();
        return this.requestListApplications().filter(application -> name.equals(application.getName())).singleOrEmpty().cast(AbstractApplicationSummary.class);
    }

    private Mono<SummaryApplicationResponse> getOrDeployApplication(AppDeploymentRequest request) {
        return this.getOptionalApplication(request).switchIfEmpty(this.deployApplication(request)).then(application -> this.requestGetApplicationSummary(application.getId()));
    }

    private Mono<String> launchTask(SummaryApplicationResponse application, AppDeploymentRequest request) {
        return this.requestCreateTask(application.getId(), this.getCommand(application, request), this.memory(request), request.getDefinition().getName()).map(CreateTaskResponse::getId);
    }

    private Mono<Void> pushApplication(String name, AppDeploymentRequest request) {
        return this.requestPushApplication(PushApplicationRequest.builder().application(this.getApplication(request)).dockerImage(this.getDockerImage(request)).buildpack(this.buildpack(request)).command("echo '*** First run of container to allow droplet creation.***' && sleep 300").diskQuota(Integer.valueOf(this.diskQuota(request))).healthCheckType(ApplicationHealthCheck.NONE).memory(Integer.valueOf(this.memory(request))).name(name).noRoute(Boolean.valueOf(true)).noStart(Boolean.valueOf(true)).build());
    }

    private Mono<Void> requestBindService(String applicationName, String serviceInstanceName) {
        return this.operations.services().bind(BindServiceInstanceRequest.builder().applicationName(applicationName).serviceInstanceName(serviceInstanceName).build());
    }

    private Mono<CreateTaskResponse> requestCreateTask(String applicationId, String command, int memory, String name) {
        return this.client.tasks().create(CreateTaskRequest.builder().applicationId(applicationId).command(command).memoryInMb(Integer.valueOf(memory)).name(name).build());
    }

    private Mono<ApplicationDetail> requestGetApplication(String name) {
        return this.operations.applications().get(GetApplicationRequest.builder().name(name).build());
    }

    private Mono<SummaryApplicationResponse> requestGetApplicationSummary(String applicationId) {
        return this.client.applicationsV2().summary(SummaryApplicationRequest.builder().applicationId(applicationId).build());
    }

    private Flux<ApplicationSummary> requestListApplications() {
        return this.operations.applications().list();
    }

    private Flux<ServiceInstanceSummary> requestListServiceInstances() {
        return this.operations.services().listInstances();
    }

    private Mono<Void> requestPushApplication(PushApplicationRequest request) {
        return this.operations.applications().push(request);
    }

    private Mono<Void> requestStartApplication(String name, Duration stagingTimeout, Duration startupTimeout) {
        return this.operations.applications().start(StartApplicationRequest.builder().name(name).stagingTimeout(stagingTimeout).startupTimeout(startupTimeout).build());
    }

    private Mono<Void> requestStopApplication(String name) {
        return this.operations.applications().stop(StopApplicationRequest.builder().name(name).build());
    }

    private Mono<Void> requestDeleteApplication(String name) {
        return this.operations.applications().delete(DeleteApplicationRequest.builder().deleteRoutes(Boolean.valueOf(true)).name(name).build());
    }

    private Mono<UpdateApplicationResponse> requestUpdateApplication(String applicationId, Map<String, String> environmentVariables) {
        return this.client.applicationsV2().update(UpdateApplicationRequest.builder().applicationId(applicationId).environmentJsons(environmentVariables).build());
    }

    private Mono<UpdateApplicationResponse> setEnvironmentVariables(String applicationId, Map<String, String> environmentVariables) {
        return this.requestUpdateApplication(applicationId, environmentVariables);
    }

    private Mono<Void> startApplication(String name) {
        return this.requestStartApplication(name, this.deploymentProperties.getStagingTimeout(), this.deploymentProperties.getStartupTimeout());
    }

    private Mono<Void> stopApplication(String name) {
        return this.requestStopApplication(name);
    }
}

