/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v2.applications.UpdateApplicationResponse;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.cloudfoundry.operations.applications.PushApplicationRequest;
import org.cloudfoundry.operations.applications.StartApplicationRequest;
import org.cloudfoundry.operations.services.BindServiceInstanceRequest;
import org.cloudfoundry.util.DelayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.cloudfoundry.AbstractCloudFoundryDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.AppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppInstanceStatus;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CloudFoundryAppDeployer
extends AbstractCloudFoundryDeployer
implements AppDeployer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryAppDeployer.class);
    private final AppNameGenerator applicationNameGenerator;
    private final CloudFoundryClient client;
    private final CloudFoundryOperations operations;

    public CloudFoundryAppDeployer(AppNameGenerator applicationNameGenerator, CloudFoundryClient client, CloudFoundryDeploymentProperties deploymentProperties, CloudFoundryOperations operations) {
        super(deploymentProperties);
        this.operations = operations;
        this.client = client;
        this.applicationNameGenerator = applicationNameGenerator;
    }

    public String deploy(AppDeploymentRequest request) {
        String deploymentId = this.deploymentId(request);
        this.getStatus(deploymentId).doOnNext(status -> this.assertApplicationDoesNotExist(deploymentId, (AppStatus)status)).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
        this.pushApplication(deploymentId, request).then(this.setEnvironmentVariables(deploymentId, this.getEnvironmentVariables(deploymentId, request))).then(this.bindServices(deploymentId, request)).then(this.startApplication(deploymentId)).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).doOnSuccess(v -> logger.info("Successfully deployed {}", (Object)deploymentId)).doOnError(e -> logger.error(String.format("Failed to deploy %s", deploymentId), e)).subscribe();
        return deploymentId;
    }

    public AppStatus status(String id) {
        try {
            return (AppStatus)this.getStatus(id).doOnSuccess(v -> logger.info("Successfully computed status [{}] for {}", v, (Object)id)).doOnError(e -> logger.error(String.format("Failed to compute status for %s", id), e)).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
        }
        catch (Exception timeoutDueToBlock) {
            logger.error("Caught exception while querying for status of {}", (Object)id, (Object)timeoutDueToBlock);
            return this.createErrorAppStatus(id);
        }
    }

    public void undeploy(String id) {
        this.requestDeleteApplication(id).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).doOnSuccess(v -> logger.info("Successfully undeployed app {}", (Object)id)).doOnError(e -> logger.error(String.format("Failed to undeploy app %s", id), e)).subscribe();
    }

    private void assertApplicationDoesNotExist(String deploymentId, AppStatus status) {
        DeploymentState state = status.getState();
        if (state != DeploymentState.unknown) {
            throw new IllegalStateException(String.format("App %s is already deployed with state %s", deploymentId, state));
        }
    }

    private Mono<Void> bindServices(String deploymentId, AppDeploymentRequest request) {
        return Flux.fromIterable(this.servicesToBind(request)).flatMap(service -> this.requestBindService(deploymentId, (String)service).doOnSuccess(v -> logger.debug("Binding service {} to app {}", service, (Object)deploymentId)).doOnError(e -> logger.error(String.format("Failed to bind service %s to app %s", service, deploymentId), e))).then();
    }

    private AppStatus createAppStatus(ApplicationDetail applicationDetail, String deploymentId) {
        logger.trace("Gathering instances for " + applicationDetail);
        logger.trace("InstanceDetails: " + applicationDetail.getInstanceDetails());
        AppStatus.Builder builder = AppStatus.of((String)deploymentId);
        int i = 0;
        for (InstanceDetail instanceDetail : applicationDetail.getInstanceDetails()) {
            builder.with((AppInstanceStatus)new CloudFoundryAppInstanceStatus(applicationDetail, instanceDetail, i++));
        }
        while (i < applicationDetail.getInstances()) {
            builder.with((AppInstanceStatus)new CloudFoundryAppInstanceStatus(applicationDetail, null, i));
            ++i;
        }
        return builder.build();
    }

    private AppStatus createEmptyAppStatus(String deploymentId) {
        return AppStatus.of((String)deploymentId).build();
    }

    private AppStatus createErrorAppStatus(String deploymentId) {
        return AppStatus.of((String)deploymentId).generalState(DeploymentState.error).build();
    }

    private String deploymentId(AppDeploymentRequest request) {
        String prefix = Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.group")).map(group -> String.format("%s-", group)).orElse("");
        String appName = String.format("%s%s", prefix, request.getDefinition().getName());
        return this.applicationNameGenerator.generateAppName(appName);
    }

    private String domain(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.domain")).orElse(this.deploymentProperties.getDomain());
    }

    private Path getApplication(AppDeploymentRequest request) {
        try {
            return request.getResource().getFile().toPath();
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private Mono<String> getApplicationId(String deploymentId) {
        return this.requestGetApplication(deploymentId).map(ApplicationDetail::getId);
    }

    private Map<String, String> getApplicationProperties(String deploymentId, AppDeploymentRequest request) {
        Map<String, String> applicationProperties = this.getSanitizedApplicationProperties(deploymentId, request);
        if (!this.useSpringApplicationJson(request)) {
            return applicationProperties;
        }
        try {
            return Collections.singletonMap("SPRING_APPLICATION_JSON", OBJECT_MAPPER.writeValueAsString(applicationProperties));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getCommandLineArguments(AppDeploymentRequest request) {
        if (request.getCommandlineArguments().isEmpty()) {
            return Collections.emptyMap();
        }
        String argumentsAsString = request.getCommandlineArguments().stream().collect(Collectors.joining(" "));
        String yaml = new Yaml().dump(Collections.singletonMap("arguments", argumentsAsString));
        return Collections.singletonMap("JBP_CONFIG_JAVA_MAIN", yaml);
    }

    private Map<String, String> getEnvironmentVariables(String deploymentId, AppDeploymentRequest request) {
        HashMap<String, String> envVariables = new HashMap<String, String>();
        envVariables.putAll(this.getApplicationProperties(deploymentId, request));
        envVariables.putAll(this.getCommandLineArguments(request));
        String group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        if (group != null) {
            envVariables.put("SPRING_CLOUD_APPLICATION_GROUP", group);
        }
        return envVariables;
    }

    private Map<String, String> getSanitizedApplicationProperties(String deploymentId, AppDeploymentRequest request) {
        HashMap<String, String> applicationProperties = new HashMap<String, String>(request.getDefinition().getProperties());
        Optional.ofNullable(applicationProperties.remove("server.port")).ifPresent(port -> logger.warn("Ignoring 'server.port={}' for app {}, as Cloud Foundry will assign a local dynamic port. Route to the app will use port 80.", port, (Object)deploymentId));
        return applicationProperties;
    }

    private Mono<AppStatus> getStatus(String deploymentId) {
        return this.requestGetApplication(deploymentId).map(applicationDetail -> this.createAppStatus((ApplicationDetail)applicationDetail, deploymentId)).otherwiseReturn(IllegalArgumentException.class, (Object)this.createEmptyAppStatus(deploymentId)).retryWhen(DelayUtils.exponentialBackOffError((Duration)Duration.ofMillis(50L), (Duration)Duration.ofMillis(this.shortApiCallsTimeoutMs / 2), (Duration)Duration.ofMillis(this.shortApiCallsTimeoutMs))).otherwiseReturn((Object)this.createErrorAppStatus(deploymentId));
    }

    private ApplicationHealthCheck healthCheck(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.health-check")).map(this::toApplicationHealthCheck).orElse(this.deploymentProperties.getHealthCheck());
    }

    private String host(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.host")).orElse(this.deploymentProperties.getHost());
    }

    private int instances(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.count")).map(Integer::parseInt).orElse(this.deploymentProperties.getInstances());
    }

    private Mono<Void> pushApplication(String deploymentId, AppDeploymentRequest request) {
        return this.requestPushApplication(PushApplicationRequest.builder().application(this.getApplication(request)).buildpack(this.buildpack(request)).diskQuota(Integer.valueOf(this.diskQuota(request))).domain(this.domain(request)).healthCheckType(this.healthCheck(request)).host(this.host(request)).instances(Integer.valueOf(this.instances(request))).memory(Integer.valueOf(this.memory(request))).name(deploymentId).noRoute(this.toggleNoRoute(request)).noStart(Boolean.valueOf(true)).routePath(this.routePath(request)).build()).doOnSuccess(v -> logger.info("Done uploading bits for {}", (Object)deploymentId)).doOnError(e -> logger.error(String.format("Error creating app %s", deploymentId), e));
    }

    private Mono<Void> requestBindService(String deploymentId, String service) {
        return this.operations.services().bind(BindServiceInstanceRequest.builder().applicationName(deploymentId).serviceInstanceName(service).build());
    }

    private Mono<Void> requestDeleteApplication(String id) {
        return this.operations.applications().delete(DeleteApplicationRequest.builder().deleteRoutes(Boolean.valueOf(true)).name(id).build());
    }

    private Mono<ApplicationDetail> requestGetApplication(String id) {
        return this.operations.applications().get(GetApplicationRequest.builder().name(id).build());
    }

    private Mono<Void> requestPushApplication(PushApplicationRequest request) {
        return this.operations.applications().push(request);
    }

    private Mono<Void> requestStartApplication(String name, Duration stagingTimeout, Duration startupTimeout) {
        return this.operations.applications().start(StartApplicationRequest.builder().name(name).stagingTimeout(stagingTimeout).startupTimeout(startupTimeout).build());
    }

    private Mono<UpdateApplicationResponse> requestUpdateApplication(String applicationId, Map<String, String> environmentVariables) {
        return this.client.applicationsV2().update(UpdateApplicationRequest.builder().applicationId(applicationId).environmentJsons(environmentVariables).build());
    }

    private String routePath(AppDeploymentRequest request) {
        return (String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.route-path");
    }

    private Mono<UpdateApplicationResponse> setEnvironmentVariables(String deploymentId, Map<String, String> environmentVariables) {
        return this.getApplicationId(deploymentId).then(applicationId -> this.requestUpdateApplication((String)applicationId, environmentVariables)).doOnSuccess(v -> logger.debug("Setting individual env variables to {} for app {}", (Object)environmentVariables, (Object)deploymentId)).doOnError(e -> logger.error(String.format("Unable to set individual env variables for app %s", deploymentId)));
    }

    private Mono<Void> startApplication(String deploymentId) {
        return this.requestStartApplication(deploymentId, this.deploymentProperties.getStagingTimeout(), this.deploymentProperties.getStartupTimeout()).doOnSuccess(v -> logger.info("Started app {}", (Object)deploymentId)).doOnError(e -> logger.error(String.format("Failed to start app %s", deploymentId), e));
    }

    private ApplicationHealthCheck toApplicationHealthCheck(String raw) {
        try {
            return ApplicationHealthCheck.valueOf((String)raw.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unsupported health-check value '%s'. Available values are %s", raw, StringUtils.arrayToCommaDelimitedString((Object[])ApplicationHealthCheck.values())), e);
        }
    }

    private Boolean toggleNoRoute(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.no-route")).map(Boolean::valueOf).orElse(null);
    }

    private boolean useSpringApplicationJson(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.use-spring-application-json")).map(Boolean::valueOf).orElse(this.deploymentProperties.isUseSpringApplicationJson());
    }
}

