/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.time.Duration;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v3.tasks.CancelTaskRequest;
import org.cloudfoundry.client.v3.tasks.CancelTaskResponse;
import org.cloudfoundry.client.v3.tasks.GetTaskRequest;
import org.cloudfoundry.client.v3.tasks.GetTaskResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.cloudfoundry.AbstractCloudFoundryDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import reactor.core.publisher.Mono;

abstract class AbstractCloudFoundryTaskLauncher
extends AbstractCloudFoundryDeployer
implements TaskLauncher {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCloudFoundryTaskLauncher.class);
    private final CloudFoundryClient client;

    AbstractCloudFoundryTaskLauncher(CloudFoundryClient client, CloudFoundryDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
        this.client = client;
    }

    public void cancel(String id) {
        this.requestCancelTask(id).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).doOnSuccess(r -> logger.info("Task {} cancellation successful", (Object)id)).doOnError(t -> logger.error(String.format("Task %s cancellation failed", id), t)).subscribe();
    }

    public TaskStatus status(String id) {
        return (TaskStatus)this.requestGetTask(id).map(this::toTaskStatus).otherwiseReturn(this.isNotFoundError(), (Object)new TaskStatus(id, LaunchState.unknown, null)).doOnSuccess(r -> logger.info("Task {} status successful", (Object)id)).doOnError(t -> logger.error(String.format("Task %s status failed", id), t)).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
    }

    protected TaskStatus toTaskStatus(GetTaskResponse response) {
        switch (response.getState()) {
            case SUCCEEDED_STATE: {
                return new TaskStatus(response.getId(), LaunchState.complete, null);
            }
            case RUNNING_STATE: {
                return new TaskStatus(response.getId(), LaunchState.running, null);
            }
            case PENDING_STATE: {
                return new TaskStatus(response.getId(), LaunchState.launching, null);
            }
            case CANCELING_STATE: {
                return new TaskStatus(response.getId(), LaunchState.cancelled, null);
            }
            case FAILED_STATE: {
                return new TaskStatus(response.getId(), LaunchState.failed, null);
            }
        }
        throw new IllegalStateException(String.format("Unsupported CF task state %s", response.getState()));
    }

    private Mono<CancelTaskResponse> requestCancelTask(String taskId) {
        return this.client.tasks().cancel(CancelTaskRequest.builder().taskId(taskId).build());
    }

    private Mono<GetTaskResponse> requestGetTask(String taskId) {
        return this.client.tasks().get(GetTaskRequest.builder().taskId(taskId).build());
    }

    public void cleanup(String id) {
    }

    public void destroy(String appName) {
    }
}

