/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WordListRandomWords {
    private final List<String> adjectives;
    private final List<String> nouns;
    private final Random random;

    WordListRandomWords() {
        this(WordListRandomWords.getWordList("adjectives.txt"), WordListRandomWords.getWordList("nouns.txt"), new SecureRandom());
    }

    private WordListRandomWords(List<String> adjectives, List<String> nouns, Random random) {
        this.adjectives = adjectives;
        this.nouns = nouns;
        this.random = random;
    }

    public String getAdjective() {
        return this.adjectives.get(this.random.nextInt(this.adjectives.size()));
    }

    public String getNoun() {
        return this.nouns.get(this.random.nextInt(this.nouns.size()));
    }

    private static BufferedReader getFileReader(String filename) {
        InputStream inputStream = WordListRandomWords.class.getClassLoader().getResourceAsStream(filename);
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    private static List<String> getWordList(String filename) {
        try (Stream<String> stream = WordListRandomWords.getFileReader(filename).lines();){
            List<String> list = stream.map(String::trim).collect(Collectors.toList());
            return list;
        }
    }
}

