/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.applications.UpdateApplicationRequest;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.cloudfoundry.operations.applications.PushApplicationRequest;
import org.cloudfoundry.operations.applications.StartApplicationRequest;
import org.cloudfoundry.operations.services.BindServiceInstanceRequest;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.cloudfoundry.AppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppInstanceStatus;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CloudFoundryAppDeployer
implements AppDeployer {
    private final CloudFoundryConnectionProperties connectionProperties;
    private final CloudFoundryDeploymentProperties deploymentProperties;
    private final CloudFoundryOperations operations;
    private final CloudFoundryClient client;
    private final AppNameGenerator appDeploymentCustomizer;
    private static final Log logger = LogFactory.getLog(CloudFoundryAppDeployer.class);

    public CloudFoundryAppDeployer(CloudFoundryConnectionProperties connectionProperties, CloudFoundryDeploymentProperties deploymentProperties, CloudFoundryOperations operations, CloudFoundryClient client, AppNameGenerator appDeploymentCustomizer) {
        this.connectionProperties = connectionProperties;
        this.deploymentProperties = deploymentProperties;
        this.operations = operations;
        this.client = client;
        this.appDeploymentCustomizer = appDeploymentCustomizer;
    }

    public String deploy(AppDeploymentRequest request) {
        String deploymentId = this.deploymentId(request);
        DeploymentState state = this.status(deploymentId).getState();
        if (state != DeploymentState.unknown) {
            throw new IllegalStateException(String.format("App %s is already deployed with state %s", deploymentId, state));
        }
        this.asyncDeploy(request).subscribe();
        return deploymentId;
    }

    Mono<Void> asyncDeploy(AppDeploymentRequest request) {
        String name = this.deploymentId(request);
        logger.info((Object)String.format("Starting deployment of '%s'", name));
        HashMap appProperties = new HashMap(request.getDefinition().getProperties());
        String port = (String)appProperties.remove("server.port");
        if (port != null) {
            logger.warn((Object)String.format("Ignoring 'server.port=%s' for app %s, as Cloud Foundry will assign a local dynamic port. Route to the app will use port 80.", port, name));
        }
        HashMap<String, String> envVariables = new HashMap<String, String>();
        if (this.useSpringApplicationJson(request)) {
            try {
                envVariables.put("SPRING_APPLICATION_JSON", new ObjectMapper().writeValueAsString(appProperties));
            }
            catch (JsonProcessingException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            envVariables.putAll(appProperties);
        }
        if (!request.getCommandlineArguments().isEmpty()) {
            Yaml yaml = new Yaml();
            String argsAsYaml = yaml.dump(Collections.singletonMap("arguments", request.getCommandlineArguments().stream().collect(Collectors.joining(" "))));
            envVariables.put("JBP_CONFIG_JAVA_MAIN", argsAsYaml);
        }
        try {
            return this.operations.applications().push(PushApplicationRequest.builder().name(name).application(request.getResource().getFile().toPath()).domain(this.connectionProperties.getDomain()).buildpack(this.buildpack(request)).diskQuota(Integer.valueOf(this.diskQuota(request))).instances(Integer.valueOf(this.instances(request))).memory(Integer.valueOf(this.memory(request))).noStart(Boolean.valueOf(true)).build()).doOnSuccess(v -> logger.info((Object)String.format("Done uploading bits for %s", name))).doOnError(e -> logger.error((Object)String.format("Error creating app %s", name), e)).then(() -> this.getApplicationId(name).then(applicationId -> this.client.applicationsV2().update(UpdateApplicationRequest.builder().applicationId(applicationId).environmentJsons(envVariables).build())).doOnSuccess(v -> logger.debug((Object)String.format("Setting individual env variables to %s for app %s", envVariables, name))).doOnError(e -> logger.error((Object)String.format("Unable to set individual env variables for app %s", name)))).then(() -> this.servicesToBind(request).flatMap(service -> this.operations.services().bind(BindServiceInstanceRequest.builder().applicationName(name).serviceInstanceName(service).build()).doOnSuccess(v -> logger.debug((Object)String.format("Binding service %s to app %s", service, name))).doOnError(e -> logger.error((Object)String.format("Failed to bind service %s to app %s", service, name), e))).then()).then(() -> this.operations.applications().start(StartApplicationRequest.builder().name(name).build()).doOnSuccess(v -> logger.info((Object)String.format("Started app %s", name))).doOnError(e -> logger.error((Object)String.format("Failed to start app %s", name), e)));
        }
        catch (IOException e3) {
            return Mono.error((Throwable)e3);
        }
    }

    public void undeploy(String id) {
        this.asyncUndeploy(id).subscribe();
    }

    Mono<Void> asyncUndeploy(String id) {
        return this.operations.applications().delete(DeleteApplicationRequest.builder().deleteRoutes(Boolean.valueOf(true)).name(id).build()).doOnSuccess(v -> logger.info((Object)String.format("Successfully undeployed app %s", id))).doOnError(e -> logger.error((Object)String.format("Failed to undeploy app %s", id), e));
    }

    public AppStatus status(String id) {
        return (AppStatus)this.asyncStatus(id).block();
    }

    Mono<AppStatus> asyncStatus(String id) {
        return this.operations.applications().get(GetApplicationRequest.builder().name(id).build()).then(ad -> this.createAppStatusBuilder(id, (ApplicationDetail)ad)).otherwise(e -> this.emptyAppStatusBuilder(id)).map(AppStatus.Builder::build).doOnSuccess(v -> logger.info((Object)String.format("Successfully computed status [%s] for %s", v, id))).doOnError(e -> logger.error((Object)String.format("Failed to compute status for %s", id), e));
    }

    private String deploymentId(AppDeploymentRequest request) {
        String appName = Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.group")).map(groupName -> String.format("%s-", groupName)).orElse("") + request.getDefinition().getName();
        return this.appDeploymentCustomizer.generateAppName(appName);
    }

    private Mono<String> getApplicationId(String name) {
        return this.operations.applications().get(GetApplicationRequest.builder().name(name).build()).map(applicationDetail -> applicationDetail.getId());
    }

    private Flux<String> servicesToBind(AppDeploymentRequest request) {
        return Flux.fromStream(Stream.concat(this.deploymentProperties.getServices().stream(), StringUtils.commaDelimitedListToSet((String)((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services"))).stream()));
    }

    private int memory(AppDeploymentRequest request) {
        return Integer.parseInt(request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.cloudfoundry.memory", String.valueOf(this.deploymentProperties.getMemory())));
    }

    private int instances(AppDeploymentRequest request) {
        return Integer.parseInt(request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.count", "1"));
    }

    private String buildpack(AppDeploymentRequest request) {
        return request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.cloudfoundry.buildpack", this.deploymentProperties.getBuildpack());
    }

    private int diskQuota(AppDeploymentRequest request) {
        return Integer.parseInt(request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.cloudfoundry.disk", String.valueOf(this.deploymentProperties.getDisk())));
    }

    private boolean useSpringApplicationJson(AppDeploymentRequest request) {
        return Boolean.valueOf(request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.cloudfoundry.use-spring-application-json", String.valueOf(this.deploymentProperties.isUseSpringApplicationJson())));
    }

    private Mono<AppStatus.Builder> createAppStatusBuilder(String id, ApplicationDetail ad) {
        return this.emptyAppStatusBuilder(id).then(b -> this.addInstances((AppStatus.Builder)b, ad));
    }

    private Mono<AppStatus.Builder> emptyAppStatusBuilder(String id) {
        return Mono.just((Object)AppStatus.of((String)id));
    }

    private Mono<AppStatus.Builder> addInstances(AppStatus.Builder initial, ApplicationDetail ad) {
        logger.trace((Object)("Gathering instances for " + ad));
        logger.trace((Object)("InstanceDetails: " + ad.getInstanceDetails()));
        int i = 0;
        for (InstanceDetail instanceDetail : ad.getInstanceDetails()) {
            initial.with((AppInstanceStatus)new CloudFoundryAppInstanceStatus(ad, instanceDetail, i++));
        }
        while (i < ad.getInstances()) {
            initial.with((AppInstanceStatus)new CloudFoundryAppInstanceStatus(ad, null, i));
            ++i;
        }
        return Mono.just((Object)initial);
    }
}

