/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.cloudfoundry.config;

import io.pivotal.reactor.scheduler.ReactorSchedulerClient;
import io.pivotal.scheduler.SchedulerClient;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.dataflow.server.config.features.SchedulerConfiguration;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundry2630AndLaterTaskLauncher;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.scheduler.spi.cloudfoundry.CloudFoundryAppScheduler;
import org.springframework.cloud.scheduler.spi.cloudfoundry.CloudFoundrySchedulerProperties;
import org.springframework.cloud.scheduler.spi.core.Scheduler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Mono;

@Configuration
@Conditional(value={SchedulerConfiguration.SchedulerConfigurationPropertyChecker.class})
public class CloudFoundrySchedulerConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ReactorSchedulerClient reactorSchedulerClient(ConnectionContext context, TokenProvider passwordGrantTokenProvider, CloudFoundrySchedulerProperties properties) {
        return ReactorSchedulerClient.builder().connectionContext(context).tokenProvider(passwordGrantTokenProvider).root(Mono.just((Object)properties.getSchedulerUrl())).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Scheduler scheduler(ReactorSchedulerClient client, CloudFoundryOperations operations, CloudFoundryConnectionProperties properties, TaskLauncher taskLauncher, CloudFoundrySchedulerProperties schedulerProperties) {
        return new CloudFoundryAppScheduler((SchedulerClient)client, operations, properties, (CloudFoundry2630AndLaterTaskLauncher)taskLauncher, schedulerProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudFoundrySchedulerProperties cloudFoundrySchedulerProperties() {
        return new CloudFoundrySchedulerProperties();
    }
}

