/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.job.support;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.util.Assert;

public final class JobUtils {
    private JobUtils() {
        throw new AssertionError();
    }

    public static boolean isJobExecutionRestartable(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"The provided jobExecution must not be null.");
        BatchStatus batchStatus = jobExecution.getStatus();
        Assert.notNull((Object)batchStatus, (String)"The BatchStatus of the provided jobExecution must not be null.");
        return batchStatus.isGreaterThan(BatchStatus.STOPPING) && batchStatus.isLessThan(BatchStatus.ABANDONED);
    }

    public static boolean isJobExecutionAbandonable(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"The provided jobExecution must not be null.");
        BatchStatus batchStatus = jobExecution.getStatus();
        Assert.notNull((Object)batchStatus, (String)"The BatchStatus of the provided jobExecution must not be null.");
        return batchStatus.isGreaterThan(BatchStatus.STARTED) && batchStatus != BatchStatus.ABANDONED;
    }

    public static boolean isJobExecutionStoppable(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"The provided jobExecution must not be null.");
        BatchStatus batchStatus = jobExecution.getStatus();
        Assert.notNull((Object)batchStatus, (String)"The BatchStatus of the provided jobExecution must not be null.");
        return batchStatus.isLessThan(BatchStatus.STOPPING) && batchStatus != BatchStatus.COMPLETED;
    }
}

