/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.support.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;

public class JobParameterJacksonDeserializer
extends JsonDeserializer<JobParameter> {
    private final Logger logger = LoggerFactory.getLogger(JobParameterJacksonDeserializer.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JobParameter deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JobParameter jobParameter;
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        String value = node.get("value").asText();
        boolean identifying = node.get("identifying").asBoolean();
        String type = node.get("type").asText();
        if (!type.isEmpty() && !type.equalsIgnoreCase("STRING")) {
            if ("DATE".equalsIgnoreCase(type)) {
                jobParameter = new JobParameter(DateTime.parse((String)value).toDate(), identifying);
            } else if ("DOUBLE".equalsIgnoreCase(type)) {
                jobParameter = new JobParameter(Double.valueOf(value), identifying);
            } else {
                if (!"LONG".equalsIgnoreCase(type)) throw new IllegalStateException("Unsupported JobParameter type: " + type);
                jobParameter = new JobParameter(Long.valueOf(value), identifying);
            }
        } else {
            jobParameter = new JobParameter(value, identifying);
        }
        if (!this.logger.isDebugEnabled()) return jobParameter;
        this.logger.debug("jobParameter - value: {} (type: {}, isIdentifying: {})", new Object[]{jobParameter.getValue(), jobParameter.getType().name(), jobParameter.isIdentifying()});
        return jobParameter;
    }
}

