/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.core.TaskManifest;
import org.springframework.cloud.dataflow.rest.job.TaskJobExecution;
import org.springframework.cloud.dataflow.rest.job.TaskJobExecutionRel;
import org.springframework.cloud.dataflow.rest.resource.TaskExecutionStatus;
import org.springframework.cloud.dataflow.schema.AggregateTaskExecution;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TaskExecutionResource
extends RepresentationModel<TaskExecutionResource> {
    private long executionId;
    private Integer exitCode;
    private String taskName;
    private Date startTime;
    private Date endTime;
    private String exitMessage;
    private List<String> arguments;
    private List<Long> jobExecutionIds;
    private String errorMessage;
    private String externalExecutionId;
    private Long parentExecutionId;
    private String resourceUrl;
    private Map<String, String> appProperties;
    private Map<String, String> deploymentProperties;
    private String platformName;
    private String taskExecutionStatus;
    private String composedTaskJobExecutionStatus;
    private String schemaTarget;

    public TaskExecutionResource() {
        this.arguments = new ArrayList<String>();
    }

    public TaskExecutionResource(TaskJobExecutionRel taskJobExecutionRel) {
        Assert.notNull((Object)taskJobExecutionRel, (String)"taskJobExecutionDTO must not be null");
        this.executionId = taskJobExecutionRel.getTaskExecution().getExecutionId();
        this.parentExecutionId = taskJobExecutionRel.getTaskExecution().getParentExecutionId();
        this.exitCode = taskJobExecutionRel.getTaskExecution().getExitCode();
        this.taskName = taskJobExecutionRel.getTaskExecution().getTaskName();
        this.exitMessage = taskJobExecutionRel.getTaskExecution().getExitMessage();
        this.arguments = Collections.unmodifiableList(taskJobExecutionRel.getTaskExecution().getArguments());
        this.startTime = taskJobExecutionRel.getTaskExecution().getStartTime();
        this.endTime = taskJobExecutionRel.getTaskExecution().getEndTime();
        this.errorMessage = taskJobExecutionRel.getTaskExecution().getErrorMessage();
        this.externalExecutionId = taskJobExecutionRel.getTaskExecution().getExternalExecutionId();
        this.schemaTarget = taskJobExecutionRel.getTaskExecution().getSchemaTarget();
        this.platformName = taskJobExecutionRel.getTaskExecution().getPlatformName();
        this.jobExecutionIds = taskJobExecutionRel.getJobExecutionIds() == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Long>(taskJobExecutionRel.getJobExecutionIds()));
        if (taskJobExecutionRel.getTaskManifest() != null) {
            this.resourceUrl = taskJobExecutionRel.getTaskManifest().getTaskDeploymentRequest().getResource().toString();
            this.appProperties = taskJobExecutionRel.getTaskManifest().getTaskDeploymentRequest().getDefinition().getProperties();
            this.deploymentProperties = taskJobExecutionRel.getTaskManifest().getTaskDeploymentRequest().getDeploymentProperties();
        }
        if (taskJobExecutionRel.getTaskManifest() != null) {
            this.platformName = taskJobExecutionRel.getTaskManifest().getPlatformName();
        }
        this.composedTaskJobExecutionStatus = taskJobExecutionRel.getComposedTaskJobExecution() != null ? taskJobExecutionRel.getComposedTaskJobExecution().getJobExecution().getExitStatus().getExitCode() : null;
    }

    public TaskExecutionResource(AggregateTaskExecution taskExecution, TaskJobExecution composedTaskJobExecution) {
        Assert.notNull((Object)taskExecution, (String)"taskExecution must not be null");
        this.executionId = taskExecution.getExecutionId();
        this.exitCode = taskExecution.getExitCode();
        this.taskName = taskExecution.getTaskName();
        this.schemaTarget = taskExecution.getSchemaTarget();
        this.exitMessage = taskExecution.getExitMessage();
        this.arguments = Collections.unmodifiableList(taskExecution.getArguments());
        this.startTime = taskExecution.getStartTime();
        this.endTime = taskExecution.getEndTime();
        this.errorMessage = taskExecution.getErrorMessage();
        this.externalExecutionId = taskExecution.getExternalExecutionId();
        this.composedTaskJobExecutionStatus = composedTaskJobExecution != null ? composedTaskJobExecution.getJobExecution().getExitStatus().getExitCode() : null;
    }

    public TaskExecutionResource(AggregateTaskExecution taskExecution, TaskManifest taskManifest, TaskJobExecution composedTaskJobExecution) {
        Assert.notNull((Object)taskExecution, (String)"taskExecution must not be null");
        Assert.notNull((Object)taskManifest, (String)"taskManifest must not be null");
        this.executionId = taskExecution.getExecutionId();
        this.exitCode = taskExecution.getExitCode();
        this.taskName = taskExecution.getTaskName();
        this.schemaTarget = taskExecution.getSchemaTarget();
        this.exitMessage = taskExecution.getExitMessage();
        this.arguments = Collections.unmodifiableList(taskExecution.getArguments());
        this.startTime = taskExecution.getStartTime();
        this.endTime = taskExecution.getEndTime();
        this.errorMessage = taskExecution.getErrorMessage();
        this.externalExecutionId = taskExecution.getExternalExecutionId();
        this.resourceUrl = taskManifest.getTaskDeploymentRequest().getResource().toString();
        this.appProperties = taskManifest.getTaskDeploymentRequest().getDefinition().getProperties();
        this.deploymentProperties = taskManifest.getTaskDeploymentRequest().getDeploymentProperties();
        this.composedTaskJobExecutionStatus = composedTaskJobExecution != null ? composedTaskJobExecution.getJobExecution().getExitStatus().getExitCode() : null;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<Long> getJobExecutionIds() {
        return this.jobExecutionIds;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getExternalExecutionId() {
        return this.externalExecutionId;
    }

    public Long getParentExecutionId() {
        return this.parentExecutionId;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public Map<String, String> getAppProperties() {
        return this.appProperties;
    }

    public Map<String, String> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getSchemaTarget() {
        return this.schemaTarget;
    }

    public void setSchemaTarget(String schemaTarget) {
        this.schemaTarget = schemaTarget;
    }

    public void setTaskExecutionStatus(String taskExecutionStatus) {
        this.taskExecutionStatus = taskExecutionStatus;
    }

    public TaskExecutionStatus getTaskExecutionStatus() {
        if (StringUtils.hasText((String)this.taskExecutionStatus)) {
            return TaskExecutionStatus.valueOf(this.taskExecutionStatus);
        }
        if (this.startTime == null) {
            return TaskExecutionStatus.UNKNOWN;
        }
        if (this.endTime == null) {
            return TaskExecutionStatus.RUNNING;
        }
        if (this.composedTaskJobExecutionStatus != null) {
            return this.composedTaskJobExecutionStatus.equals("ABANDONED") || this.composedTaskJobExecutionStatus.equals("FAILED") || this.composedTaskJobExecutionStatus.equals("STOPPED") ? TaskExecutionStatus.ERROR : TaskExecutionStatus.COMPLETE;
        }
        return this.exitCode == null ? TaskExecutionStatus.RUNNING : (this.exitCode == 0 ? TaskExecutionStatus.COMPLETE : TaskExecutionStatus.ERROR);
    }

    public static class Page
    extends PagedModel<TaskExecutionResource> {
    }
}

