/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.dataflow.core.TaskManifest;
import org.springframework.cloud.dataflow.rest.job.TaskJobExecution;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.util.Assert;

public class TaskJobExecutionRel {
    private final TaskExecution taskExecution;
    private final List<Long> jobExecutionIds;
    private final TaskManifest taskManifest;
    private final TaskJobExecution composedTaskJobExecution;

    public TaskJobExecutionRel(TaskExecution taskExecution, List<Long> jobExecutionIds, TaskManifest taskManifest, TaskJobExecution composedTaskJobExecution) {
        Assert.notNull((Object)taskExecution, (String)"taskExecution must not be null");
        this.taskExecution = taskExecution;
        this.taskManifest = taskManifest;
        this.jobExecutionIds = jobExecutionIds == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Long>(jobExecutionIds));
        this.composedTaskJobExecution = composedTaskJobExecution;
    }

    public TaskExecution getTaskExecution() {
        return this.taskExecution;
    }

    public List<Long> getJobExecutionIds() {
        return this.jobExecutionIds;
    }

    public TaskManifest getTaskManifest() {
        return this.taskManifest;
    }

    public TaskJobExecution getComposedTaskJobExecution() {
        return this.composedTaskJobExecution;
    }
}

