/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.dsl.task;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.dsl.task.Task;
import org.springframework.cloud.dataflow.rest.resource.TaskDefinitionResource;

public class TaskBuilder {
    private final DataFlowOperations dataFlowOperations;
    private String taskDefinitionName;
    private String taskDefinition;
    private String taskDescription;

    TaskBuilder(DataFlowOperations dataFlowOperations) {
        this.dataFlowOperations = dataFlowOperations;
    }

    public TaskBuilder name(String definitionName) {
        this.taskDefinitionName = definitionName;
        return this;
    }

    public TaskBuilder definition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
        return this;
    }

    public TaskBuilder description(String taskDescription) {
        this.taskDescription = taskDescription;
        return this;
    }

    public Task build() {
        TaskDefinitionResource taskDefinitionResource = this.dataFlowOperations.taskOperations().create(this.taskDefinitionName, this.taskDefinition, this.taskDescription);
        return new Task(taskDefinitionResource.getName(), this.dataFlowOperations);
    }

    public List<Task> allTasks() {
        return this.dataFlowOperations.taskOperations().list().getContent().stream().map(td -> new Task(td.getName(), this.dataFlowOperations)).collect(Collectors.toList());
    }

    public Optional<Task> findByName(String taskName) {
        return this.allTasks().stream().filter(task -> task.getTaskName().equalsIgnoreCase(taskName)).findFirst();
    }
}

