/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.rest.client.RuntimeOperations;
import org.springframework.cloud.dataflow.rest.resource.AppStatusResource;
import org.springframework.cloud.dataflow.rest.resource.StreamStatusResource;
import org.springframework.cloud.dataflow.rest.util.ArgumentSanitizer;
import org.springframework.cloud.skipper.domain.ActuatorPostRequest;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RuntimeTemplate
implements RuntimeOperations {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeTemplate.class);
    private final RestTemplate restTemplate;
    private final Link appStatusesUriTemplate;
    private final Link appStatusUriTemplate;
    private final Link appActuatorUriTemplate;
    private final Link appUrlPostUriTemplate;
    private final Link streamStatusUriTemplate;

    RuntimeTemplate(RestTemplate restTemplate, RepresentationModel<?> resources) {
        this.restTemplate = restTemplate;
        this.appStatusesUriTemplate = this.getLink("runtime/apps", resources, true);
        this.appStatusUriTemplate = this.getLink("runtime/apps/{appId}", resources, true);
        this.streamStatusUriTemplate = this.getLink("runtime/streams/{streamNames}", resources, true);
        this.appActuatorUriTemplate = this.getLink("runtime/apps/{appId}/instances/{instanceId}/actuator", resources, false);
        this.appUrlPostUriTemplate = this.getLink("runtime/apps/{appId}/instances/{instanceId}/post", resources, false);
    }

    private Link getLink(String relationPath, RepresentationModel<?> resources, boolean required) {
        Optional link = resources.getLink(relationPath);
        if (required && !link.isPresent()) {
            throw new RuntimeException("Unable to retrieve URI template for " + relationPath);
        }
        return link.orElse(null);
    }

    @Override
    public PagedModel<AppStatusResource> status() {
        String uriTemplate = this.appStatusesUriTemplate.expand(new Object[0]).getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (PagedModel)this.restTemplate.getForObject(uriTemplate, AppStatusResource.Page.class, new Object[0]);
    }

    @Override
    public AppStatusResource status(String deploymentId) {
        return (AppStatusResource)this.restTemplate.getForObject(this.appStatusUriTemplate.expand(new Object[]{deploymentId}).getHref(), AppStatusResource.class, new Object[0]);
    }

    @Override
    public PagedModel<StreamStatusResource> streamStatus(String ... streamNames) {
        return (PagedModel)this.restTemplate.getForObject(this.streamStatusUriTemplate.expand((Object[])streamNames).getHref(), StreamStatusResource.Page.class, new Object[0]);
    }

    @Override
    public String getFromActuator(String appId, String instanceId, String endpoint) {
        Assert.notNull((Object)this.appActuatorUriTemplate, (String)"actuator endpoint not found");
        String uri = this.appActuatorUriTemplate.expand(new Object[]{appId, instanceId, endpoint}).getHref();
        return (String)this.restTemplate.getForObject(uri, String.class, new Object[0]);
    }

    @Override
    public Object postToActuator(String appId, String instanceId, String endpoint, Map<String, Object> body) {
        Assert.notNull((Object)this.appActuatorUriTemplate, (String)"actuator endpoint not found");
        String uri = this.appActuatorUriTemplate.expand(new Object[]{appId, instanceId}).getHref();
        ActuatorPostRequest actuatorPostRequest = new ActuatorPostRequest();
        actuatorPostRequest.setEndpoint(endpoint);
        actuatorPostRequest.setBody(body);
        return this.restTemplate.postForObject(uri, (Object)actuatorPostRequest, Object.class, new Object[0]);
    }

    @Override
    public void postToUrl(String appId, String instanceId, byte[] data, HttpHeaders headers) {
        Assert.notNull((Object)this.appUrlPostUriTemplate, (String)"post endpoint not found");
        String uri = this.appUrlPostUriTemplate.expand(new Object[]{appId, instanceId}).getHref();
        this.waitForUrl(uri, Duration.ofSeconds(30L));
        HttpEntity entity = new HttpEntity((Object)data, (MultiValueMap)headers);
        if (logger.isDebugEnabled()) {
            ArgumentSanitizer sanitizer = new ArgumentSanitizer();
            logger.debug("postToUrl:{}:{}:{}:{}", new Object[]{appId, instanceId, uri, sanitizer.sanitizeHeaders(headers)});
        }
        this.waitForUrl(uri, Duration.ofSeconds(30L));
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, entity, String.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RuntimeException("POST:exception:" + response.getStatusCode() + ":" + (String)response.getBody());
        }
    }

    private void waitForUrl(String uri, Duration timeout) {
        long waitUntilMillis = System.currentTimeMillis() + timeout.toMillis();
        do {
            try {
                Set allowed = this.restTemplate.optionsForAllow(uri, new Object[0]);
                if (!CollectionUtils.isEmpty((Collection)allowed)) {
                    break;
                }
            }
            catch (Throwable x) {
                String message = x.getMessage();
                if (message.contains("UnknownHostException")) {
                    logger.trace("waitForUrl:retry:exception:" + x);
                    continue;
                }
                if (message.contains("500")) break;
                logger.trace("waitForUrl:exception:" + x);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (waitUntilMillis <= System.currentTimeMillis());
    }
}

