/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.registry.AbstractAppRegistryCommon;
import org.springframework.cloud.dataflow.registry.AppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;
import org.springframework.cloud.dataflow.registry.support.AppResourceCommon;
import org.springframework.cloud.dataflow.registry.support.NoSuchAppRegistrationException;
import org.springframework.cloud.deployer.resource.registry.UriRegistry;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public class AppRegistry
extends AbstractAppRegistryCommon
implements AppRegistryCommon {
    private static final Logger logger = LoggerFactory.getLogger(AppRegistry.class);
    private final UriRegistry uriRegistry;
    private static final Function<Map.Entry<Object, Object>, AbstractMap.SimpleImmutableEntry<String, URI>> toStringAndUriFUNC = kv -> {
        try {
            return new AbstractMap.SimpleImmutableEntry<String, URI>((String)kv.getKey(), new URI((String)kv.getValue()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    };

    public AppRegistry(UriRegistry uriRegistry, AppResourceCommon appResourceService) {
        super(appResourceService);
        Assert.notNull((Object)uriRegistry, (String)"'uriRegistry' must not be null");
        this.uriRegistry = uriRegistry;
    }

    @Override
    public AppRegistration find(String name, ApplicationType type) {
        try {
            String key = this.key(name, type);
            URI uri = this.uriRegistry.find(key);
            URI metadataUri = this.metadataUriFromRegistry(key);
            return new AppRegistration(name, type, uri, metadataUri);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public List<AppRegistration> findAll() {
        return this.uriRegistry.findAll().entrySet().stream().flatMap(kv -> this.toValidAppRegistration((Map.Entry<String, URI>)kv, this.metadataUriFromRegistry((String)kv.getKey()))).sorted((a, b) -> a.compareTo((AppRegistration)b)).collect(Collectors.toList());
    }

    public Page<AppRegistration> findAll(Pageable pageable) {
        List<AppRegistration> appRegistrations = this.findAll();
        long to = Math.min(appRegistrations.size(), pageable.getOffset() + pageable.getPageSize());
        int offset = 0;
        int page = 0;
        if ((long)pageable.getOffset() <= to) {
            offset = pageable.getOffset();
            page = pageable.getPageNumber();
        } else if ((long)(pageable.getOffset() + pageable.getPageSize()) <= to) {
            offset = pageable.getOffset();
        }
        return new PageImpl(appRegistrations.subList(offset, (int)to), (Pageable)new PageRequest(page, pageable.getPageSize()), (long)appRegistrations.size());
    }

    public AppRegistration save(String name, ApplicationType type, URI uri, URI metadataUri) {
        this.uriRegistry.register(this.key(name, type), uri);
        if (metadataUri != null) {
            this.uriRegistry.register(this.metadataKey(name, type), metadataUri);
        }
        return new AppRegistration(name, type, uri, metadataUri);
    }

    @Override
    public Stream<AppRegistration> toValidAppRegistration(Map.Entry<String, URI> kv, URI metadataURI) {
        String key = kv.getKey();
        String[] tokens = key.split("\\.");
        if (tokens.length == 2) {
            String name = tokens[1];
            ApplicationType type = ApplicationType.valueOf((String)tokens[0]);
            URI appURI = this.warnOnMalformedURI(key, kv.getValue());
            return Stream.of(new AppRegistration(name, type, "none", appURI, metadataURI));
        }
        Assert.isTrue((tokens.length == 3 && "metadata".equals(tokens[2]) ? 1 : 0) != 0, (String)("Invalid format for app key '" + key + "'in file. Must be <type>.<name> or <type>.<name>.metadata"));
        return Stream.empty();
    }

    @Override
    protected boolean isOverwrite(AppRegistration app, boolean overwrite) {
        if (overwrite) {
            return true;
        }
        return !this.uriRegistry.findAll().keySet().contains(this.key(app.getName(), app.getType()));
    }

    @Override
    public AppRegistration save(AppRegistration app) {
        return this.save(app.getName(), app.getType(), app.getUri(), app.getMetadataUri());
    }

    public void delete(String name, ApplicationType type) {
        if (this.find(name, type) == null) {
            throw new NoSuchAppRegistrationException(name, type);
        }
        this.uriRegistry.unregister(this.key(name, type));
        this.uriRegistry.unregister(this.metadataKey(name, type));
    }

    private URI metadataUriFromRegistry(String key) {
        try {
            return this.uriRegistry.find(this.metadataKey(key));
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private String key(String name, ApplicationType type) {
        return String.format("%s.%s", type, name);
    }

    private String metadataKey(String name, ApplicationType type) {
        return String.format("%s.%s.%s", type, name, "metadata");
    }

    private String metadataKey(String key) {
        return key + "." + "metadata";
    }

    @Override
    public boolean appExist(String name, ApplicationType type) {
        return this.find(name, type) != null;
    }
}

