/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.dataflow.core.AbstractPlatformProperties;
import org.springframework.cloud.dataflow.core.AbstractTaskPlatformFactory;
import org.springframework.cloud.dataflow.core.Launcher;
import org.springframework.cloud.dataflow.server.config.kubernetes.KubernetesPlatformProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesClientFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesScheduler;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesSchedulerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesTaskLauncher;
import org.springframework.cloud.deployer.spi.scheduler.Scheduler;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;

public class KubernetesTaskPlatformFactory
extends AbstractTaskPlatformFactory<KubernetesPlatformProperties> {
    private final boolean schedulesEnabled;

    public KubernetesTaskPlatformFactory(KubernetesPlatformProperties platformProperties, boolean schedulesEnabled) {
        super((AbstractPlatformProperties)platformProperties, "Kubernetes");
        this.schedulesEnabled = schedulesEnabled;
    }

    public Launcher createLauncher(String account) {
        KubernetesDeployerProperties kubernetesProperties = (KubernetesDeployerProperties)((KubernetesPlatformProperties)this.platformProperties).accountProperties(account);
        DefaultContainerFactory containerFactory = new DefaultContainerFactory((KubernetesDeployerProperties)((KubernetesPlatformProperties)this.platformProperties).accountProperties(account));
        KubernetesClient kubernetesClient = KubernetesClientFactory.getKubernetesClient((KubernetesDeployerProperties)((KubernetesDeployerProperties)((KubernetesPlatformProperties)this.platformProperties).accountProperties(account)));
        KubernetesTaskLauncher kubernetesTaskLauncher = new KubernetesTaskLauncher(kubernetesProperties, kubernetesClient, (ContainerFactory)containerFactory);
        KubernetesSchedulerProperties kubernetesSchedulerProperties = new KubernetesSchedulerProperties();
        BeanUtils.copyProperties((Object)kubernetesProperties, (Object)kubernetesSchedulerProperties);
        Scheduler scheduler = this.getScheduler(kubernetesSchedulerProperties, kubernetesClient);
        Launcher launcher = new Launcher(account, "Kubernetes", (TaskLauncher)kubernetesTaskLauncher, scheduler);
        launcher.setDescription(String.format("master url = [%s], namespace = [%s], api version = [%s]", kubernetesClient.getMasterUrl(), kubernetesClient.getNamespace(), kubernetesClient.getApiVersion()));
        return launcher;
    }

    private Scheduler getScheduler(KubernetesSchedulerProperties kubernetesSchedulerProperties, KubernetesClient kubernetesClient) {
        KubernetesScheduler scheduler = null;
        if (this.schedulesEnabled) {
            scheduler = new KubernetesScheduler(kubernetesClient, kubernetesSchedulerProperties);
        }
        return scheduler;
    }
}

