/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepositoryJsonBuilder;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.loader.jar.JarFile;
import org.springframework.cloud.dataflow.configuration.metadata.AppMetadataResolutionException;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.BootClassLoaderFactory;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImageMetadataResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BootApplicationConfigurationMetadataResolver
extends ApplicationConfigurationMetadataResolver {
    private static final Logger logger = LoggerFactory.getLogger(BootApplicationConfigurationMetadataResolver.class);
    private static final String CONFIGURATION_METADATA_PATTERN = "classpath*:/META-INF/spring-configuration-metadata.json";
    private static final String DEPRECATED_SPRING_CONFIGURATION_PROPERTIES = "classpath*:/META-INF/spring-configuration-metadata-whitelist.properties";
    private static final String DEPRECATED_DATAFLOW_CONFIGURATION_PROPERTIES = "classpath*:/META-INF/dataflow-configuration-metadata-whitelist.properties";
    private static final String VISIBLE_PROPERTIES = "classpath*:/META-INF/dataflow-configuration-metadata.properties";
    private static final String PORT_MAPPING_PROPERTIES = "classpath*:/META-INF/dataflow-configuration-port-mapping.properties";
    private static final String OPTION_GROUPS_PROPERTIES = "classpath*:/META-INF/dataflow-configuration-option-groups.properties";
    private static final String CONFIGURATION_PROPERTIES_CLASSES = "configuration-properties.classes";
    private static final String CONFIGURATION_PROPERTIES_NAMES = "configuration-properties.names";
    private static final String CONFIGURATION_PROPERTIES_INBOUND_PORTS = "configuration-properties.inbound-ports";
    private static final String CONFIGURATION_PROPERTIES_OUTBOUND_PORTS = "configuration-properties.outbound-ports";
    private static final String CONFIGURATION_PROPERTIES_OPTION_GROUPS = "org.springframework.cloud.dataflow.configuration-properties.option-groups";
    private static final String CONTAINER_IMAGE_CONFIGURATION_METADATA_LABEL_NAME = "org.springframework.cloud.dataflow.spring-configuration-metadata.json";
    private final Set<String> globalVisibleProperties = new HashSet<String>();
    private final Set<String> globalVisibleClasses = new HashSet<String>();
    private final ClassLoader parent;
    private ContainerImageMetadataResolver containerImageMetadataResolver;

    public BootApplicationConfigurationMetadataResolver(ContainerImageMetadataResolver containerImageMetadataResolver) {
        this(null, containerImageMetadataResolver);
    }

    public BootApplicationConfigurationMetadataResolver(ClassLoader parent, ContainerImageMetadataResolver containerImageMetadataResolver) {
        this.parent = parent;
        this.containerImageMetadataResolver = containerImageMetadataResolver;
        JarFile.registerUrlProtocolHandler();
        try {
            this.loadVisible(BootApplicationConfigurationMetadataResolver.visibleConfigurationMetadataResources(ApplicationConfigurationMetadataResolver.class.getClassLoader()), this.globalVisibleClasses, this.globalVisibleProperties);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading global list of visible configuration properties", e);
        }
    }

    private static Resource[] visibleConfigurationMetadataResources(ClassLoader classLoader) throws IOException {
        Resource[] deprecatedDataflowConfigurationResources;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(classLoader);
        Resource[] configurationResources = resourcePatternResolver.getResources(VISIBLE_PROPERTIES);
        Resource[] deprecatedSpringConfigurationResources = resourcePatternResolver.getResources(DEPRECATED_SPRING_CONFIGURATION_PROPERTIES);
        if (deprecatedSpringConfigurationResources.length > 0) {
            logger.warn("The use of classpath*:/META-INF/spring-configuration-metadata-whitelist.properties is a deprecated. Please use classpath*:/META-INF/dataflow-configuration-metadata.properties instead.");
        }
        if ((deprecatedDataflowConfigurationResources = resourcePatternResolver.getResources(DEPRECATED_DATAFLOW_CONFIGURATION_PROPERTIES)).length > 0) {
            logger.warn("The use of classpath*:/META-INF/dataflow-configuration-metadata-whitelist.properties is a deprecated. Please use classpath*:/META-INF/dataflow-configuration-metadata.properties instead.");
        }
        Resource[] portMappingResources = resourcePatternResolver.getResources(PORT_MAPPING_PROPERTIES);
        Resource[] groupingResources = resourcePatternResolver.getResources(OPTION_GROUPS_PROPERTIES);
        return BootApplicationConfigurationMetadataResolver.concatArrays(configurationResources, deprecatedSpringConfigurationResources, deprecatedDataflowConfigurationResources, portMappingResources, groupingResources);
    }

    private static Resource[] concatArrays(Resource[] ... arrays) {
        return (Resource[])Arrays.stream(arrays).flatMap(Arrays::stream).toArray(Resource[]::new);
    }

    @Override
    public List<ConfigurationMetadataProperty> listProperties(Resource app, boolean exhaustive) {
        try {
            if (app != null) {
                if (this.isDockerSchema(app.getURI())) {
                    return this.resolvePropertiesFromContainerImage(app.getURI());
                }
                Archive archive = this.resolveAsArchive(app);
                return this.listProperties(archive, exhaustive);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve properties for resource {} because of {}", (Object)app, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            if (logger.isDebugEnabled()) {
                logger.debug("(Details) for failed to retrieve properties for resource:" + app, (Throwable)e);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Set<String>> listPortNames(Resource app) {
        try {
            if (app != null) {
                if (this.isDockerSchema(app.getURI())) {
                    return this.resolvePortNamesFromContainerImage(app.getURI());
                }
                Archive archive = this.resolveAsArchive(app);
                return this.listPortNames(archive);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve port names for resource {} because of {}", (Object)app, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            if (logger.isDebugEnabled()) {
                logger.debug("(Details) for failed to retrieve port names for resource:" + app, (Throwable)e);
            }
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Set<String>> listOptionGroups(Resource app) {
        try {
            if (app != null) {
                if (this.isDockerSchema(app.getURI())) {
                    return this.resolveOptionGroupsFromContainerImage(app.getURI());
                }
                Archive archive = this.resolveAsArchive(app);
                return this.listOptionGroups(archive);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve port names for resource {} because of {}", (Object)app, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            if (logger.isDebugEnabled()) {
                logger.debug("(Details) for failed to retrieve port names for resource:" + app, (Throwable)e);
            }
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    private boolean isDockerSchema(URI uri) {
        return uri != null && uri.getScheme() != null && uri.getScheme().contains("docker");
    }

    private List<ConfigurationMetadataProperty> resolvePropertiesFromContainerImage(URI imageUri) {
        String imageName = imageUri.getSchemeSpecificPart();
        Map<String, String> labels = this.containerImageMetadataResolver.getImageLabels(imageName);
        if (CollectionUtils.isEmpty(labels)) {
            return Collections.emptyList();
        }
        String encodedMetadata = labels.get(CONTAINER_IMAGE_CONFIGURATION_METADATA_LABEL_NAME);
        if (!StringUtils.hasText((String)encodedMetadata)) {
            return Collections.emptyList();
        }
        try {
            ConfigurationMetadataRepository configurationMetadataRepository = ConfigurationMetadataRepositoryJsonBuilder.create().withJsonResource((InputStream)new ByteArrayInputStream(encodedMetadata.getBytes())).build();
            List<ConfigurationMetadataProperty> result = configurationMetadataRepository.getAllProperties().entrySet().stream().map(e -> (ConfigurationMetadataProperty)e.getValue()).collect(Collectors.toList());
            return result;
        }
        catch (Exception e2) {
            throw new AppMetadataResolutionException("Invalid Metadata for " + imageName);
        }
    }

    private Map<String, Set<String>> resolvePortNamesFromContainerImage(URI imageUri) {
        String outboundPortMapping;
        String imageName = imageUri.getSchemeSpecificPart();
        HashMap<String, Set<String>> portsMap = new HashMap<String, Set<String>>();
        Map<String, String> labels = this.containerImageMetadataResolver.getImageLabels(imageName);
        if (CollectionUtils.isEmpty(labels)) {
            return Collections.emptyMap();
        }
        String inboundPortMapping = labels.get(CONFIGURATION_PROPERTIES_INBOUND_PORTS);
        if (StringUtils.hasText((String)inboundPortMapping)) {
            HashSet<String> inboundPorts = new HashSet<String>();
            inboundPorts.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)inboundPortMapping, (String)",", (String)" ")));
            portsMap.put("inbound", inboundPorts);
        }
        if (StringUtils.hasText((String)(outboundPortMapping = labels.get(CONFIGURATION_PROPERTIES_OUTBOUND_PORTS)))) {
            HashSet<String> outboundPorts = new HashSet<String>();
            outboundPorts.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)outboundPortMapping, (String)",", (String)" ")));
            portsMap.put("outbound", outboundPorts);
        }
        return portsMap;
    }

    private Map<String, Set<String>> resolveOptionGroupsFromContainerImage(URI imageUri) {
        String imageName = imageUri.getSchemeSpecificPart();
        Map<String, String> labels = this.containerImageMetadataResolver.getImageLabels(imageName);
        if (CollectionUtils.isEmpty(labels)) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> groupingsMap = new HashMap<String, Set<String>>();
        labels.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CONFIGURATION_PROPERTIES_OPTION_GROUPS)).forEach(e -> {
            String gKey = ((String)e.getKey()).substring(CONFIGURATION_PROPERTIES_OPTION_GROUPS.length() + 1);
            groupingsMap.put(gKey, new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)((String)e.getValue()), (String)",", (String)" "))));
        });
        return groupingsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ConfigurationMetadataProperty> listProperties(Archive archive, boolean exhaustive) {
        try (URLClassLoader moduleClassLoader = new BootClassLoaderFactory(archive, this.parent).createClassLoader();){
            ArrayList<ConfigurationMetadataProperty> result = new ArrayList<ConfigurationMetadataProperty>();
            PathMatchingResourcePatternResolver moduleResourceLoader = new PathMatchingResourcePatternResolver((ClassLoader)moduleClassLoader);
            HashSet<String> visibleClasses = new HashSet<String>(this.globalVisibleClasses);
            HashSet<String> visibleProperties = new HashSet<String>(this.globalVisibleProperties);
            this.loadVisible(BootApplicationConfigurationMetadataResolver.visibleConfigurationMetadataResources(moduleClassLoader), visibleClasses, visibleProperties);
            ConfigurationMetadataRepositoryJsonBuilder builder = ConfigurationMetadataRepositoryJsonBuilder.create();
            for (Resource r : moduleResourceLoader.getResources(CONFIGURATION_METADATA_PATTERN)) {
                builder.withJsonResource(r.getInputStream());
            }
            for (ConfigurationMetadataGroup group : builder.build().getAllGroups().values()) {
                if (exhaustive || this.isVisible(group, visibleClasses)) {
                    for (ConfigurationMetadataProperty property : group.getProperties().values()) {
                        if (this.isDeprecatedError(property)) continue;
                        result.add(property);
                    }
                    continue;
                }
                if ("_ROOT_GROUP_".equals(group.getId())) {
                    for (ConfigurationMetadataProperty property : group.getProperties().values()) {
                        if (!this.isVisible(property, visibleProperties) || this.isDeprecatedError(property)) continue;
                        result.add(property);
                    }
                    continue;
                }
                for (ConfigurationMetadataProperty property : group.getProperties().values()) {
                    if (!this.isVisible(property, visibleProperties) || this.isDeprecatedError(property)) continue;
                    result.add(property);
                }
            }
            ArrayList<ConfigurationMetadataProperty> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception trying to list configuration properties for application " + archive, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Set<String>> listPortNames(Archive archive) {
        try (URLClassLoader moduleClassLoader = new BootClassLoaderFactory(archive, this.parent).createClassLoader();){
            HashSet<String> inboundPorts = new HashSet<String>();
            HashSet<String> outboundPorts = new HashSet<String>();
            HashMap<String, Set<String>> portsMap = new HashMap<String, Set<String>>();
            for (Resource resource : BootApplicationConfigurationMetadataResolver.visibleConfigurationMetadataResources(moduleClassLoader)) {
                Properties properties = new Properties();
                properties.load(resource.getInputStream());
                inboundPorts.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)properties.getProperty(CONFIGURATION_PROPERTIES_INBOUND_PORTS), (String)",", (String)" ")));
                portsMap.put("inbound", inboundPorts);
                outboundPorts.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)properties.getProperty(CONFIGURATION_PROPERTIES_OUTBOUND_PORTS), (String)",", (String)" ")));
                portsMap.put("outbound", outboundPorts);
            }
            HashMap<String, Set<String>> hashMap = portsMap;
            return hashMap;
        }
        catch (Exception e) {
            throw new AppMetadataResolutionException("Exception trying to list configuration properties for application " + archive, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Set<String>> listOptionGroups(Archive archive) {
        try (URLClassLoader moduleClassLoader = new BootClassLoaderFactory(archive, this.parent).createClassLoader();){
            HashMap<String, Set<String>> groupingsMap = new HashMap<String, Set<String>>();
            for (Resource resource : BootApplicationConfigurationMetadataResolver.visibleConfigurationMetadataResources(moduleClassLoader)) {
                Properties properties = new Properties();
                properties.load(resource.getInputStream());
                for (String key : properties.stringPropertyNames()) {
                    if (!key.startsWith(CONFIGURATION_PROPERTIES_OPTION_GROUPS)) continue;
                    String value = properties.getProperty(key);
                    String gKey = key.substring(CONFIGURATION_PROPERTIES_OPTION_GROUPS.length() + 1);
                    groupingsMap.put(gKey, new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)value, (String)",", (String)" "))));
                }
            }
            HashMap<String, Set<String>> hashMap = groupingsMap;
            return hashMap;
        }
        catch (Exception e) {
            throw new AppMetadataResolutionException("Exception trying to list configuration properties option groups for application " + archive, e);
        }
    }

    @Override
    public URLClassLoader createAppClassLoader(Resource app) {
        try {
            return new BootClassLoaderFactory(this.resolveAsArchive(app), this.parent).createClassLoader();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to resolve application resource: " + app.getDescription(), e);
        }
    }

    private Archive resolveAsArchive(Resource app) throws IOException {
        File moduleFile = app.getFile();
        return moduleFile.isDirectory() ? new ExplodedArchive(moduleFile) : new JarFileArchive(moduleFile);
    }

    private void loadVisible(Resource[] resources, Collection<String> classes, Collection<String> names) throws IOException {
        for (Resource resource : resources) {
            Properties properties = new Properties();
            properties.load(resource.getInputStream());
            classes.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)properties.getProperty(CONFIGURATION_PROPERTIES_CLASSES), (String)",", (String)" ")));
            names.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)properties.getProperty(CONFIGURATION_PROPERTIES_NAMES), (String)",", (String)" ")));
        }
    }

    private boolean isVisible(ConfigurationMetadataProperty property, Collection<String> properties) {
        return properties.contains(property.getId());
    }

    private boolean isDeprecatedError(ConfigurationMetadataProperty property) {
        return property.getDeprecation() != null && property.getDeprecation().getLevel() == Deprecation.Level.ERROR;
    }

    private boolean isVisible(ConfigurationMetadataGroup group, Collection<String> classes) {
        Set sourceTypes = group.getSources().keySet();
        return !sourceTypes.isEmpty() && classes.containsAll(sourceTypes);
    }
}

