/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner.support;

import java.util.Date;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.cloud.task.repository.TaskExecution;

public class UnexpectedTaskExecutionException
extends UnexpectedJobExecutionException
implements ExitCodeGenerator {
    private static final long serialVersionUID = 1080992679855603656L;
    private long executionId;
    private Long parentExecutionId;
    private Integer exitCode = -1;
    private String taskName;
    private Date startTime;
    private Date endTime;
    private String exitMessage;
    private String externalExecutionId;
    private String errorMessage;

    public UnexpectedTaskExecutionException(String message) {
        super(message);
    }

    public UnexpectedTaskExecutionException(String message, Throwable cause) {
        super(message, cause);
    }

    public UnexpectedTaskExecutionException(String message, TaskExecution taskExecution) {
        this(message);
        this.assignTaskExecutionFields(taskExecution);
    }

    public UnexpectedTaskExecutionException(String message, Throwable cause, TaskExecution taskExecution) {
        this(message, cause);
        this.assignTaskExecutionFields(taskExecution);
    }

    private void assignTaskExecutionFields(TaskExecution taskExecution) {
        if (taskExecution != null) {
            this.executionId = taskExecution.getExecutionId();
            this.parentExecutionId = taskExecution.getParentExecutionId();
            this.exitCode = taskExecution.getExitCode();
            this.taskName = taskExecution.getTaskName();
            this.startTime = taskExecution.getStartTime();
            this.endTime = taskExecution.getEndTime();
            this.externalExecutionId = taskExecution.getExternalExecutionId();
            this.errorMessage = taskExecution.getErrorMessage();
            this.exitMessage = taskExecution.getExitMessage();
        }
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Date getStartTime() {
        return this.startTime != null ? (Date)this.startTime.clone() : null;
    }

    public Date getEndTime() {
        return this.endTime != null ? (Date)this.endTime.clone() : null;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getExternalExecutionId() {
        return this.externalExecutionId;
    }

    public Long getParentExecutionId() {
        return this.parentExecutionId;
    }
}

