/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner.support;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfEnv;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class CfServiceBindingPropertySourceInitializer
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger log = LoggerFactory.getLogger(CfServiceBindingPropertySourceInitializer.class);
    public static final String PROPERTY_SOURCE_NAME = "p-dataflow";

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        CfEnv cfEnv = new CfEnv();
        try {
            CfCredentials credentials = cfEnv.findCredentialsByLabel(new String[]{PROPERTY_SOURCE_NAME});
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            propertiesMap.put("dataflowServerUri", credentials.getString(new String[]{"dataflow-url"}));
            propertiesMap.put("oauth2ClientCredentialsClientId", credentials.getString(new String[]{"client-id"}));
            propertiesMap.put("oauth2ClientCredentialsClientSecret", credentials.getString(new String[]{"client-secret"}));
            propertiesMap.put("oauth2ClientCredentialsTokenUri", credentials.getString(new String[]{"access-token-url"}));
            MapPropertySource propertySource = new MapPropertySource(PROPERTY_SOURCE_NAME, propertiesMap);
            event.getEnvironment().getPropertySources().addAfter("systemEnvironment", (PropertySource)propertySource);
        }
        catch (IllegalArgumentException e) {
            log.debug("No 'p-dataflow' service binding found in VCAP_SERVICES");
        }
    }
}

