/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import java.util.Collection;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.composedtaskrunner.support.OnOAuth2ClientCredentialsEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.endpoint.DefaultClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;

@Configuration
@Conditional(value={OnOAuth2ClientCredentialsEnabled.class})
public class DataFlowConfiguration {
    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository(ComposedTaskProperties properties) {
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"default").authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).tokenUri(properties.getOauth2ClientCredentialsTokenUri()).clientId(properties.getOauth2ClientCredentialsClientId()).clientSecret(properties.getOauth2ClientCredentialsClientSecret()).scope((Collection)properties.getOauth2ClientCredentialsScopes()).clientAuthenticationMethod(properties.getOauth2ClientCredentialsClientAuthenticationMethod()).build();
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{clientRegistration});
    }

    @Bean
    OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient() {
        return new DefaultClientCredentialsTokenResponseClient();
    }
}

