/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.composedtaskrunner.TaskExplorerContainer;
import org.springframework.cloud.dataflow.composedtaskrunner.TaskLauncherTasklet;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.core.Base64Utils;
import org.springframework.cloud.dataflow.rest.support.jackson.Jackson2DataflowModule;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.core.env.Environment;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

public class ComposedTaskRunnerStepFactory
implements FactoryBean<Step> {
    private static final Logger logger = LoggerFactory.getLogger(ComposedTaskRunnerStepFactory.class);
    @Autowired
    private ComposedTaskProperties composedTaskProperties;
    private ComposedTaskProperties composedTaskPropertiesFromEnv;
    private final String taskName;
    private final String taskNameId;
    private Map<String, String> taskSpecificProps = new HashMap();
    private List<String> arguments = new ArrayList();
    @Autowired
    private StepBuilderFactory steps;
    @Autowired
    private StepExecutionListener composedTaskStepExecutionListener;
    @Autowired
    private TaskExplorerContainer taskExplorerContainer;
    @Autowired
    private TaskProperties taskProperties;
    @Autowired(required=false)
    private ClientRegistrationRepository clientRegistrations;
    @Autowired(required=false)
    private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;
    @Autowired(required=false)
    private ObjectMapper mapper;
    @Autowired
    private Environment environment;

    public ComposedTaskRunnerStepFactory(ComposedTaskProperties composedTaskPropertiesFromEnv, String taskName, String taskNameId) {
        Assert.notNull((Object)composedTaskPropertiesFromEnv, (String)"composedTaskProperties must not be null");
        Assert.hasText((String)taskName, (String)"taskName must not be empty nor null");
        this.composedTaskPropertiesFromEnv = composedTaskPropertiesFromEnv;
        this.taskName = taskName;
        this.taskNameId = taskNameId;
    }

    public void setTaskSpecificProps(Map<String, String> taskSpecificProps) {
        if (taskSpecificProps != null) {
            this.taskSpecificProps = taskSpecificProps;
        }
    }

    public void setArguments(List<String> arguments) {
        if (arguments != null) {
            this.arguments = arguments;
        }
    }

    public Step getObject() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.registerModule((Module)new Jdk8Module());
            this.mapper.registerModule((Module)new Jackson2HalModule());
            this.mapper.registerModule((Module)new JavaTimeModule());
            this.mapper.registerModule((Module)new Jackson2DataflowModule());
        }
        TaskLauncherTasklet taskLauncherTasklet = new TaskLauncherTasklet(this.clientRegistrations, this.clientCredentialsTokenResponseClient, this.taskExplorerContainer.get(this.taskNameId), this.composedTaskPropertiesFromEnv, this.taskName, this.taskProperties, this.environment, this.mapper);
        List argumentsFromAppProperties = Base64Utils.decodeMap((Map)this.composedTaskProperties.getComposedTaskAppArguments()).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("app." + this.taskNameId + ".") || ((String)e.getKey()).startsWith("app.*.")).map(Map.Entry::getValue).collect(Collectors.toList());
        List argumentsToUse = Stream.concat(this.arguments.stream(), argumentsFromAppProperties.stream()).collect(Collectors.toList());
        taskLauncherTasklet.setArguments(argumentsToUse);
        logger.debug("decoded composed-task-app-properties {}", (Object)this.composedTaskProperties.getComposedTaskAppProperties());
        Map<String, String> propertiesFrom = Base64Utils.decodeMap((Map)this.composedTaskProperties.getComposedTaskAppProperties()).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("app." + this.taskNameId + ".") || ((String)e.getKey()).startsWith("app.*.") || ((String)e.getKey()).startsWith("deployer." + this.taskNameId + ".") || ((String)e.getKey()).startsWith("deployer.*.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, String> propertiesToUse = new HashMap<String, String>();
        propertiesToUse.putAll(this.taskSpecificProps);
        propertiesToUse.putAll(propertiesFrom);
        taskLauncherTasklet.setProperties(propertiesToUse);
        logger.debug("Properties to use {}", propertiesToUse);
        return ((AbstractTaskletStepBuilder)this.steps.get(this.taskName).tasklet((Tasklet)taskLauncherTasklet).transactionAttribute(this.getTransactionAttribute()).listener(this.composedTaskStepExecutionListener)).build();
    }

    private TransactionAttribute getTransactionAttribute() {
        DefaultTransactionAttribute defaultTransactionAttribute = new DefaultTransactionAttribute();
        defaultTransactionAttribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return defaultTransactionAttribute;
    }

    public Class<?> getObjectType() {
        return Step.class;
    }
}

